// mwDICOMClient.h: interface for the mwDICOMClient class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_MWDICOMCLIENT_H_)
#define _MWDICOMCLIENT_H_

#if defined(__GNUG__) && !defined(__APPLE__)
    #pragma interface "mwDICOMClient.h"
#endif

#include "tcpsocket.h"

DECLARE_EVENT_TYPE(mwEVT_USER_INFO, 3400)

//   
// 1 -  64    626270 set_key64 (key)
// 2 -  crypted_name
// 3 -  cs  name_len...64 ,   cs2
// 4 -      version..72 ,   cs1
// 5 -  64    626270 set_key64 (key)
// 6 -     version..72 
// 7 -      ,   cs0

#pragma pack(push, 1)

struct login_pkt {
	wxUint32 len;
	wxUint32 cs0;
	char key[32]; // NOT/HEX
	wxUint32 version; // packet version ?
	wxUint32 srv_addr;
	wxUint32 port;
	wxUint32 protocol;
	wxUint32 srv_num;
	wxUint32 cs1;
	wxUint32 name_len;
	wxUint32 cs2; //     name_len 64 
	char crypted_name[40]; //  
};

struct login_pkt2 {
	wxUint16 len;
	wxUint16 reserved1; // ????
	wxUint32 version; // packet version ?
	wxUint32 srv_addr;
	wxUint32 port;
	wxUint32 protocol;
	wxUint32 name_len;
	char name[40]; //  
};

struct log_reply_pkt {
	wxUint32 len;
	wxUint32 cs0;
	wxUint16 version; // packet server version ? 0x416
	wxUint16 dummy1; // 00 00
	wxUint32 enabled;
	wxUint32 srv_addr;
	wxUint32 port;
	wxUint32 protocol;
	wxUint32 name_cs; // ??
	wxUint32 dummy3; //????? 0x13481CEA
	wxUint32 dummy4;
	char name0[10]; // crypt(0)  
	unsigned char tmp1[34];
	char card_num[33]; //  
	wxUint32 msg1_len;
	wxUint32 msg2_len;
	char messages[75];
};

struct log_reply_pkt2 {
	wxUint16 len;
	wxUint8 log_ff;
	wxUint8 log_func;
	wxUint32 enabled;
	wxUint16 protocol0;
	wxUint16 protocol1;
	wxUint32 srv_addr;
	wxUint32 port;
	wxUint32 protocol2;
	wxUint32 protocol3;
	char unknown[40];
	char messages[256];
};

struct log_reply_pkt1055 {
	wxUint16 len;
	wxUint8 log_ff;
	wxUint8 log_func;
	wxUint32 enabled;
	wxUint16 protocol0;
	wxUint16 protocol1;
	wxUint32 srv_addr;
	wxUint32 port;
	wxUint32 protocol2;
	wxUint32 protocol3;
	wxUint32 protocol4;
	wxUint32 protocol5;
	wxUint32 protocol6;
	wxUint32 protocol7;
	char unknown[40];
	char messages[256];
};

struct game_data_pkt1056 {
	wxUint16 len;
	wxUint8 log_ff;
	wxUint8 log_func;
	wxUint32 data1;
	wxUint32 data2;
	wxUint32 data3;
	char reserved[256];
};

#pragma pack(pop)

class client : public wxThread
{
public:
	client();
	virtual ~client();
	wxUint32 checksum(char *buf, int len);
	void login1(char *keykey, login_pkt2 *request);
	void login2(char *keykey, login_pkt2 *request);
	void send_game_data(char *keykey, login_pkt2 *request);

	bool Create(TCPSocket& socket, int port, int protocol, wxUint32 address);
	void SetHandler(wxEvtHandler *handler) { m_handler = handler; }
	virtual ExitCode Entry();
protected:
	int m_port;
	int m_protocol;
	wxUint32 m_address;
	wxEvtHandler *m_handler;
private:
	TCPSocket m_sock;
};

#endif
