#if defined(__GNUG__) && !defined(__APPLE__)
#pragma implementation "l2srvdlg.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "l2srvdlg.h"

#include "server.h"
#include "client.h"

////@begin XPM images
////@end XPM images

/*!
 * l2srvdlg type definition
 */

IMPLEMENT_DYNAMIC_CLASS( l2srvdlg, wxDialog )

/*!
 * l2srvdlg event table definition
 */

BEGIN_EVENT_TABLE( l2srvdlg, wxDialog )

	EVT_COMMAND(-1, mwEVT_USER_INFO, l2srvdlg::OnUserInfo)
    EVT_CLOSE( l2srvdlg::OnCloseWindow )

END_EVENT_TABLE()

/*!
 * l2srvdlg constructors
 */

l2srvdlg::l2srvdlg( )
{
	for (int index=0; index<server_num; index++) {
		m_servers[index] = NULL;
	}
}

l2srvdlg::~l2srvdlg()
{
	for (int index=0; index<server_num; index++) {
		if (m_servers[index]) {
			m_servers[index]->Cancel();
			m_servers[index]->Delete();
			m_servers[index] = NULL;
		}
	}
}

l2srvdlg::l2srvdlg( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
	for (int index=0; index<server_num; index++) {
		m_servers[index] = NULL;
	}
    Create(parent, id, caption, pos, size, style);
}

/*!
 * l2srvdlg creator
 */

bool l2srvdlg::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin l2srvdlg member initialisation
    m_logCtl = NULL;
////@end l2srvdlg member initialisation

////@begin l2srvdlg creation
    SetExtraStyle(GetExtraStyle()|wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    Centre();
////@end l2srvdlg creation
    return TRUE;
}

/*!
 * Control creation for l2srvdlg
 */

void l2srvdlg::CreateControls()
{    
////@begin l2srvdlg content construction
    l2srvdlg* itemDialog1 = this;

    wxFlexGridSizer* itemFlexGridSizer2 = new wxFlexGridSizer(1, 1, 0, 0);
    itemFlexGridSizer2->AddGrowableRow(0);
    itemFlexGridSizer2->AddGrowableCol(0);
    itemDialog1->SetSizer(itemFlexGridSizer2);

    m_logCtl = new wxTextCtrl( itemDialog1, ID_TEXTCTRL1, _T(""), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE );
    itemFlexGridSizer2->Add(m_logCtl, 0, wxGROW|wxGROW|wxALL, 5);

////@end l2srvdlg content construction

	m_port = 0x83a;
	m_protocol = 553;

	hostent* remoteHost;

	remoteHost = gethostbyname("L2authd.Lineage2.com");
	if (remoteHost) {
		m_address = *(wxUint32 *)remoteHost->h_addr_list[0];
	}

	m_servers[0] = new server();
	m_servers[0]->Create(0x1389, m_port, m_protocol, m_address);
	m_servers[0]->SetHandler(this);
	m_servers[0]->Run();
	m_servers[1] = new server();
	m_servers[1]->Create(0x138a, m_port, m_protocol, m_address);
	m_servers[1]->SetHandler(this);
	m_servers[1]->Run();
	m_servers[2] = new server();
	m_servers[2]->Create(0x138b, m_port, m_protocol, m_address);
	m_servers[2]->SetHandler(this);
	m_servers[2]->Run();
	m_servers[3] = new server();
	m_servers[3]->Create(0x138c, m_port, m_protocol, m_address);
	m_servers[3]->SetHandler(this);
	m_servers[3]->Run();

	m_logCtl->AppendText("version_3_0 [10.5.7]\n");
}

/*!
 * Should we show tooltips?
 */

bool l2srvdlg::ShowToolTips()
{
    return TRUE;
}

/*!
 * Get bitmap resources
 */

wxBitmap l2srvdlg::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin l2srvdlg bitmap retrieval
    return wxNullBitmap;
////@end l2srvdlg bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon l2srvdlg::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin l2srvdlg icon retrieval
    return wxNullIcon;
////@end l2srvdlg icon retrieval
}

void l2srvdlg::OnCloseWindow( wxCloseEvent& event )
{
	Destroy();
}

void l2srvdlg::OnUserInfo( wxCommandEvent& event )
{
	m_logCtl->AppendText(wxString::Format("%s\n", event.GetString()));
}
