#ifndef WORKTHRD_H
#define WORKTHRD_H

class mwWorkThread;

class mwNotifyThreadParent
{
public:
  virtual void NotifyClose(mwWorkThread * thread)
  {
  }
};

class mwWorkThread : public
   wxThread
{
public:
   mwWorkThread() : wxThread(wxTHREAD_JOINABLE)
  {
    m_resume_event = new wxCondition(m_mutex);
    m_cancel = false;
    m_parent = NULL;
  }
  virtual ~mwWorkThread()
  {
	  wxDELETE(m_resume_event);
  }
  bool Create()
  {
	  if (wxThread::Create()!=wxTHREAD_NO_ERROR)
		  return false;
	  return true;
  }
  virtual void
  Cancel()
  {
    m_cs.Enter();
    m_cancel = true;
    m_cs.Leave();
  }
  virtual
     bool
  TestCancel()
  {
    wxCriticalSectionLocker lock(m_cs);
    return m_cancel;
  }
  virtual void
  ResumeEvent()
  {
    wxCriticalSectionLocker lock(m_cs);
//    wxMutexLocker lock(m_mutex);
    m_resume_event->Signal();
  }
  virtual void
  ResetResumeEvent()
  {
    wxCriticalSectionLocker lock(m_cs);
//    m_resume_event.Reset();
  }
  void
  SetParent(mwNotifyThreadParent * parent)
  {
    m_parent = parent;
  }
  virtual void OnExit()
  {
    if (m_parent)
      m_parent->NotifyClose(this);
  }
  virtual ExitCode Entry()
  {
	  run();
	  OnExit();
	  return (ExitCode) wxTHREAD_NO_ERROR;
  }
  virtual void run() = 0;
protected:
  bool m_cancel;
  wxCriticalSection m_cs;
  wxMutex m_mutex;
  wxCondition *m_resume_event;

  mwNotifyThreadParent *
     m_parent;
};

#endif
