// server.cpp: implementation of the server class.
//
//////////////////////////////////////////////////////////////////////
#ifdef __GNUG__
    #pragma implementation "server.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include <wx/filename.h>
#include <wx/config.h>
#include <wx/confbase.h>
#include <wx/fileconf.h>

#include "server.h"
#include "client.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

server::server()
{
	m_handler = NULL;
}

server::~server()
{
}

void server::run()
{
	if (!m_sock.Listen())
		return ;

	while (!TestCancel() && !TestDestroy()) {
		if (m_sock.WaitConnection(500)) {
			if (m_sock.Accept()) {
				client *clnt = new client();
				if (!clnt || !clnt->Create(m_sock, m_port, m_protocol, m_address)) {
					wxDELETE(clnt);
				} else {
					clnt->SetHandler(m_handler);
					clnt->Run();
				}
			}
		}
	}
}

bool server::Create(int port, int lport, int protocol, wxUint32 address)
{
	m_port = lport;
	m_protocol = protocol;
	m_address = address;

	if (!m_sock.Create(port, TCP, false))
		return false;

	return mwWorkThread::Create();
}
