unit AutoUnit;

interface

{felhasznalt unitok:
 Dialogs - tartalmazza a ShowMessage eljarast,
 SysUtils - tartalmazza a Format fugvenyt,
 Math - tartalmazza a Min fuggvenyt}

uses
  Dialogs, SysUtils, Math;

{osztlyok definialasa}

type
 TAuto = class
  protected
   Tipus: String;
   GyartasiEv, Benzin, Kapacitas: Integer;
  public
   constructor Create(TTipus: String;
               GGyartasiEv, BBenzin, KKapacitas: Integer);
   procedure InfoKiir; virtual;
   function Tankolj(Mennyit: Integer): Boolean;
   procedure EvValtoztatasa; virtual; abstract;
 end;

Type
 TTeherauto = class(TAuto)
  private
   Teherbiras: Integer;
  public
   constructor Create(TTipus: String;
               GGyartasiEv, BBenzin, KKapacitas,
               TTeherbiras: Integer);
   procedure InfoKiir; override;
  end;

implementation

{metdusok implementacioja}

constructor TTeherauto.Create(TTipus: String;
            GGyartasiEv, BBenzin, KKapacitas,
            TTeherbiras: Integer);
begin
  inherited Create(TTipus, GGyartasiEv, BBenzin, KKapacitas);
  Teherbiras := TTeherbiras;
end;

procedure TTeherauto.InfoKiir;
begin
  ShowMessage(Format('%s, %d: %d (%d). Teherbiras = %d',
    [Tipus, GyartasiEv, Benzin, Kapacitas, Teherbiras]));
end;

constructor TAuto.Create(TTipus: String;
            GGyartasiEv, BBenzin, KKapacitas: Integer);
begin
  inherited Create;
  Tipus := TTipus;
  GyartasiEv := GGyartasiEv;
  Benzin := BBenzin;
  Kapacitas := KKapacitas;
end;

procedure TAuto.InfoKiir;
begin
  ShowMessage(Format('%s, %d: %d (%d).',
    [Tipus, GyartasiEv, Benzin, Kapacitas]));
end;

function TAuto.Tankolj(Mennyit: Integer): Boolean;
begin
  Result := (Benzin + Mennyit) <= Kapacitas;
  Benzin := Min(Kapacitas, (Benzin + Mennyit));
end;

end.
