unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    Memo1: TMemo;
    procedure Memo1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Memo1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure FileListBox1EndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
 DirectoryListBox1.FileList := FileListBox1;
 FileListBox1.DragMode := dmAutomatic;
 Mouse.DragImmediate := false;
end;

procedure TForm1.FileListBox1EndDrag(Sender, Target: TObject; X, Y: Integer);
begin
 if Mouse.IsDragging then
   if (Target <> nil) then
     ShowMessage('Az llomny sikeresen t lett hzva a komponensbe.')
   else
     ShowMessage('Az llomnyt nem sikerlt thzni!');
end;

procedure TForm1.Memo1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := Source is TFileListBox;
end;

procedure TForm1.Memo1DragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  if Source is TFileListBox then
    Memo1.Lines.LoadFromFile(FileListBox1.FileName);
end;

end.
