unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  DoubleBuffered := true;
end;

procedure TForm1.FormPaint(Sender: TObject);
var
  deltaR, deltaG, deltaB: Double;
  szinTol, szinIg: TColor;
  i: Integer;
begin
  // kezdeti belltsok
  szinTol := clRed;
  szinIg := clYellow;
  // egyes szinsszetevk nvekmnye
  deltaR := (GetRValue(szinIg)-GetRValue(szinTol)) / Width;
  deltaG := (GetGValue(szinIg)-GetGValue(szinTol)) / Width;
  deltaB := (GetBValue(szinIg)-GetBValue(szinTol)) / Width;
  // rajzolas
  for i:=0 to Width do
    begin
      Canvas.Brush.Color := RGB (
        Round(deltaR*i+GetRValue(szinTol)),
        Round(deltaG*i+GetGValue(szinTol)),
        Round(deltaB*i+GetBValue(szinTol)));
      Canvas.FillRect(Rect(i,0,i+1,Height));
    end;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  Repaint;
end;

end.
