unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Clipbrd, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    kovHandle: HWND;
    procedure OnDrawClipboard(var msg: TWMDrawClipboard); message WM_DRAWCLIPBOARD;
    procedure OnChangeCBChain(var msg: TWMChangeCBChain); message WM_CHANGECBCHAIN;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  {besoroljuk a lancba az ablakunkat}
  kovHandle := SetClipboardViewer(Handle);
end;

procedure TForm1.OnDrawClipboard(var msg: TWMDrawClipboard);
begin
  {ha szoveg van a vagolapon, berakjuk a memo-ba}
  if Clipboard.HasFormat(CF_TEXT) then
    Memo1.Lines.Add(Clipboard.AsText);
  {tovabbkuldjuk az uzenetet}
  SendMessage(kovHandle, WM_DRAWCLIPBOARD, 0, 0);
end;

procedure TForm1.OnChangeCBChain(var msg: TWMChangeCBChain);
begin
  {ha a mi utanunk kovetkezo jelentkezik ki a
   lancbol, akkor megvaltoztatjuk a kovHandle-t}
  if msg.Remove = kovHandle then kovHandle := msg.Next
  else {egyebkent tovabbkuldjuk az uzenetet}
    SendMessage(kovHandle, WM_CHANGECBCHAIN, msg.Remove, msg.Next);
end;


procedure TForm1.FormDestroy(Sender: TObject);
begin
  {kijelentkezunk a lancbol}
  ChangeClipboardChain(Handle, kovHandle);
end;

end.
