unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    a: array[1..50] of TImage;
    n: integer;
    cs: TBitmap;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
{$R kepek.res}

procedure TForm1.FormCreate(Sender: TObject);
var
  res: TResourceStream;
begin
  DoubleBuffered := true;
  n := 0;
  res := TResourceStream.Create(HInstance,'csillag',RT_RCDATA);
  cs := TBitmap.Create;
  cs.LoadFromStream(res);
  res.Free;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if n<50 then begin
               a[n+1] := TImage.Create(Self);
               a[n+1].Parent := Self;
               a[n+1].Enabled := false;
               a[n+1].Autosize := true;
               a[n+1].Transparent := true;
               a[n+1].Picture.Bitmap := cs;
               a[n+1].Left := X - a[n+1].Width div 2;
               a[n+1].Top := Y - a[n+1].Height div 2;
               inc(n);
               end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  i: integer;
begin
  for i:=1 to n do a[i].Free;
  cs.Free;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  i: integer;
begin
  for i:=1 to n do begin
                   a[i].Top := a[i].Top+1;
                   if a[i].Top > Height then a[i].Top := -a[i].Height;
                   a[i].Left := a[i].Left
                                 - round(sin((a[i].Top-1)*PI/180*5)*90)
                                 + round(sin(a[i].Top*PI/180*5)*90);
                   if a[i].Left<-a[i].Width then a[i].Left := Width;
                   if a[i].Left>Width then a[i].Left := -a[i].Width;
                   end;
end;

end.
