unit Unit2;

interface

uses ExtCtrls,Graphics;

type TGrafObj = class
                private
                  x,y: integer;
                  dx,dy: integer;
                  kep: TImage;
                public
                  constructor Create(kx,ky,kdx,kdy:integer; kkep:TImage);
                  procedure kirajzol; virtual; abstract;
                  procedure letorol; virtual; abstract;
                  procedure mozdul;
                end;

      TKor = class (TGrafObj)
             private
               s:integer;
             public
               constructor Create(kx,ky,kdx,kdy,ks:integer; kkep:Timage);
               procedure kirajzol; override;
               procedure letorol; override;
             end;

      TTeglalap = class (TGrafObj)
                  private
                    a,b:integer;
                  public
                    constructor Create(kx,ky,kdx,kdy,ka,kb:integer; kkep:Timage);
                    procedure kirajzol; override;
                    procedure letorol; override;
                  end;

      THaromszog = class (TGrafObj)
                   private
                     a,m:integer;
                   public
                     constructor Create(kx,ky,kdx,kdy,ka,km:integer; kkep:TImage);
                     procedure kirajzol; override;
                     procedure letorol; override;
                   end;

implementation

constructor TGrafObj.Create;
begin
 x:=kx;
 y:=ky;
 dx:=kdx;
 dy:=kdy;
 kep:=kkep;
 kirajzol;
end;

procedure TGrafObj.mozdul;
begin
 letorol;
 if (x+dx>kep.Width) or (x+dx<0) then dx:=-dx;
 x:=x+dx;
 if (y+dy>kep.Height) or (y+dy<0) then dy:=-dy;
 y:=y+dy;
 kirajzol;
end;

constructor TKor.Create;
begin
 s:=ks;
 inherited Create(kx,ky,kdx,kdy,kkep);
end;

procedure TKor.kirajzol;
begin
 kep.Canvas.pen.Width := 2;
 kep.Canvas.Pen.Color := clRed;
 kep.Canvas.Ellipse(x-s,y-s,x+s,y+s);
end;

procedure TKor.letorol;
begin
 kep.Canvas.pen.Width := 2;
 kep.Canvas.Pen.Color := clWhite;
 kep.Canvas.Ellipse(x-s,y-s,x+s,y+s);
end;

constructor TTeglalap.Create;
begin
 a:=ka;
 b:=kb;
 inherited Create(kx,ky,kdx,kdy,kkep);
end;

procedure TTeglalap.kirajzol;
begin
 kep.Canvas.pen.Width := 2;
 kep.Canvas.Pen.Color := clGreen;
 kep.Canvas.Rectangle(x - a div 2, y - b div 2,
                      x + a div 2, y + b div 2);
end;

procedure TTeglalap.letorol;
begin
 kep.Canvas.pen.Width := 2;
 kep.Canvas.Pen.Color := clWhite;
 kep.Canvas.Rectangle(x - a div 2, y - b div 2,
                      x + a div 2, y + b div 2);
end;

constructor THaromszog.Create;
begin
 a:=ka;
 m:=km;
 inherited Create(kx,ky,kdx,kdy,kkep);
end;

procedure THaromszog.kirajzol;
begin
 kep.Canvas.pen.Width := 2;
 kep.Canvas.Pen.Color := clBlack;
 kep.Canvas.MoveTo(x - a div 2, y + m div 2);
 kep.Canvas.LineTo(x + a div 2, y + m div 2);
 kep.Canvas.LineTo(x, y - m div 2);
 kep.Canvas.LineTo(x - a div 2, y + m div 2);
 kep.Canvas.FloodFill(x,y,clBlack,fsBorder);
 kep.Canvas.Pen.Color := clBlue;
 kep.Canvas.MoveTo(x - a div 2, y + m div 2);
 kep.Canvas.LineTo(x + a div 2, y + m div 2);
 kep.Canvas.LineTo(x, y - m div 2);
 kep.Canvas.LineTo(x - a div 2, y + m div 2);
end;

procedure THaromszog.letorol;
begin
 kep.Canvas.pen.Width := 2;
 kep.Canvas.Pen.Color := clWhite;
 kep.Canvas.MoveTo(x - a div 2, y + m div 2);
 kep.Canvas.LineTo(x + a div 2, y + m div 2);
 kep.Canvas.LineTo(x, y - m div 2);
 kep.Canvas.LineTo(x - a div 2, y + m div 2);
end;


end.
