unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Unit2, StdCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Image2: TImage;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var
  g1, g2: TGolyoSzal;

procedure TForm1.FormCreate(Sender: TObject);
begin
  DoubleBuffered := true;
  g1 := TGolyoSzal.Create(Image1, tpLower);
  g2 := TGolyoSzal.Create(Image2, tpLowest);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if g1.Suspended then g1.Resume;
  if g2.Suspended then g2.Resume;
  g1.Terminate;
  g2.Terminate;
  g1.Free;
  g2.Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  g1.Resume;
  g2.Resume;
  Button1.Enabled := false;
  Button2.Enabled := true;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  g1.Suspend;
  g2.Suspend;
  Button1.Enabled := true;
  Button2.Enabled := false;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Close;
end;

end.
