--[[
PSP Air Hockey Version Marvin Version
by Carlos Aldana AKA indianajonesilm

Thanks to Shine and nevyn for LUA Player!
Thanks to Shine for menu example code!
Thanks to nevyn for paddle movement acceleration!

Mods by djslick
- Enhanced physics and ai engine
- 2 player AI
- Marvin the Martian theme
--]]

-- load images
   debug = false
   paddleimg = Image.load("pad.png")
   background = Image.load("background.png")
   backgroundlarge = Image.load("backgroundlarge.png")
   background2 = Image.load("background2.png")
   background2large = Image.load("background2large.png")
   splash = Image.load("luasplash.png")
   puck1img = Image.load("puck1.png")
   puck2img = Image.load("puck2.png")
   puck3img = Image.load("puck3.png")
   puck4img = Image.load("puck4.png")
   puck5img = Image.load("puck5.png")
   puck6img = Image.load("puck6.png")
   puck7img = Image.load("puck7.png")
   puck8img = Image.load("puck8.png")
   puck9img = Image.load("puck9.png")
   puck10img = Image.load("puck10.png")
   puck11img = Image.load("puck11.png")
   puck12img = Image.load("puck12.png")
   puck13img = Image.load("puck13.png")
   puck14img = Image.load("puck14.png")
   puck15img = Image.load("puck15.png")
   puck16img = Image.load("puck16.png")
   puck17img = Image.load("puck17.png")
   puck18img = Image.load("puck18.png")
   puck19img = Image.load("puck19.png")
   puck20img = Image.load("puck20.png")
   puck21img = Image.load("puck21.png")
   puck22img = Image.load("puck22.png")
   puck23img = Image.load("puck23.png")
   puck24img = Image.load("puck24.png")

   puckimg = puck1img
   puckIndx = 1
   menuimg = Image.load("menu.png")
   mainmenuimg = Image.load("mainmenu.png")



-- load sounds
   goalsnd = Sound.load("goal.wav")
   hitsnd = Sound.load("hit.wav")
   wallsnd = Sound.load("wall.wav")
   boltsnd= Sound.load("comp.wav")
   angry= Sound.load("angry.wav")
   disgrace= Sound.load("disgrace.wav")
   boom= Sound.load("boom.wav")

--default values
options = { background = 2,
            goalsize = 1,
            music = 1,
            difficulty = 2 }

possibleOptions = {
   background = {
      displayName = "Background Image",
      values = { 1, 2} },
   goalsize = {
      displayName = "Goal Size",
      values = { 1, 2} },
   music = {
      displayName = "Music",
      values = { 1, 2, 3} },
   difficulty = {
      displayName = "Difficulty",
      values = { 1, 2, 3} }
}

puckvel = 8
accel = .6
accela = 1

red = Color.new(255, 0, 0)
black = Color.new(0, 0, 0)

-- set up paddle start positions
   paddle = {{}, {}}
   paddle[1].x = 70
   paddle[1].y = 120
   paddle[1].xa = 0
   paddle[1].ya = 0
   paddle[2].x = 378
   paddle[2].y = 120
   paddle[2].xa = 0
   paddle[2].ya = 0

-- set up puck start position for testing purposes
   puck_pos = {{},{}}
   puck_pos.x = 224
   puck_pos.y = 120

   puck_center = {{},{}}
   puck_center.x = puck_pos.x + 16
   puck_center.y = puck_pos.y + 16

   paddle_center = {{},{}}
   paddle_center[1].x = paddle[1].x + 16
   paddle_center[1].y = paddle[1].y + 16
   paddle_center[2].x = paddle[2].x + 16
   paddle_center[2].y = paddle[2].y + 16

   puck_velocity = {{},{}}


-- Function for paddle movement
function keyboardControl()

   pad = Controls.read()

if players ~= 0 then
   if pad:up() then
      paddle[1].ya = paddle[1].ya -accel
   elseif pad:down() then
      paddle[1].ya = paddle[1].ya +accel
   end

   if pad:left() then
      paddle[1].xa = paddle[1].xa -accel
   elseif pad:right() then
      paddle[1].xa = paddle[1].xa +accel
   end
end

if players == 2 then
   if pad:triangle() then
      paddle[2].ya = paddle[2].ya -accel
   elseif pad:cross() then
      paddle[2].ya = paddle[2].ya +accel
   end

   if pad:square() then
      paddle[2].xa = paddle[2].xa -accel
   elseif pad:circle() then
      paddle[2].xa = paddle[2].xa +accel
   end
end

if players ~= 0 then
   dx = pad:analogX()
   if math.abs(dx) > 32 then
      if dx > 32 then
         paddle[1].xa = ((paddle[1].xa + dx) / 32) +accela
      elseif dx < 32 then
         paddle[1].xa = ((paddle[1].xa + dx) / 32) -accela
      end
   end

   dy = pad:analogY()
   if math.abs(dy) > 32 then
      if dy > 32 then
         paddle[1].ya = ((paddle[1].ya + dy) / 32) +accela
      elseif dy < 32 then
         paddle[1].ya = ((paddle[1].ya + dy) / 32) -accela
      end
   end
end

   if pad:start() then
      screen.waitVblankStart(30)
      return "mmenu"
   end
end


--Function for paddle maximum movement border
function paddlemaxborder()
   border = {{}, {}}
   border[1].x = {5,202}
   border[1].y = {5,235}
   border[2].x = {244, 442}
   border[2].y = {5,235}

   for player, coords in ipairs(border) do
      for coord, borders in coords do
         if paddle[player][coord] < borders[1] then
            paddle[player][coord] = borders[1]
            paddle[player][coord.."a"] = -0.2*paddle[player][coord.."a"] -- slight bounce
         elseif paddle[player][coord] > borders[2] then
            paddle[player][coord] = borders[2]
            paddle[player][coord.."a"] = -0.2*paddle[player][coord.."a"]
         end
      end
   end
end

--Function that determines wether or not the puck has collided with a wall.
function didPuckWallCollide()

-- player 1 section

   if puck_center.x - 16 <= 240 then
      if puck_pos.x <= 5 and puck_pos.y <= 79 then
         wallsnd:play()
         puck_pos.x = puck_pos.x - puck_velocity.x
         puck_velocity.x = -puck_velocity.x
      end
      if puck_pos.x <= 5 and puck_pos.y >= 161 then
         wallsnd:play()
         puck_pos.x = puck_pos.x - puck_velocity.x
         puck_velocity.x = -puck_velocity.x
      end
   end

-- player 2 section

   if puck_center.x + 16 >= 240 then
      if puck_pos.x >= 443 and puck_pos.y <= 79 then
         wallsnd:play()
         puck_pos.x = puck_pos.x - puck_velocity.x
         puck_velocity.x = -puck_velocity.x
      end

      if puck_pos.x >= 443 and puck_pos.y >= 161 then
         wallsnd:play()
         puck_pos.x = puck_pos.x - puck_velocity.x
         puck_velocity.x = -puck_velocity.x
      end
   end

-- upper and lower borders

   if puck_pos.y <= 5 then
      wallsnd:play()
      puck_pos.y = puck_pos.y - puck_velocity.y
      puck_velocity.y = -puck_velocity.y
   end

   if puck_pos.y >= 235 then
      wallsnd:play()
      puck_pos.y = puck_pos.y - puck_velocity.y
      puck_velocity.y = -puck_velocity.y
   end
end

function didPuckWallCollide2()

-- player 1 section

   if puck_center.x - 16 <= 240 then
      if puck_pos.x <= 5 and puck_pos.y <= 57 then
         wallsnd:play()
         puck_pos.x = puck_pos.x - puck_velocity.x
         puck_velocity.x = -puck_velocity.x
      end
      if puck_pos.x <= 5 and puck_pos.y >= 183 then
         wallsnd:play()
         puck_pos.x = puck_pos.x - puck_velocity.x
         puck_velocity.x = -puck_velocity.x
      end
   end

-- player 2 section

   if puck_center.x + 16 >= 240 then
      if puck_pos.x >= 443 and puck_pos.y <= 57 then
         wallsnd:play()
         puck_pos.x = puck_pos.x - puck_velocity.x
         puck_velocity.x = -puck_velocity.x
      end

      if puck_pos.x >= 443 and puck_pos.y >= 183 then
         wallsnd:play()
         puck_pos.x = puck_pos.x - puck_velocity.x
         puck_velocity.x = -puck_velocity.x
      end
   end

-- upper and lower borders

   if puck_pos.y <= 5 then
      wallsnd:play()
      puck_pos.y = puck_pos.y - puck_velocity.y
      puck_velocity.y = -puck_velocity.y
   end
   if puck_pos.y >= 235 then
      wallsnd:play()
      puck_pos.y = puck_pos.y - puck_velocity.y
      puck_velocity.y = -puck_velocity.y
   end
end

--Function that determines wether or not the puck has entered a goal.
function isPuckInGoal()
   if puck_pos.x < 5 and puck_pos.y > 79 and puck_pos.y < 161 then
      score1 = score1 +1
      goalsnd:play()
      return "true"
   end

   if puck_pos.x > 443 and puck_pos.y > 79 and puck_pos.y < 161 then
      score2 = score2 +1
      goalsnd:play()
      return "true"
   end

end
function isPuckInGoal2()
   if puck_pos.x < 5 and puck_pos.y > 57 and puck_pos.y < 183 then
      score1 = score1 +1
      goalsnd:play()
      return "true"
   end

   if puck_pos.x > 443 and puck_pos.y > 57 and puck_pos.y < 183 then
      score2 = score2 +1
      goalsnd:play()
      return "true"
   end

end


--Function that determines wether or not the puck has collided with a paddle.

--If the distance between the centers of the Paddle and the Puck are less than the sum of their radii then they intersect.

--This should work as long as the combined velocities does not make the objects pass through each other

function hasPuckPaddleCollided1()

   if puck_center.x - 16 <= 240 then
      xdist1 = math.abs (puck_center.x - paddle_center[1].x)
      ydist1 = math.abs (puck_center.y - paddle_center[1].y)
      if xdist1 <= 32 and ydist1 <= 32 then
         distance = math.sqrt(xdist1*xdist1 + ydist1*ydist1)
         if distance <= 32 then
            hitsnd:play()

            if distance < 32 then
              if paddle[1].xa > 0 or paddle[1].xa < 0 then
                 adjusted_x = 32 * xdist1 / distance
                 diff_x = math.floor(adjusted_x - xdist1)
                 if paddle_center[1].x < puck_center.x then
                    paddle_center[1].x = paddle_center[1].x - diff_x
                 elseif paddle_center[1].x > puck_center.x then
                    paddle_center[1].x = paddle_center[1].x + diff_x
                 end
              end
              if paddle[1].ya > 0 or paddle[1].ya < 0 then
                 adjusted_y = 32 * ydist1 / distance
                 diff_y = math.floor(adjusted_y - ydist1)
                 if paddle_center[1].y < puck_center.y then
                    paddle_center[1].y = paddle_center[1].y - diff_y
                 elseif paddle_center[1].y > puck_center.y then
                    paddle_center[1].y = paddle_center[1].y + diff_y
                 end
              end
              paddle[1].x = paddle_center[1].x - 16
              paddle[1].y = paddle_center[1].y - 16
            end

            return "collide1"
         end
      end
   end
end

function hasPuckPaddleCollided2()
   if puck_center.x + 16 >= 240 then
      xdist2 = math.abs (puck_center.x - paddle_center[2].x)
      ydist2 = math.abs (puck_center.y - paddle_center[2].y)
      if xdist2 <= 32 and ydist2 <= 32 then
         distance = math.sqrt(xdist2*xdist2 + ydist2*ydist2)
         if distance <= 32 then
            hitsnd:play()

            if distance < 32 then
              if paddle[2].xa > 0 or paddle[2].xa < 0 then
                 adjusted_x = 32 * xdist2 / distance
                 diff_x = math.floor(adjusted_x - xdist2)
                 if paddle_center[2].x < puck_center.x then
                    paddle_center[2].x = paddle_center[2].x - diff_x
                 elseif paddle_center[2].x > puck_center.x then
                    paddle_center[2].x = paddle_center[2].x + diff_x
                 end
              end
              if paddle[2].ya > 0 or paddle[2].ya < 0 then
                 adjusted_y = 32 * ydist2 / distance
                 diff_y = math.floor(adjusted_y - ydist2)
                 if paddle_center[2].y < puck_center.y then
                    paddle_center[2].y = paddle_center[2].y - diff_y
                 elseif paddle_center[2].y > puck_center.y then
                    paddle_center[2].y = paddle_center[2].y + diff_y
                 end
              end
              paddle[2].x = paddle_center[2].x - 16
              paddle[2].y = paddle_center[2].y - 16
            end

            return "collide2"
         end
      end
   end
end


--Function to calculate a new motion vector for the puck after it has collided with a paddle.
function ChangePuckVelocity1()

   --xcomp, ycomp = components of the velocity along X and y axes
   --xdist, ydist = x and y distance of the puck and paddle
   --val = magnitude of puck velocity
   --alpha = angle of the velocity vector
   --theta = angle created by the distance between paddle and puck
   --result = resultant vector of the deflecting puck
   --xmultiplier=1,ymultiplier=1 = transformation constants



   xmultiplier=1
   ymultiplier=1

   -- If puck is to the left of the paddle, move it to the right of the paddle.
   if puck_center.x < paddle_center[1].x then
   xmultiplier = -1
   end

   --If puck is above the paddle, move it below the paddle.
   if puck_center.y < paddle_center[1].y then
   ymultiplier = -1
   end

   --determine the x and y distances
   xdist = math.abs (puck_center.x - paddle_center[1].x)
   ydist = math.abs (puck_center.y - paddle_center[1].y)

   --transform the puck velocity
   xcomp = puck_velocity.x*xmultiplier
   ycomp = puck_velocity.y*ymultiplier
   val = math.sqrt(xcomp*xcomp + ycomp*ycomp)

   xcomp_pad = paddle[1].xa * -1 * xmultiplier
   ycomp_pad = paddle[1].ya * -1 * ymultiplier
   val_pad = math.sqrt(xcomp_pad*xcomp_pad + ycomp_pad*ycomp_pad) / 2

   -- get velocity and distance angles
   alpha = math.atan(ycomp/xcomp)
   theta = math.atan(ydist/xdist)

   if xcomp_pad ~= 0 then
      alpha_pad = math.atan(ycomp_pad/xcomp_pad)
   else
      alpha_pad = 0
   end

   --determine resultant angle of deflecting puck
   result = math.pi - 2*alpha - theta

   result_pad = math.pi - 2*alpha_pad - theta

   -- compute the actual velocity components by multiplying
   -- with the corresponding multipliers.

   puck_velocity.x = xmultiplier*math.abs(val*math.cos(result))
   puck_velocity.y = ymultiplier*math.abs(val*math.sin(result))

   paddle[1].xa = -1 * xmultiplier*math.abs(val_pad*math.cos(result_pad))
   paddle[1].ya = -1 * ymultiplier*math.abs(val_pad*math.sin(result_pad))
end

function ChangePuckVelocity2()

   xmultiplier=1
   ymultiplier=1

   -- If puck is to the left of the paddle, move it to the right of the paddle.
   if puck_center.x < paddle_center[2].x then
   xmultiplier = -1
   end

   --If puck is above the paddle, move it below the paddle.
   if puck_center.y < paddle_center[2].y then
   ymultiplier = -1
   end

   --determine the x and y distances
   xdist = math.abs (puck_center.x - paddle_center[2].x)
   ydist = math.abs (puck_center.y - paddle_center[2].y)

   --transform the puck velocity
   xcomp = puck_velocity.x*xmultiplier
   ycomp = puck_velocity.y*ymultiplier
   val = math.sqrt(xcomp*xcomp + ycomp*ycomp)

   xcomp_pad = paddle[2].xa * -1 * xmultiplier
   ycomp_pad = paddle[2].ya * -1 * ymultiplier
   val_pad = math.sqrt(xcomp_pad*xcomp_pad + ycomp_pad*ycomp_pad) / 2

   -- get velocity and distance angles
   alpha = math.atan(ycomp/xcomp)
   theta = math.atan(ydist/xdist)

   if xcomp_pad ~= 0 then
      alpha_pad = math.atan(ycomp_pad/xcomp_pad)
   else
      alpha_pad = 0
   end

   --determine resultant angle of deflecting puck
   result = math.pi - 2*alpha - theta

   result_pad = math.pi - 2*alpha_pad - theta

   -- compute the actual velocity components by multiplying
   -- with the corresponding multipliers.

   puck_velocity.x = xmultiplier*math.abs(val*math.cos(result))
   puck_velocity.y = ymultiplier*math.abs(val*math.sin(result))

   paddle[2].xa = -1 * xmultiplier*math.abs(val_pad*math.cos(result_pad))
   paddle[2].ya = -1 * ymultiplier*math.abs(val_pad*math.sin(result_pad))

end


--function for options menu
function menu()
   selectedOptionNumber = 0
   deactiveColor = Color.new(175, 175, 175)
   activeColor = Color.new(0, 0, 255)
   oldPad = Controls.read()
   while true do
      -- screen:clear()
      screen:blit(0, 0, menuimg,  false)
      y = 0
      selectedOptionValues = nil
      selectedOptionIndex = nil
      selectedOptionName = nil
      for optionKey, possibleOption in possibleOptions do
         color = deactiveColor
         if selectedOptionNumber == y then
            color = activeColor
            selectedOptionValues = possibleOption.values
         end
         screen:print(110, y * 35 + 60, possibleOption.displayName, color)
         for i, value in possibleOption.values do
            color = deactiveColor
            if options[optionKey] == value then
               color = activeColor
               if selectedOptionNumber == y then
                  selectedOptionIndex = i
                  selectedOptionName = optionKey
               end
            end
            screen:print(i * 60 + 250, y * 35 + 60, value, color)
         end
         y = y + 1
      end

      pad = Controls.read()
      if pad ~= oldPad then
         if pad:start() or pad:cross() then
              screen.waitVblankStart(10)
              break
         end
         if pad:up() then
            selectedOptionNumber = selectedOptionNumber - 1
            if selectedOptionNumber < 0 then selectedOptionNumber = y - 1 end
         end
         if pad:down() then
            selectedOptionNumber = selectedOptionNumber + 1
            if selectedOptionNumber >= y then selectedOptionNumber = 0 end
         end
         len = table.getn(selectedOptionValues)
         if pad:left() then
            selectedOptionIndex = selectedOptionIndex - 1
            if selectedOptionIndex <= 0 then selectedOptionIndex = len end
            options[selectedOptionName] = selectedOptionValues[selectedOptionIndex]
         end
         if pad:right() then
            selectedOptionIndex = selectedOptionIndex + 1
            if selectedOptionIndex > len then selectedOptionIndex = 1 end
            options[selectedOptionName] = selectedOptionValues[selectedOptionIndex]
         end
         oldPad = pad
      end

      screen.waitVblankStart()
      screen.flip()

      selectedMusic = (options["music"])
      if songplaying ~= selectedMusic then
         if selectedMusic == 1 then
            Music.playFile("song1.xm", true)
            songplaying = 1
         elseif selectedMusic == 2 then
            Music.playFile("song2.xm", true)
            songplaying = 2
         elseif selectedMusic == 3 then
            Music.playFile("song3.xm", true)
            songplaying = 3
         end
      end
   end
end

-- function dumb ass ai

function winSound()
   Music.volume(64)
   if score1 == score and players == 1 then
      disgrace:play()
   elseif score2 == score and players == 1 then
      angry:play()
   elseif players == 0 then
      boom:play()
   end
end

function ai()
   if puck_center.y < paddle_center[2].y then
      paddle[2].ya = paddle[2].ya -accel
   elseif puck_center.y > paddle_center[2].y then
      paddle[2].ya = paddle[2].ya +accel
   end

   aix = math.random(1,2)
   if aix == 1 and puck_center.x then
      paddle[2].xa = paddle[2].xa +accel
   else
      paddle[2].xa = paddle[2].xa -accel
   end
end


function ai2_1stPlayer()

   if puck_center.x > paddle_center[1].x or
     (puck_velocity.x <= 0 and puck_pos.x > 10) then
      if puck_center.y < paddle_center[1].y then
         paddle[1].ya = paddle[1].ya -accel
      elseif puck_center.y > paddle_center[1].y then
         paddle[1].ya = paddle[1].ya +accel
      end
   else
      puck_top = puck_center.y + 16
      puck_bottom = puck_pos.y
      paddle_top = paddle_center[1].y + 16
      paddle_bottom = paddle[1].y
      if (puck_top > (paddle_bottom - 3) and puck_top <= paddle_top) or
         (puck_bottom < (paddle_top + 3) and puck_bottom >= paddle_bottom) then
         if puck_pos.x <= 15 and puck_pos.y <= 15 then
            paddle[1].ya = paddle[1].ya +accel
            paddle[1].xa = paddle[1].xa +accel
         elseif puck_pos.x <= 15 and puck_pos.y >= 225 then
            paddle[1].ya = paddle[1].ya -accel
            paddle[1].xa = paddle[1].xa +accel
         elseif puck_velocity.y < 0 then
            paddle[1].ya = paddle[1].ya +accel
         else
            paddle[1].ya = paddle[1].ya -accel
         end
      end
   end

   if puck_center.x < 240 and puck_velocity.x < 0 and puck_center.x < paddle_center[1].x then
      paddle[1].xa = paddle[1].xa -accel
   else
      aix = math.random(1,5)
      if aix == 1 and puck_center.x < 240 then
         paddle[1].xa = paddle[1].xa -accel
      elseif aix == 3 then
         paddle[1].xa = paddle[1].xa +accel
      end
   end
end


function ai2_2ndPlayer()

   if puck_center.x < paddle_center[2].x or puck_velocity.x >= 0 then
      if puck_center.y < paddle_center[2].y then
         paddle[2].ya = paddle[2].ya -accel
      elseif puck_center.y > paddle_center[2].y then
         paddle[2].ya = paddle[2].ya +accel
      end
   else
      puck_top = puck_center.y + 16
      puck_bottom = puck_pos.y
      paddle_top = paddle_center[2].y + 16
      paddle_bottom = paddle[2].y
      if (puck_top > (paddle_bottom - 3) and puck_top <= paddle_top) or
         (puck_bottom < (paddle_top + 3) and puck_bottom >= paddle_bottom) then
         if puck_pos.x >= 433 and puck_pos.y <= 15 then
            paddle[2].ya = paddle[2].ya +accel
            paddle[2].xa = paddle[2].xa -accel
         elseif puck_pos.x >= 433 and puck_pos.y >= 225 then
            paddle[2].ya = paddle[2].ya -accel
            paddle[2].xa = paddle[2].xa -accel
         elseif puck_velocity.y < 0 then
            paddle[2].ya = paddle[2].ya +accel
         else
            paddle[2].ya = paddle[2].ya -accel
         end
      end
   end


   if puck_center.x > 240 and puck_velocity.x > 0 and puck_center.x > paddle_center[2].x then
      paddle[2].xa = paddle[2].xa +accel
   else
      aix = math.random(1,5)
      if aix == 1 and puck_center.x > 240 then
         paddle[2].xa = paddle[2].xa +accel
      elseif aix == 3 then
         paddle[2].xa = paddle[2].xa -accel
      end
   end
end


function ai3_2ndPlayer()

   if (puck_pos.y + puck_velocity.y) <= 5 or (puck_pos.y + puck_velocity.y) >= 235 then
      puck_y_velocity = -puck_velocity.y
   else
      puck_y_velocity = puck_velocity.y
   end

   new_puck_center = puck_center.y + puck_y_velocity
   if (new_puck_center - 16) <= 5 or
      (new_puck_center + 16) >= 235 then
      next_puck_y_velocity = -puck_velocity.y
   else
      next_puck_y_velocity = puck_velocity.y + puck_velocity.y
   end

   if (puck_center.x + puck_velocity.x) < (paddle_center[2].x + paddle[2].xa) or
      puck_velocity.x >= 0 then

      est_puck_dist = 459
      upper_bound = 189
      lower_bound = 83
      if puck_center.x < 240 then
         est_puck_dist = paddle_center[2].x
         upper_bound = 219
         lower_bound = 53
      elseif puck_center.x < 380 then
         est_puck_dist = 250
         found_x_axis = false
         while found_x_axis == false do
            if puck_center.x < est_puck_dist then
               found_x_axis = true
            else
               est_puck_dist = est_puck_dist + 10
            end
         end
         if selectedGoalSize == 1 then
            y_axis = 82 * (459 - est_puck_dist) / 219
            upper_bound = 161 + y_axis
            lower_bound = 111 - y_axis
         else
            y_axis = 60 * (459 - est_puck_dist) / 219
            upper_bound = 183 + y_axis
            lower_bound = 89 - y_axis
         end
      else
         est_puck_dist = 459
         upper_bound = 189
         lower_bound = 83
      end

      puck_dist = est_puck_dist - puck_center.x
      puck_steps = puck_dist / puck_velocity.x
      puck_y_vec = puck_center.y + (puck_steps * puck_velocity.y)

      if debug then
           screen:print(30, 200, "Est Puck dist:" , black)
           screen:print(250, 200, est_puck_dist, black)
           screen:print(30, 210, "Puck center:", black)
           screen:print(250, 210, puck_center.x, black)
           screen:print(30, 220, "Puck Y vec:", black)
           screen:print(250, 220, puck_y_vec, black)

           if puck_y_vec > 5 and puck_y_vec < 267 then
              screen:print(est_puck_dist, puck_y_vec, "*" , red)
           end

           screen:print(est_puck_dist, upper_bound, "L", red)
           screen:print(est_puck_dist, lower_bound, "U", red)
      end

      if (paddle_center[2].y + paddle[2].ya) < upper_bound and (paddle_center[2].y + paddle[2].ya) > lower_bound then
         if puck_velocity.x > 0 and puck_y_vec > 5 and puck_y_vec < 267 then
            if puck_y_vec < paddle_center[2].y then
               if paddle[2].ya > 0 then
                  paddle[2].ya = 0
               end
               paddle[2].ya = paddle[2].ya -accel
            elseif puck_y_vec > paddle_center[2].y then
               if paddle[2].ya < 0 then
                  paddle[2].ya = 0
               end
               paddle[2].ya = paddle[2].ya +accel
            else
               paddle[2].ya = 0
            end
         else
            if (puck_center.y + puck_y_velocity) < (paddle_center[2].y + paddle[2].ya) or
               (puck_center.y + next_puck_y_velocity) < (paddle_center[2].y + paddle[2].ya + paddle[2].ya) then
               paddle[2].ya = paddle[2].ya -accel
            elseif (puck_center.y + puck_y_velocity) > (paddle_center[2].y + paddle[2].ya) or
               (puck_center.y + next_puck_y_velocity) > (paddle_center[2].y + paddle[2].ya + paddle[2].ya) then
               paddle[2].ya = paddle[2].ya +accel
            else
               paddle[2].ya = 0
            end
         end
      else
         if (paddle_center[2].y + paddle[2].ya) >= upper_bound then
            if paddle[2].ya > 0 then
               paddle[2].ya = 0
            end
            paddle[2].ya = paddle[2].ya -accel
         else
            if paddle[2].ya < 0 then
               paddle[2].ya = 0
            end
            paddle[2].ya = paddle[2].ya +accel
         end
      end
   else
      puck_top = puck_center.y + 16
      puck_bottom = puck_pos.y
      paddle_top = paddle_center[2].y + 16
      paddle_bottom = paddle[2].y
      if (puck_top > (paddle_bottom - 3) and puck_top <= paddle_top) or
         (puck_bottom < (paddle_top + 3) and puck_bottom >= paddle_bottom) then
         if puck_pos.x >= 433 and puck_pos.y <= 15 then
            paddle[2].ya = paddle[2].ya +accel
            paddle[2].xa = paddle[2].xa -accel
         elseif puck_pos.x >= 433 and puck_pos.y >= 225 then
            paddle[2].ya = paddle[2].ya -accel
            paddle[2].xa = paddle[2].xa -accel
         elseif puck_y_velocity < 0 then
            paddle[2].ya = paddle[2].ya +accel
         else
            paddle[2].ya = paddle[2].ya -accel
         end
      end
   end

   if debug then
      padtest = Controls.read()
      pause = true
      while pause do
         if padtest:cross() then
            pause = false
         end
      padtest = Controls.read()
      end
   end

   if puck_center.x > 200 and puck_velocity.x > 0 and (puck_center.x + 16 + puck_velocity.x) > (paddle[2].x + paddle[2].xa) then
      paddle[2].xa = paddle[2].xa +accel
   else
      aix = math.random(1,5)
      if aix == 1 and puck_center.x > 120 and puck_velocity.x > 0 then
         paddle[2].xa = paddle[2].xa +accel
      elseif aix == 5 and puck_center.x > 240 and puck_velocity.x < 0 and puck_center.x < paddle_center[2].x then
         paddle[2].xa = paddle[2].xa -accel
      elseif aix == 3 and puck_center.x < 160 then
         paddle[2].xa = paddle[2].xa -accel
      end
   end
end

-- function game over
function gameover()

   if players == 0 then
      timeout = 0
      while timeout < 600 do
         timeout = timeout + 1
         if selectedBackground == 1 and selectedGoalSize == 1 then
            screen:blit(0, 0, background,  false)
         elseif selectedBackground == 2 and selectedGoalSize == 1 then
            screen:blit(0, 0, background2,  false)
         elseif selectedBackground == 1 and selectedGoalSize == 2 then
            screen:blit(0, 0, backgroundlarge,  false)
         elseif selectedBackground == 2 and selectedGoalSize == 2 then
            screen:blit(0, 0, background2large,  false)
         end
         screen:print(180, 15, score2, red)
         screen:print(295, 15, score1, red)
         screen:print(185, 222, "That's all Folks!", black)
         screen.waitVblankStart()
         screen.flip()
      end
      return "mmenu"
   end

   loopgameover = true
   while loopgameover do
      if selectedBackground == 1 and selectedGoalSize == 1 then
         screen:blit(0, 0, background,  false)
      elseif selectedBackground == 2 and selectedGoalSize == 1 then
         screen:blit(0, 0, background2,  false)
      elseif selectedBackground == 1 and selectedGoalSize == 2 then
         screen:blit(0, 0, backgroundlarge,  false)
      elseif selectedBackground == 2 and selectedGoalSize == 2 then
         screen:blit(0, 0, background2large,  false)
      end
      screen:print(180, 15, score2, red)
      screen:print(295, 15, score1, red)
      screen:print(194, 50, "GAME    OVER", black)
      screen:print(109, 250, "PRESS R BUTTON TO START A NEWGAME", black)
      screen.waitVblankStart()
      screen.flip()
      resetpad = Controls.read()
      if resetpad:r() then
         score1 = 0
         score2 = 0
         loopgameover = false
         return "reset"
      elseif resetpad:start() then
         score1 = 0
         score2 = 0
         loopgameover = false
         return "mmenu"
      end
   end
end



function getready()

   Music.volume(128)
   timeout = 0
   while timeout < (2 * 60) do
       timeout = timeout + 1

      if keyboardControl() == "menu" then
       menu()
      end

      puck_pos.x = 224
      puck_pos.y = 120

      paddle[1].x = 70
      paddle[1].y = 120
      paddle[2].x = 378
      paddle[2].y = 120

      paddle[1].xa = 0
      paddle[1].ya = 0
      paddle[2].xa = 0
      paddle[2].ya = 0

      selectedBackground = (options["background"])
      selectedGoalSize = (options["goalsize"])
      if selectedBackground == 1 and selectedGoalSize == 1 then
         screen:blit(0, 0, background,  false)
      elseif selectedBackground == 2 and selectedGoalSize == 1 then
         screen:blit(0, 0, background2,  false)
      elseif selectedBackground == 1 and selectedGoalSize == 2 then
         screen:blit(0, 0, backgroundlarge,  false)
      elseif selectedBackground == 2 and selectedGoalSize == 2 then
         screen:blit(0, 0, background2large,  false)
      end

      screen:blit(paddle[1].x, paddle[1].y, paddleimg)
      screen:blit(paddle[2].x, paddle[2].y, paddleimg)
      screen:blit(puck_pos.x, puck_pos.y, puck1img)
      puckimg = puck1img
      puckIndx = 1
      screen:print(180, 15, score2, red)
      screen:print(295, 15, score1, red)
      screen:print(201, 222, "Get Ready!", black)
      screen.waitVblankStart()
      screen.flip()

   -- friction
      for player, coords in ipairs(paddle) do
         paddle[player].xa = 0.94*paddle[player].xa
         paddle[player].ya = 0.94*paddle[player].ya
      end

      paddlemaxborder()
   end
   puck_velocity.y = math.random(-(puckvel), puckvel)
   puck_velocity.x = math.random(1,2)
   if puck_velocity.x == 2 then
      puck_velocity.x = puckvel
   else
      puck_velocity.x = -(puckvel)
   end
end

-- Function for main menu
function mainmenu()

   Music.volume(128)
   selectedMusic = (options["music"])
   if songplaying ~= selectedMusic then
      if selectedMusic == 1 then
         Music.playFile("song1.xm", true)
         songplaying = 1
      elseif selectedMusic == 2 then
         Music.playFile("song2.xm", true)
         songplaying = 2
      elseif selectedMusic == 3 then
         Music.playFile("song3.xm", true)
         songplaying = 3
      end
   end

   oldmainMenuPad = Controls.read()
   mainMenuSelection = 1
   loopmainmenu = true
   while loopmainmenu do
         screen:blit(0, 0, mainmenuimg,  false)
      if mainMenuSelection == 1 then
         screen:blit(130, 108, paddleimg)
         screen:blit(316, 108, paddleimg)
      elseif mainMenuSelection == 2 then
         screen:blit(123, 158, paddleimg)
         screen:blit(328, 158, paddleimg)
      elseif mainMenuSelection == 3 then
         screen:blit(135, 207, paddleimg)
         screen:blit(315, 207, paddleimg)
      end

      screen.waitVblankStart()
      screen.flip()

      mainMenuPad = Controls.read()
      if mainMenuPad ~= oldmainMenuPad then
         if mainMenuPad:down() then
            mainMenuSelection = mainMenuSelection + 1
            if mainMenuSelection > 3 then
               mainMenuSelection = 1
            end
         end
         if mainMenuPad:up()then
            mainMenuSelection = mainMenuSelection - 1
            if mainMenuSelection < 1 then
            mainMenuSelection = 3
            end
         end
         if mainMenuPad:cross() then
            if mainMenuSelection == 1 then
               players = 1
               score1 = 0
               score2 = 0
               getready()
               loopmainmenu = false
            elseif mainMenuSelection == 2 then
               players = 2
               score1 = 0
               score2 = 0
               getready()
               loopmainmenu = false
            elseif mainMenuSelection == 3 then
               menu()
            end
         elseif mainMenuPad:circle() then
               players = 0
               score1 = 0
               score2 = 0
               getready()
               loopmainmenu = false
         end
	if mainMenuPad:start() then
		dofile("./windows.lua")
	end
         oldmainMenuPad = mainMenuPad
      end
   end

   selectedBackground = (options["background"])

   if selectedBackground == 2 then
      Music.playFile("song4.xm", true)
      songplaying = 4
   end

end


function rotatePuck()

   if (puck_velocity.y < 0 and puck_velocity.x > 0) or
      (puck_velocity.y > 0 and puck_velocity.x < 0) then
      puckIndx = puckIndx + 1
   elseif (puck_velocity.y < 0 and puck_velocity.x < 0) or
      (puck_velocity.y > 0 and puck_velocity.x > 0) then
      puckIndx = puckIndx - 1
   end

   if puckIndx > 24 then
      puckIndx = 1
   elseif puckIndx < 1 then
      puckIndx = 24
   end

   if puckIndx == 24 then
      puckimg = puck24img
   elseif puckIndx == 23 then
      puckimg = puck23img
   elseif puckIndx == 22 then
      puckimg = puck22img
   elseif puckIndx == 21 then
      puckimg = puck21img
   elseif puckIndx == 20 then
      puckimg = puck20img
   elseif puckIndx == 19 then
      puckimg = puck19img
   elseif puckIndx == 18 then
      puckimg = puck18img
   elseif puckIndx == 17 then
      puckimg = puck17img
   elseif puckIndx == 16 then
      puckimg = puck16img
   elseif puckIndx == 15 then
      puckimg = puck15img
   elseif puckIndx == 14 then
      puckimg = puck14img
   elseif puckIndx == 13 then
      puckimg = puck13img
   elseif puckIndx == 12 then
      puckimg = puck12img
   elseif puckIndx == 11 then
      puckimg = puck11img
   elseif puckIndx == 10 then
      puckimg = puck10img
   elseif puckIndx == 9 then
      puckimg = puck9img
   elseif puckIndx == 8 then
      puckimg = puck8img
   elseif puckIndx == 7 then
      puckimg = puck7img
   elseif puckIndx == 6 then
      puckimg = puck6img
   elseif puckIndx == 5 then
      puckimg = puck5img
   elseif puckIndx == 4 then
      puckimg = puck4img
   elseif puckIndx == 3 then
      puckimg = puck3img
   elseif puckIndx == 2 then
      puckimg = puck2img
   else
      puckimg = puck1img
   end
end



-- Game loop

   math.randomseed(os.time())
   score1 = 0
   score2 = 0
   score = 0

   screen:blit(0, 0, splash,  false)
   screen.waitVblankStart()
   screen.flip()
   boltsnd:play()
   screen.waitVblankStart(240)
   screen.flip()
   Music.volume(128)
   Music.playFile("song1.xm", true)
   songplaying = 1

mainmenu()  --Calls the main menu function

while true do
   selectedGoalSize = (options["goalsize"])

   if selectedGoalSize == 1 then
      if isPuckInGoal() == "true" then
         score = 21
         if players == 0 then
            score = 100
         end
         if score1 == score or score2 == score then
            winSound()
            if gameover() == "reset" then
               getready()
            else
               mainmenu()
            end
         else
            getready()
         end
      end
   else
      if isPuckInGoal2() == "true" then
         score = 21
         if players == 0 then
            score = 100
         end
         if score1 == score or score2 == score then
            winSound()
            if gameover() == "reset" then
               getready()
            else
               mainmenu()
            end
         else
            getready()
         end
      end
   end

   if keyboardControl() == "mmenu" then
    mainmenu()
   end

-- Background selection
   selectedBackground = (options["background"])
   selectedGoalSize = (options["goalsize"])
   if selectedBackground == 1 and selectedGoalSize == 1 then
   screen:blit(0, 0, background,  false)
   elseif selectedBackground == 2 and selectedGoalSize == 1 then
   screen:blit(0, 0, background2,  false)
   elseif selectedBackground == 1 and selectedGoalSize == 2 then
   screen:blit(0, 0, backgroundlarge,  false)
   elseif selectedBackground == 2 and selectedGoalSize == 2 then
   screen:blit(0, 0, background2large,  false)
   end

-- call ai function if one player
   if players == 0 then
     ai2_1stPlayer()
   end

   if players ~= 2 then
     selectedDifficulty = (options["difficulty"])
     if selectedDifficulty == 1 then
        ai()
     elseif selectedDifficulty == 2 then
        ai2_2ndPlayer()
     else
        ai3_2ndPlayer()
     end
   end

   screen:print(180, 15, score2, red)
   screen:print(295, 15, score1, red)


   paddle[1].x = paddle[1].x + paddle[1].xa
   paddle[1].y = paddle[1].y + paddle[1].ya
   paddle[2].x = paddle[2].x + paddle[2].xa
   paddle[2].y = paddle[2].y + paddle[2].ya

   paddlemaxborder()

   paddle_center[1].x = paddle[1].x + 16
   paddle_center[1].y = paddle[1].y + 16
   paddle_center[2].x = paddle[2].x + 16
   paddle_center[2].y = paddle[2].y + 16

   puck_pos.x = puck_pos.x + puck_velocity.x
   puck_pos.y = puck_pos.y + puck_velocity.y

   puck_center.x = puck_pos.x + 16
   puck_center.y = puck_pos.y + 16

   selectedGoalSize = (options["goalsize"])
   if selectedGoalSize == 1 then
      didPuckWallCollide()
   else
      didPuckWallCollide2()
   end

   puck_center.x = puck_pos.x + 16
   puck_center.y = puck_pos.y + 16

   puckCollide1 = hasPuckPaddleCollided1()
   puckCollide2 =  hasPuckPaddleCollided2()

   -- friction
   for player, coords in ipairs(paddle) do
      paddle[player].xa = 0.94*paddle[player].xa
      paddle[player].ya = 0.94*paddle[player].ya
   end

   paddlemaxborder()

   paddle_center[1].x = paddle[1].x + 16
   paddle_center[1].y = paddle[1].y + 16
   paddle_center[2].x = paddle[2].x + 16
   paddle_center[2].y = paddle[2].y + 16

   -- paddlemaxborder()

   rotatePuck()
   screen:blit(puck_pos.x, puck_pos.y, puckimg)
   screen:blit(paddle[1].x, paddle[1].y, paddleimg)
   screen:blit(paddle[2].x, paddle[2].y, paddleimg)

   screen.waitVblankStart()
   screen.flip()

   if puckCollide1 == "collide1" then
      ChangePuckVelocity1()
   end
   if puckCollide2 == "collide2" then
      ChangePuckVelocity2()
   end

   paddlemaxborder()

end