--[[	Notepad 1.0              ]]
--[[    by rob_psp at yahoo.com           ]]

green = Color.new(0, 255, 0)
black = Color.new(0, 0, 0)
red = Color.new(255, 0, 0)
blue = Color.new(0, 0, 255)
white = Color.new(255, 255, 255)
grey = Color.new(200,200,200)
lightgrey = Color.new(224,224,224)
darkgrey = Color.new(125,125,125)
selectgrey = Color.new(200,200,200,200)
check = Image.load("image/check.png")
ascii = Image.load("image/ascii.png")
leftkey = Image.load("image/left.png")
sleftkey = Image.load("image/sleft.png")
cleftkey = Image.load("image/cleft.png")
csleftkey = Image.load("image/csleft.png")
rightkey = Image.load("image/right.png")
srightkey = Image.load("image/sright.png")
crightkey = Image.load("image/cright.png")
csrightkey = Image.load("image/csright.png")
spacebar = Image.load("image/space.png")
arrowkey = Image.load("image/arrows.png")
background = Image.load("image/metal.png")
buttons = Image.load("image/buttons.png")
folder = Image.load("image/folder.png")
doc = Image.load("image/doc.png")
dot = Image.load("image/dot.png")
AAscreen = Image.createEmpty(480,272)
AAscreen:clear(white)
blink = 0
minlines = 17
maxlines = 25
nMaxchar = 60
dirmaxlines = 12
cursor = 1
scrollx = 0
scrolly = 0
ly = 1
lx = 1
ry = 1
rx = 1
line = 1
mark1 = {0,0}
mark2 = {0,0}
temp = {0,0}


text = { "" }
wraptext = { "" }
copytext = { "" }
findtext = ""
gotoline = ""
nw = 1
wordwrap = false
wordwrap1 = false
wordwrap2 = false
bAAfont = true
bUpdate = false
textscroll = ""
openfile = "Untitled.doc"
readfile = ""
caps = false
select = false
count = 1
mode = 1
menumode = 0
usb = false
lastmode = 1

bookmark = {}
current = 1
dir = {}

dircursor = 1
dirselect = 1
dirscroll = 0
currentdir = "ms0:"

menucursor = 1


lkeys = { { " ", "`", "1", "2", "3", "4", "5", "6", " " },
          { " ", "     ", "     ", "q", "w", "e", "r", "t", " " },
          { " ", "cl", "cl", "a", "s", "d", "f", "g", " " },
          { " ", "ls", "ls", "z", "x", "c", "v", "b", " " } }
          
rkeys = { { " ", "7", "8", "9", "0", "-", "=", "bs", "bs" },
          { " ", "y", "u", "i", "o", "p", "[", "]", "\\" },
          { " ", "h", "j", "k", "l", ";", "'", "en", "en" },
          { " ", "n", "m", ",", ".", "/", "rs", "rs", " " } }
          
lskeys = { { " ", "~", "!", "@", "#", "$", "%", "^", " " },
           { " ", "     ", "     ", "Q", "W", "E", "R", "T", " " },
           { " ", "cl", "cl", "A", "S", "D", "F", "G", " " },
           { " ", "ls", "ls", "Z", "X", "C", "V", "B", " " } }
          
rskeys = { { " ", "&", "*", "(", ")", "_", "\+", "bs", "bs" },
           { " ", "Y", "U", "I", "O", "P", "\{", "\}", "|" },
           { " ", "H", "J", "K", "L", ":", "\"", "en", "en" },
           { " ", "N", "M", "<", ">", "?", "rs", "rs", " " } }
             
lckeys = { { " ", "`", "1", "2", "3", "4", "5", "6", " " },
           { " ", "     ", "     ", "Q", "W", "E", "R", "T", " " },
           { " ", "cl", "cl", "A", "S", "D", "F", "G", " " },
           { " ", "ls", "ls", "Z", "X", "C", "V", "B", " " } }
          
rckeys = { { " ", "7", "8", "9", "0", "-", "=", "bs", "bs" },
           { " ", "Y", "U", "I", "O", "P", "[", "]", "\\" },
           { " ", "H", "J", "K", "L", ";", "'", "en", "en" },
           { " ", "N", "M", ",", ".", "/", "rs", "rs", " " } } 

lcskeys = { { " ", "~", "!", "@", "#", "$", "%", "^", " " },
            { " ", "     ", "     ", "q", "w", "e", "r", "t", " " },
            { " ", "cl", "cl", "a", "s", "d", "f", "g", " " },
            { " ", "ls", "ls", "z", "x", "c", "v", "b", " " } }
          
rcskeys = { { " ", "&", "*", "(", ")", "_", "\+", "bs", "bs" },
            { " ", "y", "u", "i", "o", "p", "\{", "\}", "|" },
            { " ", "h", "j", "k", "l", ":", "\"", "en", "en" },
            { " ", "n", "m", "<", ">", "?", "rs", "rs", " " } }
graph = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,210,220,230,240,250,260,270,280,290,300,310,
          0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,210,220,230,240,250,260,270,280,290,300,310,
          0,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,210,220,230,240,250,260,270,280,290,300,310}
          
function drawSmallframe()
	screen:fillRect(0,0,478,8,grey) -- top bar
	screen:drawLine(3,7,474,7,darkgrey) -- top line
	screen:fillRect(0,0,4,186,grey) -- left bar
	screen:fillRect(476,0,4,186,grey) -- right bar
	screen:fillRect(0,180,478,7,grey) -- bottom bar
	screen:drawLine(3,8,3,180,darkgrey) -- left line
	screen:drawLine(3,180,476,180,lightgrey)
	screen:fillRect(478,2,2,186,darkgrey) -- right line
	screen:fillRect(2,187,480,2,darkgrey) -- bottom line
end

function drawLargeframe()
	screen:fillRect(0,0,478,8,grey) -- top bar
	screen:drawLine(3,7,474,7,darkgrey) -- top line
	screen:fillRect(0,0,4,270,grey) -- left bar
	screen:fillRect(476,0,4,270,grey) -- right bar
	screen:fillRect(0,262,478,8,grey) -- bottom bar
	screen:drawLine(3,8,3,262 ,darkgrey) -- left line
	screen:drawLine(3,262,476,262, lightgrey)
	screen:fillRect(478,2,2,272,darkgrey) -- right line
	screen:fillRect(2,270,480,2,darkgrey) -- bottom line
end

function drawMenuframe()
	screen:fillRect(25,25,440,148,black) -- drop shadow
	screen:fillRect(20,17,440,10,grey) --top bar
	screen:drawLine(20,17,460,17,lightgrey) -- very top line
	screen:drawLine(28,27,450,27,darkgrey)  --top line
	screen:fillRect(20,20,8,146,grey) --left bar
	screen:fillRect(452,20,8,147,grey) --right bar
	screen:fillRect(20,160,440,8,grey) --bottom bar
	screen:drawLine(27,28,27,160,darkgrey) --left line
end

function drawKeyboard()
	if not shift and not caps and not rshift then
		screen:blit(70, 190, leftkey)
		screen:blit(250, 190, rightkey)
	elseif (shift or rshift) and not caps then
		screen:blit(70, 190, sleftkey)
		screen:blit(250, 190, srightkey)
	elseif caps and not shift and not rshift then
		screen:blit(70, 190, cleftkey)
		screen:blit(250, 190, crightkey)
	elseif caps and (shift or rshift) then
		screen:blit(70, 190, csleftkey)
		screen:blit(250, 190, csrightkey)		
	end
	screen:blit (230, 190, spacebar)
	drawRect(70 + (lx-1) * 20, 190 + (ly-1) * 20, 20, 20, green)
	drawRect(230 + (rx-1) * 20, 190 + (ry-1) * 20, 20, 20, red)	
end

function drawRect(x0, y0, w, h, color)
	screen:drawLine(x0, y0, x0+w, y0, color)
	screen:drawLine(x0, y0, x0, y0+h, color)
	screen:drawLine(x0+w, y0, x0+w, y0+h, color)
	screen:drawLine(x0+w, y0+h, x0, y0+h, color)
end

function findlast(x, y, z)
	local i,j = nil
	local len = string.len(x)
	
	while len > z and i == nil do
		i,j = string.find(x, y, len)
		len = len - 1
	end
	if i == nil then
		return 0
	else
		return i
	end
end

function updir(x)
	local z = string.len(x) - 1
	local i = nil
	local j = nil
	
	while z > 5 and i == nil do
		i,j = string.find(x, "/",z) 
		z = z - 1
	end
	if i ~= nil then
		return string.sub(x, 1,i-1)
	else
		return "ms0:"
	end
end

function drawString(x, y, sText, imScreen, trans)
	local byte = 0
	local countz = 0
	local xx = x-8
	if trans == nil then
		trans = false
	end
	if sText ~= nil then
		for countz = 1, string.len(sText) do
			byte = string.byte(sText,countz)
			if byte <= 32 or byte >= 127 then 
				imScreen:blit(xx+countz*8, y, ascii, 0, graph[1],8,10,trans)		
			elseif byte >= 32 and byte <= 63 then
				imScreen:blit(xx+countz*8, y, ascii, 0,graph[byte],8,10,trans)
			elseif byte >= 64 and byte <= 95 then
				imScreen:blit(xx+countz*8, y, ascii, 10,graph[byte],8,10,trans)							
			elseif byte >= 96 and byte <= 126 then
				imScreen:blit(xx+countz*8, y, ascii, 20,graph[byte],8,10,trans)
			end							
		end
	end
end

function textWrap1()
	wraptext = {""}
	table.setn(wraptext,n)
	for count = 1, n do
		wraptext[count] = text[count]
	end
	nw = table.getn(wraptext)
	count = 1
	while count <= table.getn(wraptext) do
		lenw = string.len(wraptext[count])
		if lenw > nMaxchar then
			if count == nw then
				table.insert(wraptext, "")
			end
			fl = findlast(string.sub(wraptext[count],1,nMaxchar)," ",1)
			if fl == 0 then
				trunctext = string.sub(wraptext[count],nMaxchar+1,lenw)
				wraptext[count] = string.sub(wraptext[count],1,nMaxchar)
			else
				trunctext = string.sub(wraptext[count], findlast(string.sub(wraptext[count],1,nMaxchar)," ",1)+1, lenw)	
				wraptext[count] = string.sub(wraptext[count], 1, findlast(string.sub(wraptext[count],1,nMaxchar)," ",1))
			end
			table.insert(wraptext, count+1, trunctext) 											
		end
		count = count + 1
	end
	nw = table.getn(wraptext)
end

function textWrap2()
	wraptext = {""}
	table.setn(wraptext,n)
	for count = 1, n do
		wraptext[count] = text[count]
	end
	nw = table.getn(wraptext)
	count = 1
	while count <= table.getn(wraptext) do
		lenw = string.len(wraptext[count])
		if lenw > nMaxchar then
			if count == nw then
				table.setn(wraptext,nw + 1)
				nw = table.getn(wraptext)
				wraptext[nw] = ""
			end
			fl = findlast(string.sub(wraptext[count],1,nMaxchar)," ",1)
			if fl == 0 then
				trunctext = string.sub(wraptext[count],nMaxchar+1,lenw)
				if string.sub(wraptext[count+1],1,1) == " " then
					table.insert(wraptext, count+1, trunctext)
				elseif string.len(wraptext[count+1]) > 0 then
					wraptext[count+1] = trunctext.." "..wraptext[count+1]
				else
					wraptext[count+1] = trunctext
					table.insert(wraptext, count+2, "")
				end													
				wraptext[count] = string.sub(wraptext[count],1,nMaxchar)
			else					
				trunctext = string.sub(wraptext[count], findlast(string.sub(wraptext[count],1,nMaxchar)," ",1)+1, lenw)
				if string.sub(wraptext[count+1],1,1) == " " then
					table.insert(wraptext, count+1, trunctext)				
				elseif string.len(wraptext[count+1]) > 0 then
					wraptext[count+1] = trunctext.." "..wraptext[count+1]
				else
					wraptext[count+1] = trunctext
					table.insert(wraptext, count+2, "")
				end
				wraptext[count] = string.sub(wraptext[count], 1, findlast(string.sub(wraptext[count],1,nMaxchar)," ",1))
			end
		end
		count = count + 1
	end
	nw = table.getn(wraptext)
end

oldkeyin = Controls.read()
oldkeyin2 = Controls.read()
oldkeyin3 = Controls.read()
oldkeyin4 = Controls.read()
menukeyin = Controls.read()

while true do
    keyin = Controls.read()

    screen:clear(white)
    
    blink = blink + 1
    if blink == 30 then
		blink = 0
    end
    wait = 0
    shift = false
    rshift = false
    n = table.getn(text)


--[[
	Mode 1 : Keyboard
	Mode 2 : Edit
	Mode 3 : Full screen
	Mode 4 : File menu
	Mode 5 : File open
	Mode 6 : Save file
	Mode 7 : Save directory select
]]
	if keyin ~= oldkeyin then
	
		if keyin:select() then
			if mode < 4 then
				lastmode = mode
			end
			mode = mode + 1
			if mode > 2 then
				mode = 1
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end	

			--mark1 = {0,0}
			--mark2 = {0,0}
	
			if mode < 3 then
				if n > minlines then
					if scrolly + n < minlines then
						scrolly = minlines - n		
					end
				end
			end	

			wait = 10
		end
	
		if keyin:start() then
			if mode == 7 then
				lastmode = mode
				mode = 6
			elseif mode == 6 then
				lastmode = mode
				dir = System.listDirectory(currentdir)
				dirN = table.getn(dir)
				dircursor = 1
				dirselect = 1
				dirscroll = 0
				mode = 7
			elseif menumode > 0 then
				menumode = 0
			else
				lastmode = mode
				menucursor = 1
				if mode == 1 then
					menumode = 1
				elseif mode == 2 then
					menumode = 2
				elseif mode == 3 then
					menumode = 3
				else
					menumode = 1
				end
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			wait = 10
		end	
	end
	
	oldkeyin = keyin

if menumode == 0 then
	if mode == 1 or mode == 6 or mode == 8 or mode == 9 then
		if keyin:up() then
			ly = ly - 1
			if ly < 1 then
				ly = 1
			end
			wait = 8		
		end
		
		if keyin:down() then
			ly = ly + 1
			if ly > 4 then
				ly = 4
			end
			wait = 8		
		end
		
		if keyin:left() then
			lx = lx - 1
			if lx < 1 then
				lx = 1
			end
			wait = 8		
		end
		
		if keyin:right() then
			lx = lx + 1
			if lx > 9 then
				lx = 9
			end
			wait = 8		
		end
		
		
		if keyin:triangle() then
			ry = ry - 1
			if ry < 1 then
				ry = 1
			end
			wait = 8
		end
	
		if keyin:cross() then
			ry = ry + 1
			if ry > 4 then
				ry = 4
			end
			wait = 8
		end
	
		if keyin:square() then
			rx = rx - 1
			if rx < 1 then
				rx = 1
			end
			wait = 8
		end
			
		if keyin:circle() then
			rx = rx + 1
			if rx > 9 then
				rx = 9
			end
			wait = 8
		end
		
		if keyin:r() then
			if rkeys[ry][rx] == "rs" then
				rshift = true
			end
		end
		
		if keyin:l() then
			if lkeys[ly][lx] == "cl" then
				caps = not caps
			end
			wait = 10
		end
		if shift or rshift then
			wait = 6
		end		
	end
	
	if mode == 1 then	
		if keyin:l() and lkeys[ly][lx] ~= "cl" then
			if lkeys[ly][lx] == "ls" then
				shift = true
			else 
				if not rshift and not caps then
					if cursor < (string.len(text[line]) + 1) then
						text[line] = string.sub(text[line],1,cursor-1) .. lkeys[ly][lx] .. string.sub(text[line],cursor,string.len(text[line]))
					else
						text[line] = text[line] .. lkeys[ly][lx]
					end
				end
				if rshift and not caps then
					if cursor < (string.len(text[line]) + 1) then
						text[line] = string.sub(text[line],1,cursor-1) .. lskeys[ly][lx] .. string.sub(text[line],cursor,string.len(text[line]))
					else
						text[line] = text[line] .. lskeys[ly][lx]
					end
				end
				if caps and not rshift then
					if cursor < (string.len(text[line]) + 1) then
						text[line] = string.sub(text[line],1,cursor-1) .. lckeys[ly][lx] .. string.sub(text[line],cursor,string.len(text[line]))
					else
						text[line] = text[line] .. lckeys[ly][lx]
					end
				end
				if caps and rshift then
					if cursor < (string.len(text[line]) + 1) then
						text[line] = string.sub(text[line],1,cursor-1) .. lcskeys[ly][lx] .. string.sub(text[line],cursor,string.len(text[line]))
					else
						text[line] = text[line] .. lcskeys[ly][lx]
					end
				end
				cursor = cursor + 1
				if lkeys[ly][lx] == "     " then
					cursor = cursor + 4
				end
				if cursor > (57 + math.abs(scrollx)) then
					scrollx = scrollx - 4
				end
				if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
					scrollx = 1 - cursor
				end
				if (line + scrolly < 1) or (line + scrolly > minlines) then
					scrolly = 1 - line
				end
			end
			if n > minlines	then
				if scrolly < minlines - n then
					scrolly = minlines - n	
				end
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			blink = 0			
			wait = 10
			if shift or rshift then
				wait = 6
			end
		end
			
		if keyin:r() and not rshift then
			if rkeys[ry][rx] == "bs" then
				if cursor == (string.len(text[line])+1) then
					text[line] = string.sub(text[line], 1, string.len(text[line]) - 1)
				elseif cursor > 1 then
					text[line] = string.sub(text[line], 1, cursor - 2) .. string.sub(text[line], cursor, string.len(text[line]))
	
				end
				cursor = cursor - 1
				if cursor == 0 and line > 1 then
					line = line - 1
					cursor = string.len(text[line]) + 1
					text[line] = text[line] .. text[line+1]
					for count = line+1,n do
						text[count] = text[count+1]
					end
					table.setn(text, n - 1)
					n = table.getn(text)
				end
				if cursor < 1 then
					cursor = 1
				end
				if line + scrolly < 1 then
					scrolly = scrolly + 1
				end
				if cursor + scrollx < 1
					then scrollx = scrollx + 4
				end
			elseif rkeys[ry][rx] == "en" then
				if line == n then
					table.setn(text, n + 1)
					if cursor < string.len(text[line]) + 1 then
						text[line+1] = string.sub(text[line], cursor, string.len(text[line]))
						text[line] = string.sub(text[line],1,cursor-1)
					else
						text[line+1] = ""
					end
					line = line + 1
					cursor = 1
				end
				if line < n then
					table.setn(text, n + 1)
					n = n + 1
					count = n
					while count > line do
						text[count] = text[count - 1]
						count = count - 1
					end
					if cursor < string.len(text[line]) + 1 then
						text[line+1] = string.sub(text[line], cursor, string.len(text[line]))
						text[line] = string.sub(text[line],1,cursor-1)
					else
						text[line+1] = ""
					end
					line = line + 1
					cursor = 1
				end
				if line + scrolly > minlines then
					scrolly = scrolly - 1
				end
			else
				if not shift and not caps then
					if cursor < (string.len(text[line]) + 1) then
						text[line] = string.sub(text[line],1,cursor-1) .. rkeys[ry][rx] .. string.sub(text[line],cursor,string.len(text[line]))
					else
						text[line] = text[line] .. rkeys[ry][rx]
					end
				end
				if shift and not caps then
					if cursor < (string.len(text[line]) + 1) then
						text[line] = string.sub(text[line],1,cursor-1) .. rskeys[ry][rx] .. string.sub(text[line],cursor,string.len(text[line]))
					else
						text[line] = text[line] .. rskeys[ry][rx]
					end
				end
				if caps and not shift then
					if cursor < (string.len(text[line]) + 1) then
						text[line] = string.sub(text[line],1,cursor-1) .. rckeys[ry][rx] .. string.sub(text[line],cursor,string.len(text[line]))
					else
						text[line] = text[line] .. rckeys[ry][rx]
					end
				end
				if caps and shift then
					if cursor < (string.len(text[line]) + 1) then
						text[line] = string.sub(text[line],1,cursor-1) .. rcskeys[ry][rx] .. string.sub(text[line],cursor,string.len(text[line]))
					else
						text[line] = text[line] .. rcskeys[ry][rx]
					end
				end
				cursor = cursor + 1
				if cursor > (57 + math.abs(scrollx)) then
					scrollx = scrollx - 4
				end
			end
			if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
				scrollx = 1 - cursor
			end
			if (line + scrolly < 1) or (line + scrolly > minlines) then
				scrolly = 1 - line
			end
			if n > minlines	then
				if scrolly < minlines - n then
					scrolly = minlines - n	
				end
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			blink = 0
			wait = 10
		end
	end	


	if mode == 2 then   
		if keyin:up() then
			line = line - 1
			if line == 0 then
				line = 1
			end
			if cursor > (string.len(text[line]) + 1) then
				cursor = string.len(text[line]) + 1
			end
			if (line + scrolly) < 1 then
				scrolly = scrolly + 1
			end
			if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
				scrollx = 1 - cursor
			end
			if (line + scrolly < 1) or (line + scrolly > minlines) then
				scrolly = 1 - line
			end
			if n > minlines	then
				if scrolly < minlines - n then
					scrolly = minlines - n	
				end
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			blink = 0
			wait = 4				
		end
		
		if keyin:down() then
			line = line + 1
			if line > n then
				line = n
			end
			if cursor > (string.len(text[line]) + 1) then
				cursor = string.len(text[line]) + 1
			end
			if (line + scrolly) > minlines and line < n+1 then
				scrolly = scrolly - 1
			end
			if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
				scrollx = 1 - cursor
			end
			if (line + scrolly < 1) or (line + scrolly > minlines) then
				scrolly = 1 - line
			end
			if n > minlines	then
				if scrolly < minlines - n then
					scrolly = minlines - n	
				end
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			blink = 0
			wait = 4				
		end
		
		if keyin:left() then
			cursor = cursor - 1
			if cursor == 0 and line == 1 and scrollx >= 0 then
				cursor = 1
			end
			if cursor == 0 and line > 1 and scrollx >= 0 then
				line = line - 1
				cursor = string.len(text[line]) + 1
			end
			if (cursor + scrollx) < 1 then
				scrollx = scrollx + 4
				if scrollx > 0 then
					scrollx = 0
				end
				--cursor = cursor + 1
			end
			if cursor > (57 + math.abs(scrollx)) then
				scrollx = scrollx - 4
				--cursor = cursor - 1
			end
			if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
				scrollx = 1 - cursor
			end
			if (line + scrolly < 1) or (line + scrolly > minlines) then
				scrolly = 1 - line
			end
			if n > minlines	then
				if scrolly < minlines - n then
					scrolly = minlines - n	
				end
			end					
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			blink = 0
			wait = 4				
		end
		
		if keyin:right() then
			cursor = cursor + 1
			if (cursor - 1) > string.len(text[line]) and n > line then
				cursor = 1
				line = line + 1
			end
			if (cursor - 1) > string.len(text[line]) and n == line then
				cursor = string.len(text[line]) + 1
			end
			if (cursor + scrollx) < 1 then
				scrollx = scrollx + 4
				--cursor = cursor + 1
			end
			if cursor > (57 + math.abs(scrollx)) then
				scrollx = scrollx - 4
				--cursor = cursor - 1
			end
			if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
				scrollx = 1 - cursor
			end
			if (line + scrolly < 1) or (line + scrolly > minlines) then
				scrolly = 1 - line
			end
			if n > minlines	then
				if scrolly < minlines - n then
					scrolly = minlines - n	
				end
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			blink = 0
			wait = 4
		end

		if keyin:r() and n > minlines then
			line = line + minlines - 1
			scrolly = scrolly - minlines + 1
			if (line + minlines - 1) > n then
				if line > n then
					line = n
				end
				scrolly = minlines - line
			end
			if cursor > string.len(text[line]) then
				cursor = string.len(text[line]) + 1
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			wait = 8
		end
		if keyin:l() then
			line = line - minlines + 1
			scrolly = scrolly + minlines - 1
			if (line - minlines - 1) < 1 then
				if line < 1 then
					line = 1
				end
				scrolly = 0
			end
			if cursor > string.len(text[line]) then
				cursor = string.len(text[line]) + 1
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			wait = 8
		end
		if keyin ~= oldkeyin3 then
			if keyin:triangle() then
				if mark2[1] ~= 0 then
					mark1 = {0,0}
					mark2 = {0,0}
				elseif mark1[1] == 0 then
					mark1[1] = cursor
					mark1[2] = line			
				elseif mark1[1] ~= 0 then
					mark2[1] = cursor
					mark2[2] = line
					if (mark2[1] < mark1[1] and mark2[2] <= mark1[2]) or (mark2[2]  < mark1[2]) then
						temp[1] = mark1[1]
						temp[2] = mark1[2]
						mark1[1] = mark2[1]
						mark1[2] = mark2[2]
						mark2[1] = temp[1]
						mark2[2] = temp[2]
					end					 			
				end	
				if mark1[1] == mark2[1] and mark1[2] == mark2[2] then
					mark1 = {0,0}
					mark2 = {0,0}
				end				
			end
			
			if keyin:square() then
				homefirst,homelast = string.find(text[line],"%s+")
				if homefirst == nil then
					homefirst = 0
					homelast = 0
				end
				if cursor ~= homelast + 1 and homefirst == 1 then				
					cursor = homelast + 1
					if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
						scrollx = nMaxchar - cursor - 4
					end	
				else
					cursor = 1
					scrollx = 0
				end
				
				if line < 1 - scrolly or line > minlines - scrolly then
					scrolly = 1 - line
				end
				
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end
			end
			
			if keyin:circle() then
				cursor = string.len(text[line]) + 1
				if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
					scrollx = nMaxchar - cursor - 4
				end	
				
				if line < 1 - scrolly or line > minlines - scrolly then
					scrolly = 1 - line
				end
				
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end			
			end

			oldkeyin3 = keyin
		end				
	end
	

	if mode == 3 then
		if wordwrap then
			num = nw
			temptext = wraptext
		else
			num = n
			temptext = text
		end

		if keyin:down() then
			if (num + scrolly) > minlines and mode < 3 then
				scrolly = scrolly - 1
				wait = 0
			end
			if (num + scrolly) > maxlines and mode == 3 then
				scrolly = scrolly - 1
				wait = 0
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
		end
		if keyin:up() then
			if scrolly ~= 0 then
				scrolly = scrolly + 1
				wait = 0
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
		end

		
		if not wordwrap then
			if keyin:right() then
				scrollx = scrollx - 1
				wait = 0
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end
			end
			if keyin:left() then
				if scrollx ~= 0 then
					scrollx = scrollx + 1
					wait = 0
				end
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end				
			end
		end
				
		if keyin:r() and num > maxlines then
			--line = line + maxlines - 1
			scrolly = scrolly - maxlines + 1
			if scrolly + num < maxlines then
				scrolly = maxlines - num
			end
--[[
			if (line + maxlines - 1) > n then
				if line > num then
					line = n
				end
				scrolly = maxlines - line
			end

			if cursor > string.len(temptext[line]) then
				cursor = string.len(temptext[line]) + 1
			end
]]			
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			wait = 8
		end
		if keyin:l() then
			--line = line - maxlines + 1
			scrolly = scrolly + maxlines - 1
			if scrolly > 0 then
				scrolly = 0
			end
--[[			
			if (line - maxlines - 1) < 1 then
				if line < 1 then
					line = 1
				end
				scrolly = 0
			end
			
			if cursor > string.len(temptext[line]) then
				cursor = string.len(temptext[line]) + 1
			end
]]			
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
			wait = 8
		end
	end
	
	if mode < 4 then
		if mode ~= 3 or (mode == 3 and not wordwrap) then
			if keyin:analogX() == 127 then
				scrollx = scrollx - 1
				wait = 0
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end
			end
			if keyin:analogX() == -128 then
				if scrollx ~= 0 then
					scrollx = scrollx + 1
					wait = 0
				end
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end				
			end
		end
		if wordwrap then
			num = nw
		else
			num = n
		end
		if keyin:analogY() == 127 then
			if (num + scrolly) > minlines and mode < 3 then
				scrolly = scrolly - 1
				wait = 0
			end
			if (num + scrolly) > maxlines and mode == 3 then
				scrolly = scrolly - 1
				wait = 0
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
		end
		if keyin:analogY() == -128 then
			if scrolly ~= 0 then
				scrolly = scrolly + 1
				wait = 0
			end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end
		end
	end

	if mode == 5 or mode == 7 then
	
		upcurrentdir = updir(currentdir)
		
		if keyin:up() then
			if (dirselect + dirscroll) == 1 and dirselect > 1 then
				dirscroll = dirscroll + 1
			end
			dirselect = dirselect - 1
			if dirselect < 1 then
				dirselect = 1
			end
			dircursor = dircursor - 1
			if dircursor < 1 then
				dircursor = 1
			end
	
			wait = 10
		end
		
		if keyin:down() then
			if dirselect + dirscroll == dirmaxlines and dirselect < dirN then
				dirscroll = dirscroll - 1
			end
			dirselect = dirselect + 1
			if dirselect > dirN then
				dirselect = dirN
			end
			dircursor = dircursor + 1
			if dircursor > dirmaxlines then
				dircursor = dirmaxlines
			end
			
			if dircursor > dirN then
				dircursor = dirN
			end
	
			wait = 10
		end
	end
	
	if mode == 5 then	
		if keyin ~= oldkeyin2 then
			if keyin:cross() then
				if dir[dirselect].directory then
					if dir[dirselect].name == ".." then
						currentdir = upcurrentdir
					elseif dir[dirselect].name ~= "." then
						currentdir = currentdir .."/".. dir[dirselect].name
					end
					
					dir = System.listDirectory(currentdir)
					dirN = table.getn(dir)
					dircursor = 1
					dirselect = 1
					dirscroll = 0
				else
					text = {""}
					n = table.getn(text)
					count = 1
					cursor = 1
					scrollx = 0
					scrolly = 0
					ly = 1
					lx = 1
					ry = 1
					rx = 1
					bookmark = {}
					current = 1
					mark1 = {0,0}
					mark2 = {0,0}
					line = 1 
		
					readfile = currentdir .."/".. dir[dirselect].name
					file = io.open(readfile, "r")
					openfile = dir[dirselect].name
					readline = file:read("*l")
					readline,num = string.gsub(readline,string.char(9),"     ")
					readline,num = string.gsub(readline,string.char(13),"")
					while readline ~= nil do
						text[count] = readline
						count = count + 1
						readline = file:read("*l")
						if readline ~= nil then
							readline,num = string.gsub(readline,string.char(9),"     ")
							readline,num = string.gsub(readline,string.char(13),"")
						end
					end
		
					file:close()
					mode = 3
					if bAAfont then
						bUpdate = true
						AAscreen:clear(white)
					end
					n = table.getn(text)
					if wordwrap then
						if wordwrap2 then
							textWrap2()
						else
							textWrap1()
						end
					end
				end
				wait = 40
			end
			oldkeyin2 = keyin
		end
	end

end -- menumode == 0

	if mode == 6 then
		if keyin:l() and lkeys[ly][lx] ~= "cl"then
			if lkeys[ly][lx] == "ls" then
				shift = true
			else 
				if string.len(openfile) < 256 then
					if not rshift and not caps then
						openfile = openfile .. lkeys[ly][lx]
					end
					if rshift and not caps then
						openfile = openfile .. lskeys[ly][lx]
					end
					if caps and not rshift then
						openfile = openfile .. lckeys[ly][lx]
					end
					if caps and rshift then
						openfile = openfile .. lcskeys[ly][lx]
					end
				end
			end
			blink = 0
			wait = 10
		end
			
		if keyin:r() and not rshift then
			if rkeys[ry][rx] == "bs" then
				openfile = string.sub(openfile, 1, string.len(openfile) - 1)
			elseif rkeys[ry][rx] == "en" then
				if string.len(openfile) > 0 then
					if usb then
						System.usbDiskModeDeactivate()
						usb = not usb
					end
					savefile = ""
					savefile = currentdir .."/".. openfile
					io.output(io.open(savefile,"w+"))
					fulltext = ""
					for count = 1, n do
						text[count],num = string.gsub(text[count], "     ",string.char(9))
						fulltext = fulltext..text[count].."\n"
					end
					io.write(fulltext)
					io.close()
					mode = 1
					wait = 10
					if bAAfont then
						bUpdate = true
						AAscreen:clear(white)
					end
				end		
			else
				if string.len(openfile) < 256 then
					if not shift and not caps then
						openfile = openfile .. rkeys[ry][rx]
					end
					if shift and not caps then
						openfile = openfile .. rskeys[ry][rx]
					end
					if caps and not shift then
						openfile = openfile .. rckeys[ry][rx]
					end
					if caps and shift then
						openfile = openfile .. rcskeys[ry][rx]
					end	
				end
			end
			blink = 0
			wait = 10
		end
	end

	if mode == 7 then
		upcurrentdir = updir(currentdir)
		if keyin ~= oldkeyin2 then
			if keyin:cross() then
				if dir[dirselect].directory then
					if dir[dirselect].name == ".." then
						currentdir = upcurrentdir
					elseif dir[dirselect].name ~= "." then
						currentdir = currentdir .."/".. dir[dirselect].name
					end
					
					dir = System.listDirectory(currentdir)
					dirN = table.getn(dir)
					dircursor = 1
					dirselect = 1
					dirscroll = 0
				else
					openfile = dir[dirselect].name
					mode = 6
				end
				wait = 40
			end
			oldkeyin2 = keyin
		end
	end
	
	if mode == 8 then
		if keyin:l() and lkeys[ly][lx] ~= "cl"then
			if lkeys[ly][lx] == "ls" then
				shift = true
			else 
				if not rshift and not caps then
					findtext = findtext .. lkeys[ly][lx]
				end
				if rshift and not caps then
					findtext = findtext .. lskeys[ly][lx]
				end
				if caps and not rshift then
					findtext = findtext .. lckeys[ly][lx]
				end
				if caps and rshift then
					findtext = findtext .. lcskeys[ly][lx]
				end
			end
			blink = 0
			wait = 10
		end
			
		if keyin:r() and not rshift then
			if rkeys[ry][rx] == "bs" then
				findtext = string.sub(findtext, 1, string.len(findtext) - 1)
			elseif rkeys[ry][rx] == "en" then
				if findtext ~= "" then
					findfirst = nil
					findlast = nil
					findline = line
					findfirst, findlast = string.find(string.lower(text[findline]), string.lower(findtext), cursor)
					findline = line + 1
					while findfirst == nil and findline <= n do
						findfirst, findlast = string.find(string.lower(text[findline]), string.lower(findtext))
						findline = findline + 1
					end
					
					if findlast ~= nil then
						cursor = findlast+1
						line = findline-1
						mark1 = { findfirst, line }
						mark2 = { findlast+1, line }
						if cursor > nMaxchar then
							scrollx = 5 - cursor
						else
							scrollx = 0
						end
						scrolly = 5 - line
						if n > minlines	then
							if scrolly < minlines - n then
								scrolly = minlines - n	
							end
						end					
					end

					if bAAfont then
						bUpdate = true
						AAscreen:clear(white)
					end	
				end
				mode = 2
				wait = 10		
			else
				if not shift and not caps then
					findtext = findtext .. rkeys[ry][rx]
				end
				if shift and not caps then
					findtext = findtext .. rskeys[ry][rx]
				end
				if caps and not shift then
					findtext = findtext .. rckeys[ry][rx]
				end
				if caps and shift then
					findtext = findtext .. rcskeys[ry][rx]
				end	
			end
			blink = 0
			wait = 10
		end
	end
	
	if mode == 9 then
		if keyin:l() and lkeys[ly][lx] ~= "cl"then
			if lkeys[ly][lx] == "ls" then
				shift = true
			else 
				if ly == 1 and lx >= 3 and lx <= 8 then
					if not rshift and not caps then
						gotoline = gotoline .. lkeys[ly][lx]
					end
					if caps and not rshift then
						gotoline = gotoline .. lckeys[ly][lx]
					end
				end
			end
			blink = 0
			wait = 10
		end
			
		if keyin:r() and not rshift then
			if rkeys[ry][rx] == "bs" then
				gotoline = string.sub(gotoline, 1, string.len(gotoline) - 1)
			elseif rkeys[ry][rx] == "en" then
				testline = tonumber(gotoline)
				if testline ~= nil then
					line = testline
					if line == 0 then
						line = 1
					end
					if line > n then
						line = n
					end
					cursor = 1
					scrollx = 0
					if n > minlines	then
						scrolly = 1 - line					
						if scrolly < minlines - n then
							scrolly = minlines - n
							if bAAfont then
								bUpdate = true
								AAscreen:clear(white)
							end		
						end
					end
				end			
				mode = 2
				wait = 10
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end				
			else
				if ry == 1 and rx >= 2 and rx <= 5 then
					if not shift and not caps then
						gotoline = gotoline .. rkeys[ry][rx]
					end
	
					if caps and not shift then
						gotoline = gotoline .. rckeys[ry][rx]
					end
				end
			end
			blink = 0
			wait = 10
		end
	end	

	if menumode == 1 then
		if keyin:up() then
			menucursor = menucursor - 1
			if menucursor < 1 then
				menucursor = 5
			end
			wait = 10
		end
		
		if keyin:down() then
			menucursor = menucursor + 1
			if menucursor > 5 then
				menucursor = 1
			end
			wait = 10
		end
		
		if keyin ~= menukeyin then
		if keyin:right() then
			menumode = 2
			lastmode = mode
			if mode < 4 then
				mode = 2
			end
			menucursor = 1
			wait = 10
		end
		
		if keyin:left() then
			menumode = 3
			menucursor = 1
			wait = 10
		end
		end
		menukeyin = keyin
		
		if keyin:cross() then
	
			if menucursor == 1 then
				text = { "" }
				openfile = "Untitled.doc"
				mode = 1
				cursor = 1
				scrollx = 0
				scrolly = 0
				ly = 1
				lx = 1
				ry = 1
				rx = 1
				line = 1
				mark1 = {0,0}
				mark2 = {0,0}
				current = 1
				bookmark = {}
				n = table.getn(text)
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end
			end
			if menucursor == 2 then
				mode = 5
				dir = System.listDirectory(currentdir)
				dirN = table.getn(dir)
				dircursor = 1
				dirselect = 1
				dirscroll = 0
			end
			if menucursor == 3 then
				mode = 6
			end
			if menucursor == 4 then
				usb = not usb
				if usb then
					System.usbDiskModeActivate()
				else
					System.usbDiskModeDeactivate()
				end
				mode = lastmode
			end
			if menucursor == 5 then
				if usb then
					System.usbDiskModeDeactivate()
				end
				break
			end
			menumode = 0
			lastmode = 1
			wait = 30
		end
	end
	
	if menumode == 2 then
		if keyin ~= menukeyin then
		if keyin:right() then
			menumode = 3
			mode = lastmode
			menucursor = 1
			wait = 10
		end
		
		if keyin:left() then
			menumode = 1
			mode = lastmode
			menucursor = 1
			wait = 10
		end
		end
		menukeyin = keyin
		
		if keyin:up() then
			if menucursor == 1 then
				menucursor = 8
			else 
				menucursor = menucursor - 1
			end
			wait = 10
		end
		
		if keyin:down() then
			if menucursor == 8 then
				menucursor = 1
			else
				menucursor = menucursor + 1
			end
			wait = 10
		end

		if keyin:cross() then


			if menucursor == 1 and mark2[1] ~= 0 then
				copytext = {""}
				if mark2[2] == mark1[2] then
					copytext[1] = string.sub(text[mark1[2]],mark1[1], mark2[1] - 1)
					text[mark1[2]] = string.sub(text[mark1[2]],1,mark1[1]-1)..string.sub(text[mark1[2]],mark2[1],string.len(text[mark1[2]]))
					if text[mark1[2]] == nil then
						text[mark1[2]] = ""
					end
				end
				
				if mark2[2] > mark1[2] then
					for count = mark1[2], mark2[2] do
						if count == mark2[2] then
							table.insert(copytext, string.sub(text[count],1, mark2[1] - 1))
						elseif count == mark1[2] then
							copytext[1] = string.sub(text[count], mark1[1], string.len(text[count]))
						else
							table.insert(copytext, text[count])					
						end
					end
					
					text[mark1[2]] = string.sub(text[mark1[2]],1,mark1[1]-1)
					if text[mark1[2]] == nil then
						text[mark1[2]] = ""
					end
					text[mark2[2]] = string.sub(text[mark2[2]], mark2[1], string.len(text[mark2[2]]))
					if text[mark2[2]] == nil then
						text[mark2[2]] = ""
					end
					text[mark1[2]] = text[mark1[2]]..text[mark2[2]]
					table.remove(text,mark2[2])
					if mark2[2] - mark1[2] > 1 then
						for count = mark1[2]+1, mark2[2]-1 do
							table.remove(text,count)
						end
					end
				end
				
				
				cursor = mark1[1]
				line = mark1[2]

				if cursor > nMaxchar then
					scrollx = 5 - cursor
				else
					scrollx = 0
				end
				scrolly = 5 - line
				if n > minlines	then
					if scrolly < minlines - n then
						scrolly = minlines - n	
					end
				end						
				n = table.getn(text)
				mark1 = {0,0}
				mark2 = {0,0}
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end				
			end

			if menucursor == 2 and mark2[1] ~= 0 then
				copytext = {""}
				if mark2[2] == mark1[2] then
					copytext[1] = string.sub(text[mark1[2]],mark1[1], mark2[1] - 1)
				end
				
				if mark2[2] > mark1[2] then
					for count = mark1[2], mark2[2] do
						if count == mark2[2] then
							table.insert(copytext, string.sub(text[count],1, mark2[1] - 1))							
						elseif count == mark1[2] then
							copytext[1] = string.sub(text[count], mark1[1], string.len(text[count]))							
						else
							table.insert(copytext, text[count])							
						end
					end
				end				
			end			
			
			if menucursor == 3 and (table.getn(copytext) >= 1 and string.len(copytext[1]) > 0) then
				if mark2[1] ~= 0 then
					if mark2[2] == mark1[2] then
						text[mark1[2]] = string.sub(text[mark1[2]],1,mark1[1]-1)..string.sub(text[mark1[2]],mark2[1],string.len(text[mark1[2]]))
						if text[mark1[2]] == nil then
							text[mark1[2]] = ""
						end
					end
					
					if mark2[2] > mark1[2] then	
						text[mark1[2]] = string.sub(text[mark1[2]],1,mark1[1]-1)
						if text[mark1[2]] == nil then
							text[mark1[2]] = ""
						end
						text[mark2[2]] = string.sub(text[mark2[2]], mark2[1], string.len(text[mark2[2]]))
						if text[mark2[2]] == nil then
							text[mark2[2]] = ""
						end
						text[mark1[2]] = text[mark1[2]]..text[mark2[2]]
						table.remove(text,mark2[2])
						if mark2[2] - mark1[2] > 1 then
							for count = mark1[2]+1, mark2[2]-1 do
								table.remove(text,count)
							end
						end
					end
					cursor = mark1[1]
					line = mark1[2]
				end
				
				if table.getn(copytext) == 1 then
					if cursor == 1 then
						text[line] = copytext[1]..text[line]
					elseif cursor == string.len(text[line]) + 1 then
						text[line] = text[line]..copytext[1]
					else
						text[line] = string.sub(text[line],1,cursor - 1)..copytext[1]..string.sub(text[line],cursor,string.len(text[line]))
					end
				end
	
	
				if table.getn(copytext) > 1 then
					if cursor == 1 then
						temptext = text[line]
						text[line] = copytext[1]
						table.insert(text, line+1, copytext[table.getn(copytext)]..temptext)
						if table.getn(copytext) > 2 then
							insertline = line+1
							for count = 2, table.getn(copytext) - 1 do
								table.insert(text,insertline,copytext[count])
								insertline = insertline + 1
							end
						end						
					elseif cursor == string.len(text[line]) + 1 then
						text[line] = text[line]..copytext[1]
						table.insert(text, line+1, copytext[table.getn(copytext)])
						if table.getn(copytext) > 2 then
							insertline = line+1
							for count = 2, table.getn(copytext) - 1 do
								table.insert(text,insertline,copytext[count])
								insertline = insertline + 1
							end
						end								
					else
						temptext = string.sub(text[line],cursor,string.len(text[line]))
						text[line] = string.sub(text[line],1,cursor-1)..copytext[1]
						table.insert(text, line+1, copytext[table.getn(copytext)]..temptext)
						if table.getn(copytext) > 2 then
							insertline = line+1
							for count = 2, table.getn(copytext) - 1 do
								table.insert(text,insertline,copytext[count])
								insertline = insertline + 1
							end
						end								
					end
				end
				
				if table.getn(copytext) == 1 then
					if cursor == 1 then		
						cursor = string.len(copytext[1])
					else
						cursor = cursor + string.len(copytext[1])
					end
				else
					cursor = string.len(copytext[table.getn(copytext)]) + 1
				end
				line = line + table.getn(copytext) - 1
				if (cursor + scrollx < 1) or (cursor + scrollx > nMaxchar) then
					scrollx = nMaxchar - cursor
				end
				if (line + scrolly < 1) or (line + scrolly > minlines) then
					scrolly = 1 - line
				end				
				n = table.getn(text)
				
				if cursor > nMaxchar then
					scrollx = 5 - cursor
				else
					scrollx = 0
				end
				scrolly = 5 - line
				if n > minlines	then
					if scrolly < minlines - n then
						scrolly = minlines - n	
					end
				end						
				mark1 = {0,0}
				mark2 = {0,0}				
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end					
			end
			
			if menucursor == 4 then
				if mark2[1] ~= 0 then
					if mark2[2] == mark1[2] then
						text[mark1[2]] = string.sub(text[mark1[2]],1,mark1[1]-1)..string.sub(text[mark1[2]],mark2[1],string.len(text[mark1[2]]))
						if text[mark1[2]] == nil then
							text[mark1[2]] = ""
						end
					end
					
					if mark2[2] > mark1[2] then	
						text[mark1[2]] = string.sub(text[mark1[2]],1,mark1[1]-1)
						if text[mark1[2]] == nil then
							text[mark1[2]] = ""
						end
						text[mark2[2]] = string.sub(text[mark2[2]], mark2[1], string.len(text[mark2[2]]))
						if text[mark2[2]] == nil then
							text[mark2[2]] = ""
						end
						text[mark1[2]] = text[mark1[2]]..text[mark2[2]]
						table.remove(text,mark2[2])
						if mark2[2] - mark1[2] > 1 then
							for count = mark1[2]+1, mark2[2]-1 do
								table.remove(text,count)
							end
						end
					end
					cursor = mark1[1]
					line = mark1[2]
					if cursor > nMaxchar then
						scrollx = 5 - cursor
					else
						scrollx = 0
					end
					scrolly = 5 - line
					if n > minlines	then
						if scrolly < minlines - n then
							scrolly = minlines - n	
						end
					end						
					mark1 = {0,0}
					mark2 = {0,0}
					if bAAfont then
						bUpdate = true
						AAscreen:clear(white)
					end						
				end		
			end
			menumode = 0
			
			if menucursor == 5 then
				mode = 8
			end
			
			if menucursor == 6 then
				mode = 9
			end
			
			if menucursor == 7 then
				table.insert(bookmark, line)
				table.sort(bookmark)
			end
			
			if menucursor == 8 then
				count = 1
				found = false
				if current == bookmark[table.getn(bookmark)] then
					current = 1
				end
				while count <= table.getn(bookmark) and not found do
					if bookmark[count] > current then
						current = bookmark[count]
						line = current
						cursor = 1
						scrollx = 0
						if n > minlines then
							scrolly = 1 - line
							if bAAfont then
								bUpdate = true
								AAscreen:clear(white)
							end
							if scrolly < minlines - n then
								scrolly = minlines - n
								if bAAfont then
									bUpdate = true
									AAscreen:clear(white)
								end		
							end							
						end		
						found = true
					end
					count = count + 1
				end
			end		
		end		
	end

	if menumode == 3 then
		if keyin ~= menukeyin then
			if keyin:right() then
				menumode = 1
				menucursor = 1
				wait = 10
			end
			
			if keyin:left() then
				lastmode = mode
				if mode < 4 then
					mode = 2
				end
				menumode = 2
				menucursor = 1
				wait = 10
			end
		end
		menukeyin = keyin
		
		if keyin:up() then
			if menucursor == 1 then
				menucursor = 4
			else 
				menucursor = menucursor - 1
			end
			wait = 10
		end
		
		if keyin:down() then
			if menucursor == 4 then
				menucursor = 1
			else
				menucursor = menucursor + 1
			end
			wait = 10
		end
		
		if keyin:cross() then
			if menucursor == 1 then
				mode = 3
				if wordwrap then
					if wordwrap1 then
						textWrap1()
					end
					if wordwrap2 then
						textWrap2()
					end
				end
			if bAAfont then
				bUpdate = true
				AAscreen:clear(white)
			end				
			end
			if menucursor == 2 then
				bAAfont = not bAAfont
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end
				mode = lastmode
			end
			if menucursor == 3 then
				wordwrap1 = not wordwrap1
				if wordwrap1 then
					wordwrap = true
					textWrap1()
				else
					wordwrap = false
				end
				wordwrap2 = false
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end
				mode = lastmode
				if mode == 3 then
					scrollx = 0
					scrolly = 0
				end
			end
			if menucursor == 4 then
				wordwrap2 = not wordwrap2
				if wordwrap2 then
					textWrap2()
					wordwrap = true
				else 
					wordwrap = false
				end
				wordwrap1 = false
				if bAAfont then
					bUpdate = true
					AAscreen:clear(white)
				end
				mode = lastmode
				if mode == 3 then
					scrollx = 0
					scrolly = 0
				end				
			end
			menumode = 0
		end
	end	
	
	
	if mode < 3 then
		list = 180
		for count = 1 - scrolly, minlines - scrolly do
			if (count*10 + scrolly*10) < list and (count*10 + scrolly*10) > 0 and count <= n then
				if scrollx < 0 then
					endtext = nMaxchar - scrollx
					if string.len(text[count]) < endtext then
						endtext = string.len(text[count])
					end
					textscroll = string.sub(text[count], 1 - scrollx, endtext)
					if not bAAfont then						
						screen:print(5, count * 10 + scrolly*10, textscroll, black)
					else
						if bUpdate then
							drawString(5, count * 10 + scrolly*10, textscroll, AAscreen)
						end
					end
				else
					endtext =  nMaxchar - scrollx
					if string.len(text[count]) < endtext then
						endtext = string.len(text[count])
					end
					textscroll = string.sub(text[count], 1, endtext)
					if not bAAfont then
						screen:print(5 + scrollx*8, count * 10 + scrolly*10, textscroll, black)
					else
						if bUpdate then
							drawString(5, count * 10 + scrolly*10, textscroll, AAscreen)
						end
					end
				end
			end
		end
	end
	

	if mode == 3 then
		list = 260
		if wordwrap then
			for count = 1 - scrolly, maxlines - scrolly do
				if (count*10 + scrolly*10) < list and (count*10 + scrolly*10) > 0 and count <= table.getn(wraptext) then				
					if not bAAfont then
						screen:print(5, count * 10 + scrolly*10, wraptext[count], black)
					else
						if bUpdate then
							drawString(5, count * 10 + scrolly*10, wraptext[count], AAscreen)
						end
					end
				end
			end
		else
			for count = 1 - scrolly, maxlines - scrolly do
				if (count*10 + scrolly*10) < list and (count*10 + scrolly*10) > 0 and count <= n then
					if scrollx < 0 then
						endtext = nMaxchar - scrollx
						if string.len(text[count]) < endtext then
							endtext = string.len(text[count])
						end
						textscroll = string.sub(text[count], 1 - scrollx, endtext)
						if not bAAfont then
							screen:print(5, count * 10 + scrolly*10, textscroll, black)
						else
							if bUpdate then
								drawString(5, count * 10 + scrolly*10, textscroll, AAscreen)
							end
						end
					else
						endtext = nMaxchar - scrollx
						if string.len(text[count]) < endtext then
							endtext = string.len(text[count])
						end
						textscroll = string.sub(text[count], 1 - scrollx, endtext)					
						if not bAAfont then
							screen:print(5 + scrollx*8, count * 10 + scrolly*10, textscroll, black)
						else
							if bUpdate then
								drawString(5, count * 10 + scrolly*10, textscroll, AAscreen)
							end
						end
					end
				end
			end
		end
		if menumode == 0 then
			if wait ~= 8 then
				wait = 2
			end
		end
	end
	
	if scrollx > 0 then
		scrollx = 0
		if bAAfont then
			bUpdate = true
			AAscreen:clear(white)
		end
	end

	if cursor < 1 then
		cursor = 1
	end
	
	if bAAfont and mode < 4 then
		screen:blit(0,0,AAscreen)
	end
	
	if mode == 1 then
		screen:blit(0,188, background, 0, 188, 480, 84)

		drawKeyboard()
		drawSmallframe()
		for count = 1, table.getn(bookmark) do
			bm = 10*bookmark[count] + 10*scrolly
			if bm >= 10 and bm <= 170 then
				screen:blit(0,bm+2,dot)
			end
		end		
		screen:print(10, 180, "Ln "..line..":"..n.."  Col "..cursor, blue)		
	end

	
	if mode == 2 then
		screen:blit(0,188, background, 0, 188, 480, 84)
		screen:blit(20,210, arrowkey)
		screen:blit(240,190, buttons)
		
		if mark2[2] ~= 0 then
			if mark2[2] == mark1[2] then
				bm = 9+(mark1[2]-1)*10 + scrolly*10
				if bm <= 170 then
					drawRect(4+(mark1[1]-1)*8 + scrollx*8, 9+(mark1[2]-1)*10 + scrolly*10, (mark2[1] - mark1[1])*8 - 2, 10, blue)
				end
			end
			if mark2[2] > mark1[2] then
				for count = mark1[2], mark2[2] do
					if count == mark2[2] then
						bm = 9+(mark2[2]-1)*10 + scrolly*10
						if bm <= 170 then
							drawRect(9 + scrollx*8, 9+(mark2[2]-1)*10 + scrolly*10, (mark2[1]-1)*8 - 2, 10, blue)
						end
					elseif count == mark1[2] then
						bm = 9+(mark1[2]-1)*10 + scrolly*10
						if bm <= 170 then
							drawRect(4+(mark1[1]-1)*8 + scrollx*8, 9+(mark1[2]-1)*10 + scrolly*10, (string.len(text[count]) - mark1[1] + 1)*8-2, 10, blue)
						end
					else
						bm = 9+(count-1)*10 + scrolly*10
						if bm <= 170 then
							drawRect(4 + scrollx*8, 9+(count-1)*10 + scrolly*10, string.len(text[count])*8-2, 10, blue)
						end
					end
				end
			end
		end
		drawSmallframe()
		for count = 1, table.getn(bookmark) do
			bm = 10*bookmark[count] + 10*scrolly
			if bm >= 10 and bm <= 170 then
				screen:blit(0,bm+2,dot)
			end
		end
		screen:print(10, 180, "Ln "..line..":"..n.."  Col "..cursor, blue)
		--screen:print(10, 180, "Ln "..line..":"..n.."  Col "..cursor.."/"..scrollx.."/"..scrolly, blue)
		seltext = "Sel1 "..mark1[1]..":"..mark1[2].."  Sel2 "..mark2[1]..":"..mark2[2]
		screen:print(470-string.len(seltext)*8, 180,seltext,blue)	
	end	
	
	if mode == 3 then
		drawLargeframe()
		if wordwrap then
			num = nw
		else
			num = n
		end
		for count = 1, table.getn(bookmark) do
			bm = 10*bookmark[count] + 10*scrolly
			if bm >= 10 and bm <= 250 then
				screen:blit(0,bm+2,dot)
			end
		end
		screen:print(10, 262, "Ln "..1-scrolly..":"..num.."  Col "..cursor, blue)
	end	
	
	if mode < 4 then
		screen:print(240-(string.len(openfile)*8)/2,0, openfile,black)
		if (line*10 + scrolly*10) > 0 and (line*10 + scrolly*10) < list and (cursor*8 + scrollx*8) >= 8 and blink < 15 then
			screen:drawLine(cursor * 8 + scrollx*8 - 4, line*10 + scrolly*10 - 2, cursor * 8 + scrollx*8 - 4, line*10 + scrolly*10 + 8 , darkgrey)
		end
	end

	if mode == 5 or mode == 7 then
		screen:blit(0,0, background)
		drawMenuframe()

		screen:fillRect(28,28,424,132,white)
		screen:fillRect(28,28,424,10,grey)
		screen:drawLine(28,37,450,37,darkgrey)
		
		if string.len(currentdir) > 52 then
			dirname = string.sub(currentdir,1,52)
		else
			dirname = currentdir
		end
		screen:print(35,29, dirname, black)
		screen:print(224,19,"Open", black)
		for count = 1, dirN do
			if string.len(dir[count].name) > 50 then
				savename = string.sub(dir[count].name,1,47)
			else
				savename = dir[count].name
			end
			if dirselect == count then
				screen:fillRect(34,30+dircursor*10 - 1, 12+string.len(savename) * 8, 10, grey)
			end
			if (dirscroll*10 + count*10) < 130 and (dirscroll*10 + count*10) > 0 then
				if dir[count].directory then
					screen:blit(35,30+dirscroll*10+count*10,folder)
					screen:print(48,30+dirscroll*10+count*10, savename, blue)
				else
					screen:blit(35,30+dirscroll*10+count*10,doc)
					screen:print(48,30+dirscroll*10+count*10, savename, black)
				end
			end
		end
		
		wait = 6
	end
	
	if mode == 6 then
		screen:blit(0,0, background)

		drawKeyboard()
		drawMenuframe()
	
		screen:fillRect(28,28,424,132,white)
		
		screen:fillRect(176,46,260,14,white)
		drawRect(176,46,260,14,darkgrey)
		screen:fillRect(176,66,260,14,grey)
		drawRect(176,66,260,14,darkgrey)
		
		screen:print(40, 50, "Name:            ",black)
		screen:print(40, 70, "Save in folder:  ",black)
		if string.len(openfile) > 32 then
			openfilescroll = string.sub(openfile,string.len(openfile)-31,string.len(openfile))
			if blink < 15 then
				screen:drawLine(178+32*8, 48, 178+32*8,58, blue)
			end
		else
			openfilescroll = openfile
			if blink < 15 then
				screen:drawLine(178+string.len(openfile)*8, 48, 178+string.len(openfile)*8,58, blue)
			end
		end
		screen:print(180,50, openfilescroll, black)
		if string.len(currentdir) > 32 then
			currentdirscroll = string.sub(currentdir,1,32)
		else
			currentdirscroll = currentdir
		end
		screen:print(180,70, currentdirscroll, black)

		screen:print(40,100, "Press Start to change folder or select a file name", blue)
		screen:print(40,120, "Press Select to cancel", blue)
		screen:print(40,140, "Press Enter to save", blue)

		screen:print(211,19,"Save As", black)
	end

	if mode == 8 then
		screen:blit(0,0, background)

		drawKeyboard()
		drawMenuframe()
	
		screen:fillRect(28,28,424,132,white)
		
		screen:fillRect(176,46,260,14,white)
		drawRect(176,46,260,14,darkgrey)

		
		screen:print(40, 50, "Search String:            ",black)
		if string.len(findtext) > 32 then
			findtextscroll = string.sub(findtext,string.len(findtext)-31,string.len(findtext))
			if blink < 15 then
				screen:drawLine(178+32*8, 48, 178+32*8,58, blue)
			end
		else
			findtextscroll = findtext
			if blink < 15 then
				screen:drawLine(178+string.len(findtext)*8, 48, 178+string.len(findtext)*8,58, blue)
			end
		end
		screen:print(180,50, findtextscroll, black)
		screen:print(40,120, "Press Select to cancel", blue)
		screen:print(40,140, "Press Enter to search", blue)
		screen:print(204,19,"Find Text", black)
	end
	
	if mode == 9 then
		screen:blit(0,0, background)

		drawKeyboard()
		drawMenuframe()
	
		screen:fillRect(28,28,424,132,white)
		
		screen:fillRect(176,46,260,14,white)
		drawRect(176,46,260,14,darkgrey)

		
		screen:print(40, 50, "Go to Line:            ",black)
		if string.len(gotoline) > 32 then
			gotolinescroll = string.sub(findtext,string.len(gotoline)-31,string.len(gotoline))
			if blink < 15 then
				screen:drawLine(178+32*8, 48, 178+32*8,58, blue)
			end
		else
			gotolinescroll = gotoline
			if blink < 15 then
				screen:drawLine(178+string.len(gotoline)*8, 48, 178+string.len(gotoline)*8,58, blue)
			end
		end
		screen:print(180,50, gotolinescroll, black)
		screen:print(40,120, "Press Select to cancel", blue)
		screen:print(40,140, "Press Enter to jump to line", blue)
		screen:print(220,19,"Go To", black)
	end
		
	if menumode > 0 then
		screen:fillRect(0,0,480,10, grey)
		screen:drawLine(0,0,480,0, lightgrey)
		screen:drawLine(0,10,480,10,darkgrey)
		if menumode == 1 then
			screen:fillRect(11,1,32,10,darkgrey)
		end
		if menumode == 2 then
			screen:fillRect(59,1,32,10,darkgrey)
		end
		if menumode == 3 then
			screen:fillRect(107,1,32,10,darkgrey)
		end
		screen:print(12,2, "File  Edit  View", black)
	end	
	
	if menumode == 1 then
		screen:print(12,2, "File", white)
		screen:fillRect(15,16,120,54,black)
		screen:fillRect(10,11,120,54, white)
		drawRect(10,13,119,51, darkgrey)
		drawRect(11,12,119,53, lightgrey)
		screen:drawLine(10,13,10,64, darkgrey)
				
		screen:fillRect(12,menucursor*10+4, 117, 10, blue)

		if menucursor == 1 then
			screen:print(30,15, "New", white)
		else
			screen:print(30,15, "New", black)
		end
		if menucursor == 2 then
			screen:print(30,25, "Open", white)
		else
			screen:print(30,25, "Open", black)
		end
		if menucursor == 3 then
			screen:print(30,35, "Save", white)
		else
			screen:print(30,35, "Save", black)
		end
		if menucursor == 4 then
			screen:print(30,45, "USB", white)
			if usb then
				screen:blit(12,44,check)
			end
		else
			screen:print(30,45, "USB", black)
			if usb then
				screen:blit(12,44,check)
			end
		end
		if menucursor == 5 then
			screen:print(30,55, "Exit", white)
		else
			screen:print(30,55, "Exit", black)
		end
	end
	
	if menumode == 2 then
		screen:print(12,2, "      Edit", white)
		screen:fillRect(63,16,140,84,black)
		screen:fillRect(58,11,140,84, white)
		drawRect(58,13,139,81, darkgrey)
		drawRect(59,12,139,83, lightgrey)
		screen:drawLine(58,13,58,94, darkgrey)
						
		screen:fillRect(60,menucursor*10+4, 137, 10, blue)
		if menucursor == 1 then
			screen:print(78, 15, "Cut", white)
		else
			screen:print(78, 15, "Cut", black)
		end
		if menucursor == 2 then
			screen:print(78,25, "Copy", white)
		else
			screen:print(78,25, "Copy", black)
		end
		if menucursor == 3 then
			screen:print(78,35, "Paste", white)
		else
			screen:print(78,35, "Paste", black)
		end
		if menucursor == 4 then
			screen:print(78,45, "Clear", white)
		else
			screen:print(78,45, "Clear", black)
		end
		if menucursor == 5 then
			screen:print(78,55, "Find", white)
		else
			screen:print(78,55, "Find", black)
		end
		if menucursor == 6 then
			screen:print(78,65, "Goto", white)
		else
			screen:print(78,65, "Goto", black)
		end
		if menucursor == 7 then
			screen:print(78,75, "Set Bookmark", white)
		else
			screen:print(78,75, "Set Bookmark", black)
		end
		if menucursor == 8 then
			screen:print(78,85, "Goto Bookmark", white)
		else
			screen:print(78,85, "Goto Bookmark", black)
		end

	end
			
	if menumode == 3 then
		screen:print(12,2, "            View", white)
		screen:fillRect(111,16,120,44,black)
		screen:fillRect(106,11,120,44, white)
		drawRect(106,13,119,41, darkgrey)
		drawRect(107,12,119,43, lightgrey)
		screen:drawLine(106,13,106,54, darkgrey)
			
		screen:fillRect(108,menucursor*10+4, 117, 10, blue)
		if menucursor == 1 then
			screen:print(126, 15, "Full Screen", white)
		else
			screen:print(126, 15, "Full Screen", black)
		end
		if menucursor == 2 then
			screen:print(126,25, "AA Font", white)
			if bAAfont then
				screen:blit(108,24,check)
			end
		else
			screen:print(126,25, "AA Font", black)
			if bAAfont then
				screen:blit(108,24,check)
			end
		end
		if menucursor == 3 then
			screen:print(126,35, "Word Wrap 1", white)
			if wordwrap1 then
				screen:blit(108,34,check)
			end
		else
			screen:print(126,35, "Word Wrap 1", black)
			if wordwrap1 then
				screen:blit(108,34,check)
			end
		end
		if menucursor == 4 then
			screen:print(126,45, "Word Wrap 2", white)
			if wordwrap2 then
				screen:blit(108,44,check)
			end
		else
			screen:print(126,45, "Word Wrap 2", black)
			if wordwrap2 then
				screen:blit(108,44,check)
			end
		end		

	end	
	
	bUpdate = false
	screen.flip()
	screen.waitVblankStart(wait)
end
