/*
 * Decompiled with CFR 0.152.
 */
package JorisS.BirdEyeNavi.functions;

import JorisS.BirdEyeNavi.functions.MathFunc;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import wt.api.WtAction;

public class BingTileSystem {
    MetaData metadata;
    Image bing;
    int zoom = 20;
    public boolean NextLoaded = false;
    public String NextLat = "";
    public String NextLon = "";

    public void LoadTile(WtAction action) throws Exception {
        int bear = 0;
        double bearin = action.getWayAngle(0);
        double lat = Double.parseDouble(action.getLat());
        double lon = Double.parseDouble(action.getLon());
        this.NextLoaded = false;
        this.NextLat = action.getLat();
        this.NextLon = action.getLon();
        bear = Math.abs(bearin - Math.floor(bearin / 90.0) * 90.0) < Math.abs(bearin - Math.ceil(bearin / 90.0) * 90.0) ? (int)Math.floor(bearin / 90.0) + 2 : (int)Math.ceil(bearin / 90.0) + 2;
        System.out.println(bearin + " " + bear);
        this.metadata = new MetaData(lat, lon, bear);
    }

    public void ShowImage(Graphics g2) {
        g2.drawImage(this.bing, g2.getClipX(), g2.getClipY(), 20);
    }

    public void LoadImage(WtAction action, Graphics g2) throws Exception {
        double lat = Double.parseDouble(action.getLat());
        double lon = Double.parseDouble(action.getLon());
        double bearIn = action.getWayAngle(0);
        double bearOut = action.getWayAngle(1);
        System.out.println(lat + "," + lon + " " + bearIn + " " + bearOut);
        this.bing = Image.createImage((int)g2.getClipWidth(), (int)g2.getClipHeight());
        Graphics gb = this.bing.getGraphics();
        int[] coordinate = this.GetPixelCoordinate(lat, lon);
        int X = coordinate[0] / 256;
        int Y = coordinate[1] / 256;
        int tileID = Y * (this.zoom - 18) * Integer.parseInt(this.metadata.FindPatern("Hcx")) + X;
        int relx = coordinate[0] - 256 * X;
        int rely = coordinate[1] - 256 * Y;
        int absX = gb.getClipWidth() / 2;
        int absY = gb.getClipHeight() / 2;
        int px = absX - relx;
        int py = absY - rely;
        this.DrawImage(gb, this.DownloadImage(tileID), px, py);
        for (int x2 = X - 1; x2 <= X + 1; ++x2) {
            for (int y2 = Y - 1; y2 <= Y + 1; ++y2) {
                if (x2 == X && y2 == Y) continue;
                int nx = px + (x2 - X) * 256;
                int ny = py + (y2 - Y) * 256;
                boolean draw = false;
                if (nx > -256 && ny > -256 && nx < gb.getClipWidth() && ny < gb.getClipHeight()) {
                    draw = true;
                }
                if (!draw) continue;
                this.DrawImage(gb, this.DownloadImage(y2 * (this.zoom - 18) * Integer.parseInt(this.metadata.FindPatern("Hcx")) + x2), nx, ny);
            }
        }
        double d2 = 0.05;
        double cb = bearIn * Math.PI / 180.0;
        double lt = lat * Math.PI / 180.0;
        double ln = lon * Math.PI / 180.0;
        double latin = MathFunc.asin(Math.sin(lt) * Math.cos(d2 / 6371.0) + Math.cos(lt) * Math.sin(d2 / 6371.0) * Math.cos(cb));
        double lonin = ln + MathFunc.atan2(Math.sin(cb) * Math.sin(d2 / 6371.0) * Math.cos(lt), Math.cos(d2 / 6371.0) - Math.sin(lt) * Math.sin(latin));
        latin = latin * 180.0 / Math.PI;
        lonin = lonin * 180.0 / Math.PI;
        int[] coordinatein = this.GetPixelCoordinate(latin, lonin);
        int Xin = coordinate[0] - coordinatein[0];
        int Yin = coordinate[1] - coordinatein[1];
        cb = bearOut * Math.PI / 180.0;
        double latout = MathFunc.asin(Math.sin(lt) * Math.cos(d2 / 6371.0) + Math.cos(lt) * Math.sin(d2 / 6371.0) * Math.cos(cb));
        double lonout = ln + MathFunc.atan2(Math.sin(cb) * Math.sin(d2 / 6371.0) * Math.cos(lt), Math.cos(d2 / 6371.0) - Math.sin(lt) * Math.sin(latin));
        latout = latout * 180.0 / Math.PI;
        lonout = lonout * 180.0 / Math.PI;
        int[] coordinateout = this.GetPixelCoordinate(latout, lonout);
        int Xout = coordinate[0] - coordinateout[0];
        int Yout = coordinate[1] - coordinateout[1];
        gb.setColor(255, 0, 0);
        gb.drawLine(gb.getClipWidth() / 2, gb.getClipHeight() / 2, gb.getClipWidth() / 2 - Xin, gb.getClipHeight() / 2 - Yin);
        gb.drawLine(gb.getClipWidth() / 2, gb.getClipHeight() / 2, gb.getClipWidth() / 2 - Xout, gb.getClipHeight() / 2 - Yout);
        this.NextLoaded = true;
    }

    private void DrawImage(Graphics g2, Image img, int px, int py) {
        g2.drawImage(img, px, py, 20);
    }

    private Image DownloadImage(int tileID) {
        String url = "http://t1.staging.tiles.virtualearth.net/tiles/cmd/ObliqueHybrid?a=" + this.metadata.FindPatern("Q").substring(1, this.metadata.FindPatern("Q").length() - 1) + "-" + this.metadata.FindPatern("RI") + "-" + this.zoom + "-" + tileID + "&g=1";
        try {
            return this.getImage(url);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public int[] GetPixelCoordinate(double latitude, double longitude) {
        int[] ret = new int[]{(int)((longitude * Double.parseDouble(this.metadata.FindPatern("XA")) + latitude * Double.parseDouble(this.metadata.FindPatern("XB")) + Double.parseDouble(this.metadata.FindPatern("XC"))) / (longitude * Double.parseDouble(this.metadata.FindPatern("XG")) + latitude * Double.parseDouble(this.metadata.FindPatern("XH")) + Double.parseDouble(this.metadata.FindPatern("XI"))) * this.pow(2, this.zoom - 20)), (int)((longitude * Double.parseDouble(this.metadata.FindPatern("XD")) + latitude * Double.parseDouble(this.metadata.FindPatern("XE")) + Double.parseDouble(this.metadata.FindPatern("XF"))) / (longitude * Double.parseDouble(this.metadata.FindPatern("XG")) + latitude * Double.parseDouble(this.metadata.FindPatern("XH")) + Double.parseDouble(this.metadata.FindPatern("XI"))) * this.pow(2, this.zoom - 20))};
        return ret;
    }

    double pow(int x2, int y2) {
        double z2 = x2;
        if (y2 > 0) {
            for (int i2 = 1; i2 < y2; ++i2) {
                z2 *= (double)x2;
            }
        } else if (y2 < 0) {
            z2 = 1.0;
            int b2 = -1 * y2;
            for (int i3 = 1; i3 <= b2; ++i3) {
                z2 /= (double)x2;
            }
        } else {
            z2 = 1.0;
        }
        System.out.println(x2 + " " + y2 + " " + z2);
        return z2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getImage(String url) throws IOException {
        ContentConnection connection = (ContentConnection)Connector.open((String)url);
        DataInputStream iStrm = connection.openDataInputStream();
        ByteArrayOutputStream bStrm = null;
        Image im = null;
        try {
            byte[] imageData;
            int length = (int)connection.getLength();
            if (length != -1) {
                imageData = new byte[length];
                iStrm.readFully(imageData);
            } else {
                int ch;
                bStrm = new ByteArrayOutputStream();
                while ((ch = iStrm.read()) != -1) {
                    bStrm.write(ch);
                }
                imageData = bStrm.toByteArray();
                bStrm.close();
            }
            im = Image.createImage((byte[])imageData, (int)0, (int)imageData.length);
        }
        finally {
            if (iStrm != null) {
                iStrm.close();
            }
            if (connection != null) {
                connection.close();
            }
            if (bStrm != null) {
                bStrm.close();
            }
        }
        return im == null ? null : im;
    }

    class MetaData {
        String metadata = "";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetaData(double latitude, double longitude, int heading) throws Exception {
            String bear = "North";
            bear = heading % 4 == 0 ? "North" : (heading % 3 == 0 ? "West" : (heading % 2 == 0 ? "South" : "East"));
            String metaurlstr = "http://dev.virtualearth.net/services/v1/ImageryMetadataService/ImageryMetadataService.asmx/GetBirdsEyeSceneByLocation?latitude=" + latitude + "&longitude=" + longitude + "&level=" + BingTileSystem.this.zoom + "&spinDirection=%22NoSpin%22&orientation=%22" + bear + "%22&culture=%22en-us%22&format=json&rid=1227643110358&";
            StreamConnection c2 = null;
            InputStream s2 = null;
            StringBuffer b2 = new StringBuffer();
            try {
                int ch;
                c2 = (StreamConnection)Connector.open((String)metaurlstr);
                s2 = c2.openInputStream();
                while ((ch = s2.read()) != -1) {
                    b2.append((char)ch);
                }
                this.metadata = b2.toString();
            }
            finally {
                if (s2 != null) {
                    s2.close();
                }
                if (c2 != null) {
                    c2.close();
                }
            }
        }

        public String FindPatern(String type) {
            int start = this.metadata.indexOf("\"" + type + "\":") + 3 + type.length();
            int end = type.equals("XI") ? this.metadata.indexOf("}", start) : this.metadata.indexOf(",", start);
            return this.metadata.substring(start, end);
        }
    }
}

