/*
 * Decompiled with CFR 0.152.
 */
package JorisS.HeightProfile.Database;

import JorisS.HeightProfile.Database.Place;
import java.util.Date;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;

public class Db {
    private static final String RecordStoreName = "HeightProfile";
    private static RecordStore recordstore = null;
    private static RecordEnumeration recordEnumeration = null;

    public static void AddPlace(int alt, int hdop, double spd, double dst, Date dt) {
        Place pl = new Place();
        pl.SetValues(alt, hdop, spd, dst, dt);
        try {
            recordstore = RecordStore.openRecordStore((String)RecordStoreName, (boolean)true);
            byte[] outputRecord = pl.getbytes();
            recordstore.addRecord(outputRecord, 0, outputRecord.length);
            recordstore.closeRecordStore();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void DeleteAll() {
        try {
            RecordStore.deleteRecordStore((String)RecordStoreName);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static Place[] GetLast(int count) {
        try {
            recordstore = RecordStore.openRecordStore((String)RecordStoreName, (boolean)true);
            recordEnumeration = recordstore.enumerateRecords(null, null, false);
            if (count > recordstore.getNumRecords()) {
                count = recordstore.getNumRecords();
            }
            Place[] retplaces = new Place[count];
            int i2 = 0;
            while (recordEnumeration.hasNextElement()) {
                if (i2 > recordstore.getNumRecords() - 1 - count) {
                    byte[] outputRecord = recordstore.getRecord(recordEnumeration.nextRecordId());
                    Place pl = new Place();
                    pl.setbytes(outputRecord);
                    retplaces[i2 - (Db.recordstore.getNumRecords() - 1) + count - 1] = pl;
                }
                ++i2;
            }
            recordstore.closeRecordStore();
            return retplaces;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static Place[] GetLast(long time) {
        try {
            int count = 0;
            recordstore = RecordStore.openRecordStore((String)RecordStoreName, (boolean)true);
            recordEnumeration = recordstore.enumerateRecords((RecordFilter)new TimeAgoFilter(time), null, false);
            count = recordEnumeration.numRecords();
            Place[] retplaces = new Place[count];
            int i2 = 0;
            while (recordEnumeration.hasNextElement()) {
                byte[] outputRecord = recordstore.getRecord(recordEnumeration.nextRecordId());
                Place pl = new Place();
                pl.setbytes(outputRecord);
                retplaces[i2] = pl;
                ++i2;
            }
            recordstore.closeRecordStore();
            return retplaces;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    static class TimeAgoFilter
    implements RecordFilter {
        private long MinTime = 0L;

        public TimeAgoFilter(long ago) {
            this.MinTime = new Date().getTime() - ago;
        }

        public boolean matches(byte[] suspect) {
            Place pl = new Place();
            return pl.setbytes(suspect) && pl.GetDate().getTime() >= this.MinTime;
        }

        public void filterClose() {
        }
    }
}

