/*
 * Decompiled with CFR 0.152.
 */
package JorisS.HeightProfile.Database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Date;

public class Place {
    private int altitude;
    private int hdop;
    private double speed;
    private double tripdistance;
    private Date date;

    public boolean setbytes(byte[] byteInputData) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteInputData);
            DataInputStream inputDataStream = new DataInputStream(inputStream);
            this.altitude = inputDataStream.readInt();
            this.hdop = inputDataStream.readInt();
            this.speed = inputDataStream.readDouble();
            this.tripdistance = inputDataStream.readDouble();
            this.date = new Date(inputDataStream.readLong());
            inputDataStream.close();
            inputStream.close();
            return true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public byte[] getbytes() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream outputDataStream = new DataOutputStream(outputStream);
            outputDataStream.writeInt(this.altitude);
            outputDataStream.writeInt(this.hdop);
            outputDataStream.writeDouble(this.speed);
            outputDataStream.writeDouble(this.tripdistance);
            outputDataStream.writeLong(this.date.getTime());
            outputDataStream.flush();
            byte[] outputRecord = outputStream.toByteArray();
            outputStream.close();
            outputDataStream.close();
            return outputRecord;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public void SetValues(int alt, int hdop, double spd, double dst, Date dt) {
        this.altitude = alt;
        this.hdop = hdop;
        this.speed = spd;
        this.tripdistance = dst;
        this.date = dt;
    }

    public int GetAltitude() {
        return this.altitude;
    }

    public int Gethdop() {
        return this.hdop;
    }

    public double GetSpeed() {
        return this.speed;
    }

    public double GetTripDistance() {
        return this.tripdistance;
    }

    public Date GetDate() {
        return this.date;
    }
}

