/*
 * Decompiled with CFR 0.152.
 */
package JorisS.HeightProfile.DynGraph;

import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DynGraph {
    public static int VALTYPE_NUMBER = 0;
    public static int VALTYPE_HOUR = 1;
    private final int MAXZOOM;
    double[] x;
    double[] y;
    double[] z;
    int valtypex;
    int valtypey;
    int valtypez;
    double xx;
    double nx;
    double xy;
    double ny;
    double xz;
    double nz;
    double xr;
    double yr;
    double zr;
    int width;
    int height;
    boolean withAxis;
    Image img;
    Graphics g;
    int posx = 0;
    int posy = 0;
    int zoomx = 1;
    int zoomy = 1;
    double xpw;
    double ypw;
    double xsp;
    double ysp;
    double xep;
    double yep;
    double xrp;
    double yrp;
    int nborder;
    int eborder;
    int sborder;
    int wborder;
    Font mFont = Font.getFont((int)64, (int)0, (int)8);

    public DynGraph() {
        this.MAXZOOM = 16;
    }

    public void ZoomXIn() {
        if (this.zoomx != 16) {
            this.zoomx = this.zoomy * 2;
        }
    }

    public void ZoomXOut() {
        if (this.zoomx != 1) {
            this.zoomx /= 2;
        }
    }

    public void ZoomYIn() {
        if (this.zoomy != 16) {
            this.zoomy *= 2;
        }
    }

    public void ZoomYOut() {
        if (this.zoomy != 1) {
            this.zoomy /= 2;
        }
    }

    public void MoveX(int val) {
        this.posx += val;
    }

    public void MoveY(int val) {
        this.posy += val;
    }

    public void Reset() {
        this.zoomx = 1;
        this.zoomy = 1;
        this.posx = 0;
        this.posy = 0;
    }

    private double GraphX() {
        return this.nx + (double)this.posx * this.xpw;
    }

    private double GraphY() {
        return this.ny + (double)this.posy * this.ypw;
    }

    private void UpdateYPosFromX() {
        double gx = this.GraphX();
        for (int i2 = 1; i2 < this.x.length; ++i2) {
            if (!(this.x[i2 - 1] > gx) || !(this.x[i2] < gx)) continue;
            double x0 = this.x[i2 - 1];
            double x1 = this.x[i2];
            double y0 = this.y[i2 - 1];
            double y1 = this.y[i2];
            double rx01 = (gx - x0) / (x1 - x0);
            double v2 = y0 + rx01 * (y1 - y0);
            this.posy = (int)((v2 - this.ny) / this.ypw);
            return;
        }
    }

    public void SetData(double[] x2, int vtx, double[] y2, int vty, double[] z2, int vtz) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.valtypex = vtx;
        this.valtypey = vty;
        this.valtypez = vtz;
        this.nx = Double.MAX_VALUE;
        this.ny = Double.MAX_VALUE;
        this.nz = Double.MAX_VALUE;
        this.xx = Double.MIN_VALUE;
        this.xy = Double.MIN_VALUE;
        this.xz = Double.MIN_VALUE;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            this.nx = Math.min(this.nx, x2[i2]);
            this.ny = Math.min(this.ny, y2[i2]);
            this.nz = Math.min(this.nz, z2[i2]);
            this.xx = Math.max(this.xx, x2[i2]);
            this.xy = Math.max(this.xy, y2[i2]);
            this.xz = Math.max(this.xz, z2[i2]);
        }
        if (Math.abs(this.xx - this.nx) < 1.0) {
            this.xx += 1.0;
        }
        if (Math.abs(this.xy - this.ny) < 1.0) {
            this.xy += 1.0;
        }
        if (Math.abs(this.xz - this.nz) < 1.0) {
            this.xz += 1.0;
        }
        this.xr = this.xx - this.nx;
        this.yr = this.xy - this.ny;
        this.zr = this.xz - this.nz;
        this.ny -= this.yr / 10.0;
        this.xy += this.yr / 10.0;
        this.yr = this.xy - this.ny;
    }

    public Image GetGraph(int width, int height, boolean withAxis) {
        this.width = width;
        this.height = height;
        this.withAxis = withAxis;
        this.img = Image.createImage((int)width, (int)height);
        this.g = this.img.getGraphics();
        this.CalculateConstants();
        this.Background1();
        this.Axis1();
        this.Graph3D();
        this.Background2();
        this.Axis2();
        return this.img;
    }

    private void CalculateConstants() {
        this.nborder = 5;
        this.eborder = 5;
        if (this.withAxis) {
            this.sborder = 2 + this.mFont.getHeight();
            this.wborder = this.mFont.stringWidth("888.8");
        } else {
            this.sborder = 5;
            this.wborder = 5;
        }
        this.xpw = 1.0 / (double)this.zoomx * this.xr / ((double)this.width - (double)this.eborder - (double)this.wborder);
        this.ypw = 1.0 / (double)this.zoomy * this.yr / ((double)this.height - (double)this.nborder - (double)this.sborder);
        this.xsp = this.nx + (double)this.posx * this.xpw;
        this.ysp = this.ny + (double)this.posy * this.ypw;
        this.xep = this.xsp + this.xpw * ((double)this.width - (double)this.eborder - (double)this.wborder);
        this.yep = this.ysp + this.ypw * ((double)this.height - (double)this.nborder - (double)this.sborder);
        this.xrp = this.xep - this.xsp;
        this.yrp = this.yep - this.ysp;
    }

    private void Background1() {
        this.g.setColor(0xFFFFFF);
        this.g.fillRect(this.wborder, this.nborder, this.width - this.wborder - this.eborder, this.height - this.nborder - this.sborder);
    }

    private void Background2() {
        this.g.setColor(0xDDDDDD);
        this.g.fillRect(0, 0, this.wborder, this.height);
        this.g.fillRect(this.width - this.eborder, 0, this.eborder, this.height);
        this.g.fillRect(this.wborder, 0, this.width - this.wborder - this.eborder, this.nborder);
        this.g.fillRect(this.wborder, this.height - this.sborder, this.width - this.wborder - this.eborder, this.sborder);
    }

    private void Axis1() {
        this.g.setColor(182, 173, 166);
        if (this.withAxis) {
            this.g.drawLine(this.wborder + (this.width - this.wborder - this.eborder), this.nborder, this.wborder + (this.width - this.wborder - this.eborder), this.height - this.sborder);
            this.g.drawLine(this.width - this.eborder, this.nborder, this.width - this.eborder, this.height - this.sborder);
            this.g.drawLine(this.wborder, this.nborder, this.width - this.eborder, this.nborder);
            this.g.drawLine(this.wborder, this.nborder + (this.height - this.nborder - this.sborder) / 2, this.width - this.eborder, this.nborder + (this.height - this.nborder - this.sborder) / 2);
        }
    }

    private void Axis2() {
        this.g.setColor(182, 173, 166);
        this.g.drawLine(this.wborder, this.nborder, this.wborder, this.height - this.sborder);
        this.g.drawLine(this.wborder, this.height - this.sborder, this.width - this.eborder, this.height - this.sborder);
        if (this.withAxis) {
            this.g.setFont(this.mFont);
            double v2 = this.rnd(this.xsp, 1);
            String vs = this.valtypex == VALTYPE_HOUR ? this.GetHHMmmDate(v2) : v2 + "";
            this.g.drawString(vs, this.wborder - this.mFont.stringWidth(vs) / 2, this.height - 1, 0x40 | 4);
            v2 = this.rnd(this.xep, 1);
            vs = this.valtypex == VALTYPE_HOUR ? this.GetHHMmmDate(v2) : v2 + "";
            this.g.drawString(vs, this.width - 1, this.height - 1, 0x40 | 8);
            v2 = this.rnd(this.xsp + (this.xep - this.xsp) / 2.0, 1);
            vs = this.valtypex == VALTYPE_HOUR ? this.GetHHMmmDate(v2) : v2 + "";
            this.g.drawString(vs, this.wborder + (this.width - this.wborder - this.eborder) / 2 - this.mFont.stringWidth(v2 + "") / 2, this.height - 1, 0x40 | 4);
            v2 = this.rnd(this.ysp, 1);
            this.g.drawString(v2 + "", this.wborder - 1, this.height - this.sborder + this.mFont.getHeight() / 2, 0x40 | 8);
            v2 = this.rnd(this.yep, 1);
            this.g.drawString(v2 + "", this.wborder - 1, this.nborder - this.mFont.getHeight() / 2, 0x10 | 8);
            v2 = this.rnd(this.ysp + (this.yep - this.ysp) / 2.0, 1);
            this.g.drawString(v2 + "", this.wborder - 1, this.nborder + (this.height - this.nborder - this.sborder) / 2 - this.mFont.getHeight() / 2, 0x10 | 8);
        }
    }

    private void Graph3D() {
        for (int i2 = 1; i2 < this.x.length; ++i2) {
            double X0 = this.x[i2 - 1];
            double X1 = this.x[i2];
            double Y0 = this.y[i2 - 1];
            double Y1 = this.y[i2];
            double Z0 = this.z[i2 - 1];
            double Z1 = this.z[i2];
            double PX0 = (X0 - this.xsp) / this.xpw;
            double PY0 = (Y0 - this.ysp) / this.ypw;
            double PX1 = (X1 - this.xsp) / this.xpw;
            double PY1 = (Y1 - this.ysp) / this.ypw;
            int x0 = (int)((double)this.wborder + PX0);
            int x1 = (int)((double)this.wborder + PX1);
            int y0 = (int)((double)this.height - (double)this.sborder - PY0);
            int y1 = (int)((double)this.height - (double)this.sborder - PY1);
            if (x1 < this.width && x0 != x1) {
                int j2 = x0;
                while (j2 >= x1) {
                    double curperc = ((double)j2 - (double)x0) / ((double)x1 - (double)x0);
                    double curval = curperc * (Z1 - this.nz) + (1.0 - curperc) * (Z0 - this.nz);
                    int[] c2 = this.GetColor(this.zr, curval);
                    this.g.setColor(c2[0], c2[1], c2[2]);
                    int cx = j2--;
                    int cy = (int)((double)y0 + curperc * ((double)y1 - (double)y0));
                    this.g.drawLine(cx, cy, cx, this.height - this.sborder);
                }
                this.g.setColor(82, 122, 174);
                this.g.drawLine(x0, y0, x1, y1);
            }
            if (!(PX1 < 0.0)) continue;
            return;
        }
    }

    private double rnd(double val, int nr) {
        int exp = 1;
        for (int i2 = 0; i2 < nr; ++i2) {
            exp *= 10;
        }
        double v2 = val * (double)exp;
        return (double)((int)v2) / (double)exp;
    }

    private int[] GetColor(double steps, double cur) {
        System.out.println("steps: " + steps + " " + cur);
        double[] endcolor = new double[]{186.0, 71.0, 66.0};
        double[] startcolor = new double[]{150.0, 181.0, 85.0};
        double[] stepcolor = new double[]{(startcolor[0] - endcolor[0]) / steps, (startcolor[1] - endcolor[1]) / steps, (startcolor[2] - endcolor[2]) / steps};
        int[] ret = new int[]{(int)Math.floor(startcolor[0] - stepcolor[0] * cur), (int)Math.floor(startcolor[1] - stepcolor[1] * cur), (int)Math.floor(startcolor[2] - stepcolor[2] * cur)};
        return ret;
    }

    private String GetHHMmmDate(double dt) {
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date((long)dt));
        int h2 = c2.get(11);
        int m2 = c2.get(12);
        String t2 = (h2 < 10 ? "0" : "") + h2 + ":" + (m2 < 10 ? "0" : "") + m2;
        return t2;
    }
}

