/*
 * Decompiled with CFR 0.152.
 */
package JorisS.HeightProfile;

import JorisS.HeightProfile.DynGraph.DynGraph;
import JorisS.HeightProfile.HeightProfile;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Profile
extends Canvas
implements CommandListener {
    private HeightProfile root;
    private static final Command back = new Command("Back", 2, 2);
    private static final Command dirchange = new Command("Rotate", 8, 2);
    private int rotate;
    private String GraphType;
    private DynGraph dyng;
    public double[] Time = new double[0];
    public double[] Height = new double[0];
    public double[] Speed = new double[0];

    public Profile(HeightProfile root) {
        this.root = root;
        this.rotate = 0;
        this.GraphType = "ALT_TIME";
        this.dyng = new DynGraph();
        this.addCommand(back);
        this.addCommand(dirchange);
        this.setCommandListener(this);
    }

    protected void paint(Graphics g2) {
        this.dyng.SetData(this.Time, DynGraph.VALTYPE_NUMBER, this.Height, DynGraph.VALTYPE_NUMBER, this.Speed, DynGraph.VALTYPE_NUMBER);
        g2.setColor(255, 255, 255);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.DrawGraph(g2);
    }

    private void DrawGraph(Graphics gr) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.rotate != 0) {
            width = this.getHeight();
            height = this.getWidth();
        }
        Image img = this.dyng.GetGraph(width, height, true);
        try {
            gr.drawImage(Profile.rotateImage(img, this.rotate), 0, 0, 0x10 | 4);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Image rotateImage(Image image, int angle) throws Exception {
        if (angle == 0) {
            return image;
        }
        if (angle != 180 && angle != 90 && angle != 270) {
            throw new Exception("Invalid angle");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rowData = new int[width];
        int[] rotatedData = new int[width * height];
        int rotatedIndex = 0;
        for (int i2 = 0; i2 < height; ++i2) {
            image.getRGB(rowData, 0, width, 0, i2, width, 1);
            for (int j2 = 0; j2 < width; ++j2) {
                rotatedIndex = angle == 90 ? height - i2 - 1 + j2 * height : (angle == 270 ? i2 + height * (width - j2 - 1) : width * height - (i2 * width + j2) - 1);
                rotatedData[rotatedIndex] = rowData[j2];
            }
        }
        if (angle == 90 || angle == 270) {
            return Image.createRGBImage((int[])rotatedData, (int)height, (int)width, (boolean)true);
        }
        return Image.createRGBImage((int[])rotatedData, (int)width, (int)height, (boolean)true);
    }

    public void commandAction(Command c2, Displayable d2) {
        if (c2 == back) {
            this.root.d.setCurrent((Displayable)this.root.f);
        } else if (c2 == dirchange) {
            this.rotate -= 90;
            if (this.rotate < 0) {
                this.rotate += 360;
            }
            if (this.rotate == 180) {
                this.rotate -= 90;
            }
            this.repaint();
        }
    }

    protected void keyPressed(int keycode) {
        switch (keycode) {
            case 49: {
                this.dyng.ZoomYOut();
                break;
            }
            case 51: {
                this.dyng.ZoomYIn();
                break;
            }
            case 55: {
                this.dyng.ZoomXOut();
                break;
            }
            case 57: {
                this.dyng.ZoomXIn();
                break;
            }
            case 53: {
                this.dyng.Reset();
                break;
            }
        }
        switch (this.getGameAction(keycode)) {
            case 1: {
                this.dyng.MoveY(1);
                break;
            }
            case 5: {
                this.dyng.MoveX(1);
                break;
            }
            case 6: {
                this.dyng.MoveY(-1);
                break;
            }
            case 2: {
                this.dyng.MoveX(-1);
                break;
            }
        }
        this.repaint();
    }
}

