/*
 * Decompiled with CFR 0.152.
 */
package JorisS.NaviHelper;

import JorisS.NaviHelper.BmpFont;
import JorisS.NaviHelper.Gradient;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import wt.api.WtAction;
import wt.api.WtCommon;
import wt.api.WtSkinlet;

public class NaviHelper
implements WtSkinlet {
    WtCommon c = null;
    WtAction act = null;
    BmpFont speedfont;
    Font sfont;
    String DrawType = "Speed";
    int IconNumber = 1;
    String IconType = "";

    public void setInit(WtCommon arg0, Hashtable arg1) {
        this.c = arg0;
        this.DrawType = arg1.get("DrawType").toString();
        if (this.DrawType.equals("Icon")) {
            this.IconNumber = Integer.parseInt(arg1.get("IconNumber").toString());
            if (arg1.get("IconType") != null) {
                this.IconType = arg1.get("IconType").toString();
            }
        }
    }

    public void paint(Graphics g2) {
        try {
            this.speedfont = new BmpFont("/JorisS/NaviHelper/resources/speedfont.png", 19, 30, "0");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.sfont = Font.getFont((int)64, (int)0, (int)8);
        this.act = this.c.getNextAction();
        if (this.DrawType.equals("Speed")) {
            this.DrawBottomBorder(g2);
            this.DrawSpeedSign(g2);
        }
        if (this.DrawType.equals("Icon")) {
            try {
                this.DrawSign(g2, this.IconNumber - 1);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    private void DrawSpeedSign(Graphics g2) {
        int h2 = this.sfont.getHeight() + 4;
        Image speedsign = null;
        try {
            speedsign = Image.createImage((String)"/JorisS/NaviHelper/resources/speedborder.png");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        int y2 = g2.getClipY();
        int x2 = g2.getClipX();
        g2.drawImage(speedsign, x2 - 1, y2, 20);
        String speed = this.GetAttribute("{curspd.default}");
        if (speed.indexOf(",") > -1) {
            speed = speed.substring(0, speed.indexOf(","));
        }
        if (speed.indexOf(".") > -1) {
            speed = speed.substring(0, speed.indexOf("."));
        }
        if (speed.indexOf(" ") > -1) {
            speed = speed.substring(0, speed.indexOf(" "));
        }
        x2 += 28;
        this.speedfont.DrawString(g2, speed, x2 -= speed.length() * 19 / 2, y2 += 23);
    }

    private void DrawBottomBorder(Graphics g2) {
        g2.setFont(this.sfont);
        int ch = g2.getClipHeight();
        int cw = g2.getClipWidth();
        int height = this.sfont.getHeight() + 4;
        Gradient.gradientBox(g2, 0x3333BC, 12434914, 0, g2.getClipY() + ch - height, cw, (int)Math.ceil(height / 2), 0);
        Gradient.gradientBox(g2, 12434914, 0x3333BC, 0, g2.getClipY() + ch - height + (int)Math.ceil(height / 2), cw, (int)Math.floor(height / 2), 0);
        g2.setColor(15421715);
        int sx = cw / 2;
        int sy = g2.getClipY() + ch - height + 2;
        g2.drawString(this.GetAttribute("{streetname}"), sx, sy, 17);
    }

    private void DrawSideLeft(Graphics g2, boolean nav) {
        if (!nav) {
            return;
        }
        g2.setColor(0x3333BC);
        Font sfont = Font.getFont((int)64, (int)0, (int)8);
        g2.setFont(sfont);
        int width = 50;
        int widthext = 20;
        int ch = g2.getClipHeight() - 18;
        int ubh = sfont.getHeight() + 4;
        g2.fillRect(0, ch - ubh * 3, width, 2 * ubh);
        g2.fillTriangle(width, ch - ubh, width, ch - 3 * ubh, width + widthext, ch - ubh);
        g2.setColor(12434914);
        g2.drawLine(width, ch - 3 * ubh, width + widthext, ch - ubh);
        g2.drawLine(width - 1, ch - 3 * ubh, width + widthext - 1, ch - ubh);
        Gradient.gradientBox(g2, 0x3333BC, 12434914, 0, ch - 4 * ubh, width, ubh, 0);
        Gradient.gradientBox(g2, 0x3333BC, 12434914, 0, ch - 5 * ubh, width, ubh, 0);
        g2.setColor(12434914);
        g2.drawLine(0, ch - 5 * ubh, width, ch - 5 * ubh);
        g2.drawLine(0, ch - 5 * ubh + 1, width, ch - 5 * ubh + 1);
        g2.drawLine(0, ch - 4 * ubh, width, ch - 4 * ubh);
        g2.drawLine(0, ch - 4 * ubh + 1, width, ch - 4 * ubh + 1);
        g2.drawLine(width, ch - 5 * ubh, width, ch - 3 * ubh);
        g2.drawLine(width - 1, ch - 5 * ubh, width - 1, ch - 3 * ubh);
        g2.setColor(15421715);
        g2.drawString(this.GetAttribute("{actiondist.m}") + "m", width / 2, ch - 5 * ubh + 2, 17);
    }

    private void DrawSideRight(Graphics g2, boolean nav) {
        if (!nav) {
            return;
        }
        g2.setColor(0x3333BC);
        Font sfont = Font.getFont((int)64, (int)0, (int)8);
        Font lfont = Font.getFont((int)64, (int)0, (int)0);
        g2.setFont(sfont);
        int width = 50;
        int widthext = 20;
        int cw = g2.getClipWidth();
        int ch = g2.getClipHeight() - 18;
        int ubh = sfont.getHeight() + 4;
        g2.fillRect(cw - width, ch - ubh * 3, width, 2 * ubh);
        g2.fillTriangle(cw - width, ch - ubh, cw - width, ch - 3 * ubh, cw - (width + widthext), ch - ubh);
        g2.setColor(12434914);
        g2.drawLine(cw - width, ch - 3 * ubh, cw - (width + widthext), ch - ubh);
        g2.drawLine(cw - width - 1, ch - 3 * ubh, cw - (width + widthext - 1), ch - ubh);
        Gradient.gradientBox(g2, 0x3333BC, 12434914, cw - width, ch - 4 * ubh, width, ubh, 0);
        Gradient.gradientBox(g2, 0x3333BC, 12434914, cw - width, ch - 5 * ubh, width, ubh, 0);
        g2.setColor(12434914);
        g2.drawLine(cw - width, ch - 5 * ubh, cw, ch - 5 * ubh);
        g2.drawLine(cw - width, ch - 5 * ubh + 1, cw, ch - 5 * ubh + 1);
        g2.drawLine(cw - width, ch - 4 * ubh, cw, ch - 4 * ubh);
        g2.drawLine(cw - width, ch - 4 * ubh + 1, cw, ch - 4 * ubh + 1);
        g2.drawLine(cw - width, ch - 5 * ubh, cw - width, ch - 3 * ubh);
        g2.drawLine(cw - (width - 1), ch - 5 * ubh, cw - (width - 1), ch - 3 * ubh);
        g2.setColor(15421715);
        g2.drawString(this.GetAttribute("{destdist.default}"), cw - width / 2, ch - 5 * ubh + 2, 17);
        g2.setFont(lfont);
        g2.drawString(this.GetAttribute("{curspd.default}"), cw - width / 2, ch - 2 * ubh - lfont.getHeight() / 2, 17);
    }

    private void DrawSign(Graphics g2, int pos) throws Exception {
        int luma;
        if (this.act == null) {
            return;
        }
        WtAction wtact = this.act;
        while (wtact.getNbrOfWays() <= 2) {
            if ((wtact = wtact.getNextAction()) != null) continue;
            return;
        }
        if (pos >= 1) {
            if ((wtact = wtact.getNextAction()) == null) {
                return;
            }
            while (wtact.getNbrOfWays() <= 2) {
                if ((wtact = wtact.getNextAction()) != null) continue;
                return;
            }
        }
        if (pos == 2) {
            if ((wtact = wtact.getNextAction()) == null) {
                return;
            }
            while (wtact.getNbrOfWays() <= 2) {
                if ((wtact = wtact.getNextAction()) != null) continue;
                return;
            }
        }
        System.out.println("ActionType " + pos + " : " + wtact.getActionType());
        float cr = pos > 0 ? 0.3f : 1.0f;
        float cg = pos > 0 ? 0.59f : 1.0f;
        float cb = pos > 0 ? 0.11f : 1.0f;
        int width = g2.getClipWidth();
        int ch = g2.getClipY();
        int ubh = this.sfont.getHeight() + 4;
        int sw = width - 6;
        int sh = 3 * ubh - 4;
        int r2 = Math.min(sw, sh);
        if (pos == 0) {
            g2.setColor(51, 51, 188);
        } else {
            luma = (int)(51.0f * cr + 51.0f * cg + 51.0f * cb);
            g2.setColor(luma, luma, luma);
        }
        g2.fillRoundRect(g2.getClipX(), g2.getClipY(), sw, pos > 0 ? sh : sh + ubh, r2 / 2, r2 / 2);
        if (pos == 0) {
            g2.setColor(235, 81, 19);
        } else {
            luma = (int)(235.0f * cr + 81.0f * cg + 19.0f * cb);
            g2.setColor(luma, luma, luma);
        }
        g2.drawRoundRect(g2.getClipX(), g2.getClipY(), sw, pos > 0 ? sh : sh + ubh, r2 / 2, r2 / 2);
        if (!this.IconType.equals("")) {
            int type = wtact.getActionType();
            g2.drawImage(this.GetImage(this.IconType + "/" + type + ".png"), g2.getClipX() + 2, g2.getClipY() + 2, 20);
        } else {
            int[] headings = new int[]{45, 200, 300};
            boolean heading1 = false;
            boolean heading2 = true;
            int cx = g2.getClipX() + width / 2;
            int cy = g2.getClipY() + sh / 2;
            r2 = (r2 - 4) / 2;
            for (int i2 = 0; i2 < wtact.getNbrOfWays(); ++i2) {
                if (pos == 0) {
                    g2.setColor(189, 189, 226);
                } else {
                    int luma2 = (int)(189.0f * cr + 189.0f * cg + 226.0f * cb);
                    g2.setColor(luma2, luma2, luma2);
                }
                int heading = wtact.getWayAngle(i2) + 180 - wtact.getWayAngle(0);
                this.renderRotatedRectangle(cx, cy, 8, r2, heading, g2, false);
            }
            if (pos == 0) {
                g2.setColor(235, 81, 19);
            } else {
                int luma3 = (int)(235.0f * cr + 81.0f * cg + 19.0f * cb);
                g2.setColor(luma3, luma3, luma3);
            }
            g2.fillArc(cx - 5, cy - 5, 10, 10, 0, 360);
            this.renderRotatedRectangle(cx, cy, 6, r2, 180, g2, false);
            this.renderRotatedRectangle(cx, cy, 6, r2, wtact.getWayAngle(1) + 180 - wtact.getWayAngle(0), g2, true);
        }
        if (pos > 0) {
            return;
        }
        g2.setColor(15421715);
        int sx = 3 + width / 2;
        int sy = ch + sh;
        g2.setFont(this.sfont);
        g2.drawString(this.act.getDistanceToEnd() + "m", sx, sy, 17);
    }

    public void renderRotatedRectangle(int x2, int y2, int width, int height, int rot, Graphics g2, boolean arrow) {
        double torad = Math.PI / 180;
        int ox = (int)Math.ceil((double)(width / 2) * Math.sin((double)(rot + 90) * torad));
        int x22 = (int)((double)(height - width / 2) * Math.sin((double)rot * torad));
        int oy = (int)Math.ceil((double)(-1 * (width / 2)) * Math.cos((double)(rot + 90) * torad));
        int y22 = (int)((double)(-1 * (height - width / 2)) * Math.cos((double)rot * torad));
        int xa = ox;
        int ya = oy;
        int xb = -ox;
        int yb = -oy;
        int xc = x22 + ox;
        int yc = y22 + oy;
        int xd = x22 - ox;
        int yd = y22 - oy;
        g2.fillTriangle(x2 + xa, y2 + ya, x2 + xb, y2 + yb, x2 + xc, y2 + yc);
        g2.fillTriangle(x2 + xc, y2 + yc, x2 + xd, y2 + yd, x2 + xb, y2 + yb);
        if (arrow) {
            int xe = (int)((double)height * Math.sin((double)rot * torad));
            int ye = (int)((double)(-1 * height) * Math.cos((double)rot * torad));
            int xs = x22 - 2 * (xe - x22);
            int ys = y22 - 2 * (ye - y22);
            g2.fillTriangle(x2 + xe, y2 + ye, x2 + x22, y2 + y22, x2 + xs + 2 * ox, y2 + ys + 2 * oy);
            g2.fillTriangle(x2 + xe, y2 + ye, x2 + x22, y2 + y22, x2 + xs - 2 * ox, y2 + ys - 2 * oy);
        }
    }

    public String GetAttribute(String attr) {
        try {
            String s2 = this.c.getAttributeValue(attr);
            if (s2 == null) {
                return "";
            }
            return s2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    public boolean handleKeyCode(int arg0) {
        return false;
    }

    public String[] getTrackFields() {
        return null;
    }

    public boolean handleCommand(String arg0, Hashtable arg1) {
        return false;
    }

    public boolean isVisible() {
        return true;
    }

    private Image GetImage(String img) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:" + this.c.getAttributeValue("{rootdir}") + "Skins/Navihelper/Icons/" + img));
            Image i2 = Image.createImage((InputStream)fc.openInputStream());
            fc.close();
            return i2;
        }
        catch (Exception e2) {
            this.c.log(e2.getMessage());
            return Image.createImage((int)1, (int)1);
        }
    }
}

