/*
 * Decompiled with CFR 0.152.
 */
package JorisS.SatView;

public final class MathFunc {
    private static final double PIover2 = 1.5707963267948966;
    private static final double PIover4 = 0.7853981633974483;
    private static final double PIover6 = 0.5235987755982988;
    private static final double PIover12 = 0.2617993877991494;
    private static final double ATAN_CONSTANT = 1.732050807569;

    public static double acos(double a2) {
        if (Double.isNaN(a2) || Math.abs(a2) > 1.0) {
            return Double.NaN;
        }
        double aSquared = a2 * a2;
        double arcCosine = MathFunc.atan2(Math.sqrt(1.0 - aSquared), a2);
        return arcCosine;
    }

    public static double asin(double a2) {
        if (Double.isNaN(a2) || Math.abs(a2) > 1.0) {
            return Double.NaN;
        }
        if (a2 == 0.0) {
            return a2;
        }
        double aSquared = a2 * a2;
        double arcSine = MathFunc.atan2(a2, Math.sqrt(1.0 - aSquared));
        return arcSine;
    }

    public static double atan(double a2) {
        if (Double.isNaN(a2)) {
            return Double.NaN;
        }
        if (a2 == 0.0) {
            return a2;
        }
        boolean negative = false;
        boolean greaterThanOne = false;
        int i2 = 0;
        if (a2 < 0.0) {
            a2 = -a2;
            negative = true;
        }
        if (a2 > 1.0) {
            a2 = 1.0 / a2;
            greaterThanOne = true;
        }
        while (a2 > 0.2617993877991494) {
            ++i2;
            double t2 = a2 + 1.732050807569;
            t2 = 1.0 / t2;
            a2 *= 1.732050807569;
            a2 -= 1.0;
            a2 *= t2;
        }
        double aSquared = a2 * a2;
        double arcTangent = aSquared + 1.4087812;
        arcTangent = 0.55913709 / arcTangent;
        arcTangent += 0.60310579;
        arcTangent -= 0.05160454 * aSquared;
        arcTangent *= a2;
        while (i2 > 0) {
            arcTangent += 0.5235987755982988;
            --i2;
        }
        if (greaterThanOne) {
            arcTangent = 1.5707963267948966 - arcTangent;
        }
        if (negative) {
            arcTangent = -arcTangent;
        }
        return arcTangent;
    }

    public static double atan2(double y2, double x2) {
        double arcTangent;
        if (Double.isNaN(y2) || Double.isNaN(x2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(y2)) {
            if (y2 > 0.0) {
                if (Double.isInfinite(x2)) {
                    if (x2 > 0.0) {
                        return 0.7853981633974483;
                    }
                    return 2.356194490192345;
                }
                if (x2 != 0.0) {
                    return 1.5707963267948966;
                }
            } else {
                if (Double.isInfinite(x2)) {
                    if (x2 > 0.0) {
                        return -0.7853981633974483;
                    }
                    return -2.356194490192345;
                }
                if (x2 != 0.0) {
                    return -1.5707963267948966;
                }
            }
        } else if (y2 == 0.0) {
            if (x2 > 0.0) {
                return y2;
            }
            if (x2 < 0.0) {
                return Math.PI;
            }
        } else if (Double.isInfinite(x2)) {
            if (x2 > 0.0) {
                if (y2 > 0.0) {
                    return 0.0;
                }
                if (y2 < 0.0) {
                    return -0.0;
                }
            } else {
                if (y2 > 0.0) {
                    return Math.PI;
                }
                if (y2 < 0.0) {
                    return -Math.PI;
                }
            }
        } else if (x2 == 0.0) {
            if (y2 > 0.0) {
                return 1.5707963267948966;
            }
            if (y2 < 0.0) {
                return -1.5707963267948966;
            }
        }
        arcTangent = Math.abs(x2) > Math.abs(y2) ? MathFunc.atan(y2 / x2) : ((arcTangent = MathFunc.atan(x2 / y2)) < 0.0 ? -1.5707963267948966 - arcTangent : 1.5707963267948966 - arcTangent);
        if (x2 < 0.0) {
            arcTangent = y2 < 0.0 ? (arcTangent -= Math.PI) : (arcTangent += Math.PI);
        }
        return arcTangent;
    }

    public static int round(float a2) {
        return (int)Math.floor(a2 + 0.5f);
    }

    public static long round(double a2) {
        return (long)Math.floor(a2 + 0.5);
    }

    public static double pow(double a2, double b2) {
        double p2;
        int i2;
        boolean gt1 = !(Math.sqrt((a2 - 1.0) * (a2 - 1.0)) <= 1.0);
        int oc = -1;
        int iter = 20;
        if (b2 - Math.floor(b2) == 0.0) {
            double p3 = a2;
            int i3 = 1;
            while ((double)i3 < b2) {
                p3 *= a2;
                ++i3;
            }
            return p3;
        }
        double x2 = gt1 ? a2 / (a2 - 1.0) : a2 - 1.0;
        double sumX = gt1 ? 1.0 / x2 : x2;
        for (i2 = 2; i2 < iter; ++i2) {
            p2 = x2;
            for (int j2 = 1; j2 < i2; ++j2) {
                p2 *= x2;
            }
            double xTemp = gt1 ? 1.0 / ((double)i2 * p2) : p2 / (double)i2;
            sumX = gt1 ? sumX + xTemp : sumX + xTemp * (double)oc;
            oc *= -1;
        }
        double x22 = b2 * sumX;
        double sumY = 1.0 + x22;
        for (i2 = 2; i2 <= iter; ++i2) {
            p2 = x22;
            for (int j3 = 1; j3 < i2; ++j3) {
                p2 *= x22;
            }
            int yTemp = 2;
            for (int j4 = i2; j4 > 2; --j4) {
                yTemp *= j4;
            }
            sumY += p2 / (double)yTemp;
        }
        return sumY;
    }
}

