/*
 * Decompiled with CFR 0.152.
 */
package JorisS.SatView;

import JorisS.SatView.MathFunc;
import wt.api.WtCommon;

public class Moon {
    public int Azimuth = 0;
    public int Altitude = 0;
    public int AGE = 0;

    public void Calculate(WtCommon c2) throws Exception {
        this.Azimuth = -1;
        this.Altitude = -1;
        this.AGE = -1;
        double year = Double.parseDouble(c2.getAttributeValue("{curdate.yy}"));
        double month = Double.parseDouble(c2.getAttributeValue("{curdate.mm}"));
        double day = Double.parseDouble(c2.getAttributeValue("{curdate.dd}"));
        double hour = Double.parseDouble(c2.getAttributeValue("{curtime.hd}"));
        double minute = Double.parseDouble(c2.getAttributeValue("{curtime.m}"));
        double lon = Double.parseDouble(c2.getAttributeValue("{pos.lons}"));
        double lat = Double.parseDouble(c2.getAttributeValue("{pos.lats}"));
        double YY = year - Math.floor((12.0 - month) / 10.0);
        double MM = month + 9.0;
        if (MM >= 12.0) {
            MM -= 12.0;
        }
        double K1 = Math.floor(365.25 * (YY + 4712.0));
        double K2 = Math.floor(30.6 * MM + 0.5);
        double K3 = Math.floor(Math.floor(YY / 100.0 + 49.0) * 0.75) - 38.0;
        double JD = K1 + K2 + day + 59.0;
        if (JD > 2299160.0) {
            JD -= K3;
        }
        double IP = this.normalize((JD - 2451550.1) / 29.530588853);
        double AG = IP * 29.53;
        this.AGE = this.GetPhase(AG);
        double d2 = this.daynumber(day, month, year, hour, minute);
        double[] output_moon_angles = this.moon_angles(d2, lon, lat);
        this.Azimuth = (int)output_moon_angles[1];
        this.Altitude = (int)output_moon_angles[10];
    }

    public double[] moon_angles(double d2, double SiteLon, double SiteLat) {
        double pi = Math.PI;
        double oblecl = 0.0;
        double N = 125.1228 - 0.0529538083 * d2;
        double i2 = 5.1454;
        double w2 = 318.0634 + 0.1643573223 * d2;
        double a2 = 60.2666;
        double e2 = 0.0549;
        double M = 115.3654 + 13.0649929509 * d2;
        w2 = this.Rev(w2);
        M = this.Rev(M);
        N = this.Rev(N);
        double E = M + 180.0 / pi * e2 * Math.sin(this.Radians(M)) * (1.0 + e2 * Math.cos(this.Radians(M)));
        double Ebeforeit = E = this.Rev(E);
        double E_error = 9.0;
        for (double Iterations = 0.0; E_error > 5.0E-4 && Iterations < 20.0; Iterations += 1.0) {
            double E_ErrorBefore;
            double E0 = E;
            double E1 = E0 - (E0 - 180.0 / pi * e2 * Math.sin(this.Radians(E0)) - M) / (1.0 - e2 * Math.cos(this.Radians(E0)));
            double Eafterit = E = this.Rev(E1);
            E_error = E < E0 ? E0 - E : E - E0;
            if (E < Ebeforeit) {
                E_ErrorBefore = Ebeforeit - E;
                continue;
            }
            E_ErrorBefore = E - Ebeforeit;
        }
        double x2 = a2 * (Math.cos(this.Radians(E)) - e2);
        double y2 = a2 * Math.sin(this.Radians(this.Rev(E))) * Math.sqrt(1.0 - e2 * e2);
        double r2 = Math.sqrt(x2 * x2 + y2 * y2);
        double v2 = this.Deg(MathFunc.atan2(y2, x2));
        double sunlon = this.Rev(v2 + w2);
        x2 = r2 * Math.cos(this.Radians(sunlon));
        y2 = r2 * Math.sin(this.Radians(sunlon));
        double z2 = 0.0;
        double xeclip = r2 * (Math.cos(this.Radians(N)) * Math.cos(this.Radians(v2 + w2)) - Math.sin(this.Radians(N)) * Math.sin(this.Radians(v2 + w2)) * Math.cos(this.Radians(i2)));
        double yeclip = r2 * (Math.sin(this.Radians(N)) * Math.cos(this.Radians(v2 + w2)) + Math.cos(this.Radians(N)) * Math.sin(this.Radians(v2 + w2)) * Math.cos(this.Radians(i2)));
        double zeclip = r2 * Math.sin(this.Radians(v2 + w2)) * Math.sin(this.Radians(i2));
        double moon_longitude = this.Rev(this.Deg(MathFunc.atan2(yeclip, xeclip)));
        double moon_latitude = this.Deg(MathFunc.atan2(zeclip, Math.sqrt(xeclip * xeclip + yeclip * yeclip)));
        double[] sunangles = this.sun_angles(d2, SiteLon, SiteLat);
        double Ls = sunangles[11];
        double Ms = sunangles[6];
        double Mm = this.Rev(M);
        double Lm = this.Rev(N + w2 + M);
        double D = this.Rev(Lm - Ls);
        double F = this.Rev(Lm - N);
        double P_lon1 = -1.274 * Math.sin(this.Radians(Mm - 2.0 * D));
        double P_lon2 = 0.658 * Math.sin(this.Radians(2.0 * D));
        double P_lon3 = -0.186 * Math.sin(this.Radians(Ms));
        double P_lon4 = -0.059 * Math.sin(this.Radians(2.0 * Mm - 2.0 * D));
        double P_lon5 = -0.057 * Math.sin(this.Radians(Mm - 2.0 * D + Ms));
        double P_lon6 = 0.053 * Math.sin(this.Radians(Mm + 2.0 * D));
        double P_lon7 = 0.046 * Math.sin(this.Radians(2.0 * D - Ms));
        double P_lon8 = 0.041 * Math.sin(this.Radians(Mm - Ms));
        double P_lon9 = -0.035 * Math.sin(this.Radians(D));
        double P_lon10 = -0.031 * Math.sin(this.Radians(Mm + Ms));
        double P_lon11 = -0.015 * Math.sin(this.Radians(2.0 * F - 2.0 * D));
        double P_lon12 = 0.011 * Math.sin(this.Radians(Mm - 4.0 * D));
        double P_lat1 = -0.173 * Math.sin(this.Radians(F - 2.0 * D));
        double P_lat2 = -0.055 * Math.sin(this.Radians(Mm - F - 2.0 * D));
        double P_lat3 = -0.046 * Math.sin(this.Radians(Mm + F - 2.0 * D));
        double P_lat4 = 0.033 * Math.sin(this.Radians(F + 2.0 * D));
        double P_lat5 = 0.017 * Math.sin(this.Radians(2.0 * Mm + F));
        double P_lon = P_lon1 + P_lon2 + P_lon3 + P_lon4 + P_lon5 + P_lon6 + P_lon7 + P_lon8 + P_lon9 + P_lon10 + P_lon11 + P_lon12;
        double P_lat = P_lat1 + P_lat2 + P_lat3 + P_lat4 + P_lat5;
        double P_moondistance = -0.58 * Math.cos(this.Radians(Mm - 2.0 * D)) - 0.46 * Math.cos(this.Radians(2.0 * D));
        double xh = (r2 += P_moondistance) * Math.cos(this.Radians(moon_longitude += P_lon)) * Math.cos(this.Radians(moon_latitude += P_lat));
        double yh = r2 * Math.sin(this.Radians(moon_longitude)) * Math.cos(this.Radians(moon_latitude));
        double zh = r2 * Math.sin(this.Radians(moon_latitude));
        double xequat = xh;
        double yequat = yh * Math.cos(this.Radians(sunangles[9])) - zh * Math.sin(this.Radians(sunangles[9]));
        double zequat = yh * Math.sin(this.Radians(sunangles[9])) + zh * Math.cos(this.Radians(sunangles[9]));
        double Moon_RA = this.Rev(this.Deg(MathFunc.atan2(yh, xh)));
        double Moon_Decl = this.Deg(MathFunc.atan2(zh, Math.sqrt(xh * xh + yh * yh)));
        Moon_RA = this.Rev(this.Deg(MathFunc.atan2(yequat, xequat)));
        Moon_Decl = this.Deg(MathFunc.atan2(zequat, Math.sqrt(xequat * xequat + yequat * yequat)));
        double GMST0 = Ls + 180.0;
        double UT = d2 - Math.floor(d2);
        double SIDEREALTIME = GMST0 + UT * 360.0 + SiteLon;
        double HourAngle = SIDEREALTIME - Moon_RA;
        x2 = Math.cos(HourAngle * pi / 180.0) * Math.cos(Moon_Decl * pi / 180.0);
        y2 = Math.sin(HourAngle * pi / 180.0) * Math.cos(Moon_Decl * pi / 180.0);
        z2 = Math.sin(Moon_Decl * pi / 180.0);
        double xhor = x2 * Math.sin(SiteLat * pi / 180.0) - z2 * Math.cos(SiteLat * pi / 180.0);
        double yhor = y2;
        double zhor = x2 * Math.cos(SiteLat * pi / 180.0) + z2 * Math.sin(SiteLat * pi / 180.0);
        double MoonElevation = this.Deg(MathFunc.asin(zhor));
        MoonElevation -= this.Deg(MathFunc.asin(1.0 / r2 * Math.cos(this.Radians(MoonElevation))));
        double GeometricElevation = MoonElevation;
        MoonElevation = this.ElevationRefraction(MoonElevation);
        double MoonAzimuth = this.Deg(MathFunc.atan2(yhor, xhor));
        double[] angles = new double[]{MoonElevation, SiteLat < 0.0 ? MoonAzimuth + 180.0 : MoonAzimuth + 180.0, Moon_Decl, moon_longitude, Moon_RA, this.Rev(GMST0), this.Rev(M), this.Rev(w2), this.Rev(e2), this.Rev(oblecl), GeometricElevation, moon_latitude, MoonElevation, r2};
        return angles;
    }

    public double[] sun_angles(double d2, double SiteLon, double SiteLat) {
        double SunElevation;
        double pi = Math.PI;
        double w2 = 282.9404 + 4.70935E-5 * d2;
        double a2 = 1.0;
        double e2 = 0.016709 - 1.151E-9 * d2;
        double M = 356.047 + 0.9856002585 * d2;
        double oblecl = 23.4393 - 3.563E-7 * d2;
        double L = w2 + this.Rev(M);
        L = this.Rev(L);
        double E = M + 180.0 / pi * e2 * Math.sin(this.Radians(M)) * (1.0 + e2 * Math.cos(this.Radians(M)));
        E = this.Rev(E);
        double x2 = a2 * Math.cos(this.Radians(E)) - e2;
        double y2 = a2 * Math.sin(this.Radians(this.Rev(E))) * Math.sqrt(1.0 - e2 * e2);
        double r2 = Math.sqrt(x2 * x2 + y2 * y2);
        double v2 = this.Deg(MathFunc.atan2(y2, x2));
        double sunlon = this.Rev(v2 + w2);
        x2 = r2 * Math.cos(this.Radians(sunlon));
        y2 = r2 * Math.sin(this.Radians(sunlon));
        double z2 = 0.0;
        double xequat = x2;
        double yequat = y2 * Math.cos(this.Radians(oblecl)) + z2 * Math.sin(this.Radians(oblecl));
        double zequat = y2 * Math.sin(this.Radians(oblecl)) + z2 * Math.cos(this.Radians(oblecl));
        double RA = this.Rev(this.Deg(MathFunc.atan2(yequat, xequat)));
        double Decl = this.Deg(MathFunc.atan2(zequat, Math.sqrt(xequat * xequat + yequat * yequat)));
        double GMST0 = L + 180.0;
        double UT = d2 - Math.floor(d2);
        double SIDEREALTIME = GMST0 + UT * 360.0 + SiteLon;
        double HourAngle = SIDEREALTIME - RA;
        x2 = Math.cos(HourAngle * pi / 180.0) * Math.cos(Decl * pi / 180.0);
        y2 = Math.sin(HourAngle * pi / 180.0) * Math.cos(Decl * pi / 180.0);
        z2 = Math.sin(Decl * pi / 180.0);
        double xhor = x2 * Math.sin(SiteLat * pi / 180.0) - z2 * Math.cos(SiteLat * pi / 180.0);
        double yhor = y2;
        double zhor = x2 * Math.cos(SiteLat * pi / 180.0) + z2 * Math.sin(SiteLat * pi / 180.0);
        double GeometricElevation = SunElevation = this.Deg(MathFunc.asin(zhor));
        SunElevation = this.ElevationRefraction(SunElevation);
        double SunAzimuth = this.Deg(MathFunc.atan2(yhor, xhor));
        double[] angles = new double[]{SunElevation, SiteLat < 0.0 ? SunAzimuth + 180.0 : SunAzimuth + 180.0, Decl, sunlon, RA, this.Rev(GMST0), this.Rev(M), this.Rev(w2), this.Rev(e2), this.Rev(oblecl), GeometricElevation, L};
        return angles;
    }

    public double ElevationRefraction(double El_geometric) {
        double a0 = 0.58804392;
        double a1 = -0.17941557;
        double a2 = 0.029906946;
        double a3 = -0.00251874;
        double a4 = 8.2622101E-5;
        double El_observed = El_geometric;
        double x2 = Math.abs(El_geometric + 0.589);
        double refraction = Math.abs(a0 + a1 * x2 + a2 * x2 * x2 + a3 * x2 * x2 * x2 + a4 * x2 * x2 * x2 * x2);
        El_observed = El_geometric > 10.2 ? El_geometric + 0.01617 * (Math.cos(this.Radians(Math.abs(El_geometric))) / Math.sin(this.Radians(Math.abs(El_geometric)))) : El_geometric + refraction;
        return El_observed;
    }

    public double Rev(double number) {
        double x2 = number - Math.floor(number / 360.0) * 360.0;
        return x2;
    }

    public double daynumber(double Day, double Month, double Year, double Hour, double Minute) {
        double d2 = 367.0 * Year - this.Div(7.0 * (Year + this.Div(Month + 9.0, 12.0)), 4.0) + this.Div(275.0 * Month, 9.0) + Day - 730530.0;
        d2 = d2 + Hour / 24.0 + Minute / 1440.0;
        return d2;
    }

    public double Div(double a2, double b2) {
        return (a2 - a2 % b2) / b2;
    }

    public String formatvalue(double input, int rsize) {
        float fltin;
        String strin;
        block5: {
            String invalid;
            block4: {
                invalid = "**************************";
                String nines = "999999999999999999999999";
                strin = "" + input;
                fltin = Float.parseFloat(strin);
                if (strin.length() <= rsize) {
                    return strin;
                }
                if (strin.indexOf("e") != -1) break block4;
                StringBuffer stringBuffer = new StringBuffer();
                if (!(fltin > Float.parseFloat(stringBuffer.append(nines.substring(0, rsize)).append(".4").toString()))) break block5;
            }
            return invalid.substring(0, rsize);
        }
        String rounded = "" + (fltin + (fltin - Float.parseFloat(strin.substring(0, rsize))));
        return rounded.substring(0, rsize);
    }

    public double PrimerGiro(double x2) {
        x2 -= 360.0 * Math.floor(x2 / 360.0);
        return x2;
    }

    double normalize(double v2) {
        if ((v2 -= Math.floor(v2)) < 0.0) {
            v2 += 1.0;
        }
        return v2;
    }

    double JulianDay(int date, int month, int year, double UT) {
        if (month <= 2) {
            month += 12;
            --year;
        }
        return (double)((int)(365.25 * (double)year) + (int)(30.6001 * (double)(month + 1)) - 15) + 1720996.5 + (double)date + UT / 24.0;
    }

    double Radians(double grad) {
        return grad * Math.PI / 180.0;
    }

    double Deg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    int GetPhase(double AG) {
        if (AG < 1.84566) {
            return 0;
        }
        if (AG < 5.53699) {
            return 1;
        }
        if (AG < 9.22831) {
            return 2;
        }
        if (AG < 12.91963) {
            return 3;
        }
        if (AG < 16.61096) {
            return 4;
        }
        if (AG < 20.30228) {
            return 5;
        }
        if (AG < 23.99361) {
            return 6;
        }
        if (AG < 27.68493) {
            return 7;
        }
        return 0;
    }
}

