/*
 * Decompiled with CFR 0.152.
 */
package JorisS.SatView;

import JorisS.SatView.Gradient;
import JorisS.SatView.Moon;
import JorisS.SatView.SatView;
import JorisS.SatView.Star;
import JorisS.SatView.Sun;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import wt.api.WtCommon;

public class SatCanvas
extends Canvas
implements CommandListener {
    private static int SCREEN_NORMAL = 0;
    private static int SCREEN_FULLSKY = 1;
    private SatView sv;
    private Timer tm;
    WtCommon c;
    Sun sun;
    Moon moon;
    Star star;
    int CircleView = SCREEN_NORMAL;
    private static final Command cancel = new Command("Cancel", 3, 2);
    private static final Command Normview = new Command("Normal view", 3, 2);
    private static final Command Fullview = new Command("Full Sky", 3, 2);

    public SatCanvas(WtCommon c2) {
        this.c = c2;
        this.sun = new Sun();
        this.moon = new Moon();
        this.star = new Star();
    }

    public SatCanvas(SatView sv, WtCommon c2) {
        this.c = c2;
        this.sv = sv;
        this.addCommand(cancel);
        this.addCommand(Fullview);
        this.setCommandListener(this);
        this.sun = new Sun();
        this.moon = new Moon();
        this.star = new Star();
        this.tm = new Timer();
        this.tm.schedule(new TimerTask(){

            public void run() {
                SatCanvas.this.repaint();
            }
        }, 0L, 1000L);
    }

    private Image GetImage(String img) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:" + this.c.getAttributeValue("{rootdir}") + "Plugins/JorisPlugins/SatView/Images/" + img));
            Image i2 = Image.createImage((InputStream)fc.openInputStream());
            fc.close();
            return i2;
        }
        catch (Exception e2) {
            this.c.log(e2.getMessage());
            return Image.createImage((int)1, (int)1);
        }
    }

    protected void paint(Graphics g2) {
        g2.setClip(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(0xFFFFFF);
        g2.setStrokeStyle(0);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.setFullScreenMode(this.c.getAttributeValue("{fullscreen.text}").equals("true"));
        g2.setClip(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(54, 96, 138);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        Font mFont = Font.getFont((int)64, (int)0, (int)8);
        g2.setFont(mFont);
        int sh = mFont.getHeight();
        int maxbarcount = 12;
        int offset = 15;
        int diam = Math.min(this.getWidth(), this.getHeight() - sh * maxbarcount / 3 - 3 * sh) - 2 * offset;
        gpgsv[] sats = new gpgsv[]{};
        if (this.CircleView == SCREEN_NORMAL) {
            this.Paint_New_Sky_Panel(g2, sats);
        } else if (this.CircleView == SCREEN_FULLSKY) {
            this.Paint_Sky_Panel(g2, sats);
        } else {
            g2.setColor(0, 0, 0);
            try {
                sats = this.ParseGPGSV();
            }
            catch (Exception e2) {
                this.c.log(e2.getMessage());
                e2.printStackTrace();
            }
            g2.drawLine(offset, offset, offset + diam, offset);
            g2.drawLine(offset + 30, 1, offset + 30, offset + diam + offset);
            g2.drawString("PRN", offset, 1, 20);
            g2.drawString("Strength", offset + 31, 1, 20);
            int sh1 = mFont.getHeight() + 4;
            for (int i2 = 0; i2 < sats.length; ++i2) {
                g2.setColor(0, 0, 0);
                g2.drawString("" + sats[i2].SVPRN, offset + 30 - 1, offset + (i2 + 1) * sh1, 24);
                Gradient.gradientBox(g2, 12669004, 44884, offset + 30 + 1, offset + (i2 + 1) * sh1, diam - 30 - 1, sh1 - 4, 1);
                g2.setColor(54, 96, 138);
                int maskw = diam - 30 - 1 - sats[i2].SNR * (diam - 30 - 1) / 50;
                g2.fillRect(offset + diam - maskw, offset + (i2 + 1) * sh1, maskw, sh - 4);
            }
        }
    }

    private void Paint_New_Sky_Panel(Graphics g2, gpgsv[] sats) {
        int DefColor = 11848402;
        g2.setColor(DefColor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        int UpperBoxLeftWidth = this.getWidth() / 3;
        int LowerBoxWidth = this.getWidth() / 2;
        int SatPanelWidth = this.getWidth() - UpperBoxLeftWidth;
        int BoxHeight = this.getHeight() / 6;
        int SatHeight = 4 * BoxHeight;
        int BoxOffset = 2;
        int BlueBoxColor1 = 10280932;
        int BlueBoxColor2 = 10663867;
        int GrayBoxColor1 = 12700106;
        int GrayBoxColor2 = 9345949;
        int Txt_TitleColor = 0x4B4B4B;
        int Txt_ItemColor = 0;
        Font bFont = Font.getFont((int)64, (int)1, (int)8);
        Font lFont = Font.getFont((int)0, (int)1, (int)0);
        try {
            sats = this.ParseGPGSV();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.c.log(e2.getMessage());
        }
        this.DrawBox(g2, 0, 0, UpperBoxLeftWidth, BoxHeight, BlueBoxColor1, BlueBoxColor2, Txt_TitleColor, Txt_ItemColor, bFont, lFont, "Gps Status", this.GetGpsStatus(sats));
        this.DrawBox(g2, 0, BoxHeight, UpperBoxLeftWidth, BoxHeight, BlueBoxColor1, BlueBoxColor2, Txt_TitleColor, Txt_ItemColor, bFont, lFont, "Num Sats", this.GetAttribute("{satcount}"));
        this.DrawBox(g2, 0, 2 * BoxHeight, UpperBoxLeftWidth, BoxHeight, GrayBoxColor1, GrayBoxColor2, Txt_TitleColor, Txt_ItemColor, bFont, lFont, "Speed", this.GetAttribute("{curspd.default}"));
        this.DrawBox(g2, 0, 3 * BoxHeight, UpperBoxLeftWidth, BoxHeight, GrayBoxColor1, GrayBoxColor2, Txt_TitleColor, Txt_ItemColor, bFont, lFont, "Time", this.GetAttribute("{curtime.h:m}"));
        this.DrawBox(g2, 0, 4 * BoxHeight, LowerBoxWidth, BoxHeight, BlueBoxColor1, BlueBoxColor2, Txt_TitleColor, Txt_ItemColor, bFont, lFont, "Latitude", this.GetAttribute("{pos.lons}", 3));
        this.DrawBox(g2, LowerBoxWidth, 4 * BoxHeight, LowerBoxWidth, BoxHeight, BlueBoxColor1, BlueBoxColor2, Txt_TitleColor, Txt_ItemColor, bFont, lFont, "Longitude", this.GetAttribute("{pos.lats}", 3));
        this.DrawBox(g2, 0, 5 * BoxHeight, LowerBoxWidth, BoxHeight, GrayBoxColor1, GrayBoxColor2, Txt_TitleColor, Txt_ItemColor, bFont, lFont, "Altitude", this.GetAttribute("{alt.m}", 1) + "m");
        this.DrawBox(g2, LowerBoxWidth, 5 * BoxHeight, LowerBoxWidth, BoxHeight, GrayBoxColor1, GrayBoxColor2, Txt_TitleColor, Txt_ItemColor, bFont, lFont, "hdop/vdop", this.GetAttribute("{hdop}", 1) + "/" + this.GetAttribute("{vdop}", 1));
        Font mFont = Font.getFont((int)64, (int)0, (int)8);
        int offset = 15;
        int sh = mFont.getHeight();
        int diam = Math.min(SatPanelWidth - 2 * offset, 3 * BoxHeight - 2 * offset);
        int cx = UpperBoxLeftWidth + SatPanelWidth / 2;
        int cy = offset + diam / 2;
        int satdiam = 16;
        this.DrawSky(g2, sats, mFont, offset, sh, diam, cx, cy, satdiam);
        int MaxSignal = 12;
        g2.setColor(0, 0, 0);
        g2.drawLine(UpperBoxLeftWidth + BoxOffset, 4 * BoxHeight - offset - BoxOffset, this.getWidth() - BoxOffset, 4 * BoxHeight - offset - BoxOffset);
        double barwidth = (SatPanelWidth - 2 * BoxOffset) / (3 * MaxSignal / 2);
        int barheight = BoxHeight - BoxOffset - offset;
        int coffset = (this.getWidth() - (int)((double)(UpperBoxLeftWidth + BoxOffset) + (double)MaxSignal * (3.0 * barwidth / 2.0))) / 2;
        for (int i2 = 0; i2 < MaxSignal; ++i2) {
            Gradient.gradientBox(g2, 12669004, 44884, (int)((double)(UpperBoxLeftWidth + BoxOffset + coffset) + (double)i2 * (3.0 * barwidth / 2.0)), 4 * BoxHeight - offset - BoxOffset - barheight, (int)barwidth, barheight, 0);
            int satstr = 0;
            if (i2 < sats.length) {
                satstr = sats[i2].SNR;
            }
            g2.setColor(GrayBoxColor2);
            g2.fillRect((int)((double)(UpperBoxLeftWidth + BoxOffset + coffset) + (double)i2 * (3.0 * barwidth / 2.0)), 4 * BoxHeight - offset - BoxOffset - barheight, (int)barwidth, barheight - barheight * satstr / 50);
            if (i2 >= sats.length) continue;
            g2.setColor(0);
            g2.setFont(mFont);
            g2.drawString(sats[i2].SVPRN + "", (int)((double)(UpperBoxLeftWidth + BoxOffset + coffset) + (double)i2 * (3.0 * barwidth / 2.0)) - mFont.stringWidth(sats[i2].SVPRN + "") / 2 + (int)(barwidth / 2.0), 4 * BoxHeight - offset - BoxOffset + 3, 20);
        }
    }

    public void Paint_Sky_Panel(Graphics g2, gpgsv[] sats) {
        int DefColor = 0;
        g2.setColor(DefColor);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        Font mFont = Font.getFont((int)64, (int)0, (int)8);
        int offset = 15;
        int sh = mFont.getHeight();
        int diam = Math.min(this.getWidth() - 2 * offset, this.getHeight() - 2 * offset);
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() / 2;
        int satdiam = 16;
        this.DrawSky(g2, sats, mFont, offset, sh, diam, cx, cy, satdiam);
        if (this.c.getAttributeValue("{gpsstatus}").equals("1")) {
            g2.setColor(0, 255, 0);
        } else {
            g2.setColor(255, 0, 0);
        }
        g2.fillArc(this.getWidth() - 15, 5, 10, 10, 0, 360);
    }

    private String GetAttribute(String type) {
        try {
            return this.c.getAttributeValue(type);
        }
        catch (Exception e2) {
            this.c.log("Exception attribute: " + type + " : " + e2.getMessage());
            e2.printStackTrace();
            return "";
        }
        catch (Throwable t2) {
            this.c.log("Throwable attribute: " + type + " : " + t2.getMessage());
            t2.printStackTrace();
            return "";
        }
    }

    private String GetAttribute(String type, int round) {
        try {
            String ret = this.GetAttribute(type);
            if (ret.length() == 0) {
                return ret;
            }
            double val = Double.parseDouble(ret);
            double t2 = 1.0;
            for (int i2 = 0; i2 < round; ++i2) {
                t2 *= 10.0;
            }
            val *= t2;
            val = (double)((int)val) / t2;
            return val + "";
        }
        catch (Exception e2) {
            this.c.log(e2.getMessage());
            e2.printStackTrace();
            return "";
        }
    }

    private String GetGpsStatus(gpgsv[] sats) {
        if (this.GetAttribute("{gpsstatus}").equals("1")) {
            int satlen = sats.length;
            if (satlen < 4) {
                return "Weak";
            }
            int cp30 = 0;
            int tot = 0;
            for (int i2 = 0; i2 < satlen; ++i2) {
                if (sats[i2].SNR > 30) {
                    ++cp30;
                }
                tot += sats[i2].SNR;
            }
            if (cp30 >= 4) {
                return "Good";
            }
            double avg = (double)tot / (double)satlen;
            if (avg > 8.0) {
                return "Good";
            }
            return "Weak";
        }
        if (this.GetAttribute("{gpsstatus}").equals("2")) {
            return "No Fix";
        }
        return "No Gps";
    }

    private void DrawBox(Graphics g2, int x2, int y2, int width, int height, int C1, int C2, int TC1, int TC2, Font F1, Font F2, String Title, String SubTitle) {
        int o2 = 1;
        g2.setColor(C1);
        g2.fillRoundRect(x2 + o2, y2 + o2, width - 2 * o2, height - 2 * o2, height / 3, height / 3);
        Gradient.gradientBox(g2, C1, C2, x2 + o2, y2 + o2 + (height - 2 * o2) / 4, width - 2 * o2, 3 * (height - 2 * o2) / 4, 0);
        g2.setFont(F1);
        g2.setColor(TC1);
        g2.drawString(Title, x2 + 5, y2 + 1, 20);
        g2.setFont(F2);
        g2.setColor(TC2);
        if (SubTitle != null && SubTitle.length() > 0 && !SubTitle.toLowerCase().equals("null")) {
            g2.drawString(SubTitle, x2 + width / 2 - F2.stringWidth(SubTitle) / 2, y2 + 4 * height / 6 - F2.getHeight() / 2, 20);
        }
    }

    public void DrawSky(Graphics g2, gpgsv[] sats, Font mFont, int offset, int sh, int diam, int cx, int cy, int satdiam) {
        int y2;
        int x2;
        int angle;
        int y3;
        int x3;
        int i2;
        g2.setFont(mFont);
        int diam2 = 2 * diam / 3;
        int diam3 = diam / 3;
        int sundiam = satdiam;
        int moondiam = satdiam;
        g2.setColor(180, 202, 226);
        g2.fillArc(cx - diam / 2, cy - diam / 2, diam, diam, 0, 360);
        g2.setStrokeStyle(0);
        g2.setColor(0, 0, 0);
        g2.drawArc(cx - diam / 2, cy - diam / 2, diam, diam, 0, 360);
        g2.setStrokeStyle(1);
        g2.drawArc(cx - diam2 / 2, cy - diam2 / 2, diam2, diam2, 0, 360);
        g2.drawArc(cx - diam3 / 2, cy - diam3 / 2, diam3, diam3, 0, 360);
        g2.drawLine(cx, cy - diam / 2, cx, cy + diam / 2);
        g2.drawLine(cx - diam / 2, cy, cx + diam / 2, cy);
        for (i2 = 0; i2 < 360; i2 += 30) {
            if (i2 % 90 == 0) continue;
            x3 = (int)(Math.cos(Math.PI * (double)i2 / 180.0) * (double)diam / 2.0) + cx;
            y3 = cy - (int)(Math.sin(Math.PI * (double)i2 / 180.0) * (double)diam / 2.0);
            g2.drawLine(cx, cy, x3, y3);
        }
        g2.drawString("N", cx, cy - diam / 2 - 2, 33);
        g2.drawString("E", cx + diam / 2 + 2, cy, 68);
        g2.drawString("S", cx, cy + diam / 2 + 2, 17);
        g2.drawString("W", cx - diam / 2 - 2, cy, 72);
        try {
            this.star.Calculate(this.c);
            for (i2 = 0; i2 < this.star.Altitude.length; ++i2) {
                if (this.star.Altitude[i2] < 0) continue;
                angle = 90 - this.star.Azimuth[i2];
                x2 = (int)(Math.cos(Math.PI * (double)angle / 180.0) * (double)((90 - this.star.Altitude[i2]) * (diam / 2) / 90)) + cx;
                y2 = cy - (int)(Math.sin(Math.PI * (double)angle / 180.0) * (double)((90 - this.star.Altitude[i2]) * (diam / 2) / 90));
                g2.setColor(254, 244, 0);
                g2.fillArc(x2 - 2, y2 - 2, 4, 4, 0, 360);
                for (int s2 = 0; s2 < this.star.Stars[i2].CONNECT.length; ++s2) {
                    int i22 = this.star.Stars[i2].CONNECT[s2];
                    int angle2 = 90 - this.star.Azimuth[i22];
                    int x22 = (int)(Math.cos(Math.PI * (double)angle2 / 180.0) * (double)((90 - this.star.Altitude[i22]) * (diam / 2) / 90)) + cx;
                    int y22 = cy - (int)(Math.sin(Math.PI * (double)angle2 / 180.0) * (double)((90 - this.star.Altitude[i22]) * (diam / 2) / 90));
                    g2.drawLine(x2, y2, x22, y22);
                }
            }
        }
        catch (Exception e2) {
            this.c.log(e2.getMessage());
            e2.printStackTrace();
        }
        try {
            sats = this.ParseGPGSV();
            for (int i3 = 0; i3 < sats.length; ++i3) {
                angle = 90 - sats[i3].Azimuth;
                x2 = (int)(Math.cos(Math.PI * (double)angle / 180.0) * (double)((90 - sats[i3].Elevation) * (diam / 2) / 90)) + cx - satdiam / 2;
                y2 = cy - (int)(Math.sin(Math.PI * (double)angle / 180.0) * (double)((90 - sats[i3].Elevation) * (diam / 2) / 90)) - satdiam / 2;
                this.SetsignalColor(g2, sats[i3].SNR);
                g2.fillArc(x2, y2, satdiam, satdiam, 0, 360);
                g2.setColor(0, 0, 0);
                int sw = mFont.stringWidth(sats[i3].SVPRN + "");
                g2.drawString(sats[i3].SVPRN + "", x2 + satdiam / 2 - sw / 2, y2 + satdiam / 2 - sh / 2, 20);
            }
        }
        catch (Exception e3) {
            this.c.log(e3.getMessage());
            e3.printStackTrace();
        }
        try {
            this.moon.Calculate(this.c);
            if (this.moon.Altitude >= 0) {
                int angle2 = 90 - this.moon.Azimuth;
                x3 = (int)(Math.cos(Math.PI * (double)angle2 / 180.0) * (double)((90 - this.moon.Altitude) * (diam / 2) / 90)) + cx - moondiam / 2;
                y3 = cy - (int)(Math.sin(Math.PI * (double)angle2 / 180.0) * (double)((90 - this.moon.Altitude) * (diam / 2) / 90)) - moondiam / 2;
                try {
                    g2.drawImage(this.GetImage("moon" + this.moon.AGE + ".png"), x3, y3, 20);
                }
                catch (Exception e4) {
                    this.c.log(e4.getMessage());
                    e4.printStackTrace();
                }
            }
        }
        catch (Exception e5) {
            this.c.log(e5.getMessage());
            e5.printStackTrace();
        }
        try {
            this.sun.Calculate(this.c);
            if (this.sun.Altitude >= 0) {
                int angle3 = 90 - this.sun.Azimuth;
                x3 = (int)(Math.cos(Math.PI * (double)angle3 / 180.0) * (double)((90 - this.sun.Altitude) * (diam / 2) / 90)) + cx - sundiam / 2;
                y3 = cy - (int)(Math.sin(Math.PI * (double)angle3 / 180.0) * (double)((90 - this.sun.Altitude) * (diam / 2) / 90)) - sundiam / 2;
                try {
                    g2.drawImage(this.GetImage("icon-sun.png"), x3, y3, 20);
                }
                catch (Exception e6) {
                    this.c.log(e6.getMessage());
                    e6.printStackTrace();
                }
            }
        }
        catch (Exception e7) {
            this.c.log(e7.getMessage());
            e7.printStackTrace();
        }
        g2.setStrokeStyle(0);
    }

    gpgsv[] ParseGPGSV() throws Exception {
        String gpgsvfull = this.c.getAttributeValue("{GPGSV.full}");
        if (gpgsvfull == null) {
            return new gpgsv[0];
        }
        gpgsvfull = gpgsvfull.replace('\n', '*');
        gpgsvfull = gpgsvfull.replace('\r', '*');
        int msgnmbr = Integer.parseInt(gpgsvfull.substring(gpgsvfull.indexOf(",") + 1, gpgsvfull.indexOf(",", gpgsvfull.indexOf(",") + 1)));
        boolean totalsat = false;
        Vector<gpgsv> sats = new Vector<gpgsv>();
        for (int n2 = 1; n2 <= msgnmbr; ++n2) {
            int start = gpgsvfull.indexOf("$GPGSV," + msgnmbr + "," + n2 + ",");
            String gpg = "";
            if (n2 == msgnmbr) {
                gpg = gpgsvfull.substring(start);
            } else {
                int end = gpgsvfull.indexOf("$GPGSV," + msgnmbr + "," + (n2 + 1) + ",");
                gpg = gpgsvfull.substring(start, end);
            }
            String[] gpgsv2 = this.split(gpg, ",");
            if (gpgsv2[0].indexOf("$GPGSV") <= -1) continue;
            for (int i2 = 1; i2 <= 4; ++i2) {
                if (gpgsv2.length - 1 < i2 * 4 + 3 || gpgsv2[i2 * 4].equals("") || gpgsv2[i2 * 4 + 1].equals("") || gpgsv2[i2 * 4 + 2].equals("") || gpgsv2[i2 * 4 + 3].equals("") || gpgsv2[i2 * 4 + 3].indexOf("*") == 0) continue;
                int satcode = Integer.parseInt(gpgsv2[i2 * 4]);
                int elevation = Integer.parseInt(gpgsv2[i2 * 4 + 1]);
                int Azimuth = Integer.parseInt(gpgsv2[i2 * 4 + 2]);
                int signal = 0;
                signal = gpgsv2[i2 * 4 + 3].indexOf("*") > -1 ? Integer.parseInt(gpgsv2[i2 * 4 + 3].substring(0, gpgsv2[i2 * 4 + 3].indexOf("*"))) : Integer.parseInt(gpgsv2[i2 * 4 + 3]);
                sats.addElement(new gpgsv(satcode, elevation, Azimuth, signal));
            }
        }
        gpgsv[] ret = new gpgsv[sats.size()];
        for (int i3 = 0; i3 < sats.size(); ++i3) {
            ret[i3] = (gpgsv)sats.elementAt(i3);
        }
        return ret;
    }

    private void SetsignalColor(Graphics g2, int signal) {
        if (signal == 0) {
            g2.setColor(146, 146, 146);
        } else if (signal < 10) {
            g2.setColor(244, 218, 217);
        } else if (signal < 20) {
            g2.setColor(255, 191, 141);
        } else if (signal < 35) {
            g2.setColor(255, 255, 57);
        } else {
            g2.setColor(47, 255, 44);
        }
    }

    public void commandAction(Command cmd, Displayable d2) {
        if (cmd == cancel) {
            this.c.screenReturn();
        } else if (cmd == Fullview) {
            this.CircleView = SCREEN_FULLSKY;
            this.removeCommand(Fullview);
            this.addCommand(Normview);
            this.repaint();
        } else if (cmd == Normview) {
            this.CircleView = SCREEN_NORMAL;
            this.removeCommand(Normview);
            this.addCommand(Fullview);
            this.repaint();
        }
    }

    private String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            for (int loop = 0; loop < nodes.size(); ++loop) {
                result[loop] = (String)nodes.elementAt(loop);
            }
        }
        return result;
    }

    class gpgsv {
        public int SVPRN;
        public int Elevation;
        public int Azimuth;
        public int SNR;

        public gpgsv(int SVPRN, int Elevation, int Azimuth, int SNR) {
            this.SVPRN = SVPRN;
            this.Elevation = Elevation;
            this.Azimuth = Azimuth;
            this.SNR = SNR;
        }
    }
}

