/*
 * Decompiled with CFR 0.152.
 */
package JorisS.SatView;

import JorisS.SatView.MathFunc;
import wt.api.WtCommon;

public class Star {
    public int[] Azimuth;
    public int[] Altitude;
    public star[] Stars;

    public Star() {
        this.GenerateStars();
    }

    public void Calculate(WtCommon c2) throws Exception {
        this.Azimuth = new int[this.Stars.length];
        this.Altitude = new int[this.Stars.length];
        double year = Double.parseDouble(c2.getAttributeValue("{curdate.yy}"));
        double month = Double.parseDouble(c2.getAttributeValue("{curdate.mm}"));
        double day = Double.parseDouble(c2.getAttributeValue("{curdate.dd}"));
        double hour = Double.parseDouble(c2.getAttributeValue("{curtime.hd}"));
        double minute = Double.parseDouble(c2.getAttributeValue("{curtime.m}"));
        double lon = Double.parseDouble(c2.getAttributeValue("{pos.lons}"));
        double lat = Double.parseDouble(c2.getAttributeValue("{pos.lats}"));
        for (int i2 = 0; i2 < this.Stars.length; ++i2) {
            double hourangle;
            double RA = this.Stars[i2].RA;
            double Dec = this.Stars[i2].DEC * Math.PI / 180.0;
            double time = this.Deg(hour, minute, 0.0);
            double latitude = lat * Math.PI / 180.0;
            double longitudedeg = lon;
            double LST = this.Greenwich(year, month, day, time) + longitudedeg / 15.0;
            if (LST < 0.0) {
                LST += 24.0;
            }
            if (LST >= 24.0) {
                LST -= 24.0;
            }
            if ((hourangle = LST - RA) < 0.0) {
                hourangle = 24.0 + hourangle;
            }
            hourangle = hourangle * Math.PI / 12.0;
            RA = RA * Math.PI / 12.0;
            double sinAlt = Math.cos(hourangle) * Math.cos(Dec) * Math.cos(latitude) + Math.sin(Dec) * Math.sin(latitude);
            double altitude = MathFunc.asin(sinAlt);
            double x2 = Math.abs(altitude * 180.0 / Math.PI);
            this.Altitude[i2] = (int)(altitude * 180.0 / Math.PI);
            double asx = Math.floor(x2);
            double minx = Math.floor(60.0 * (x2 - asx));
            double sekx = (x2 - asx - minx / 60.0) * 3600.0;
            if (altitude < 0.0) {
                asx = -asx;
            }
            double cosAz = (Math.sin(Dec) - Math.sin(latitude) * Math.sin(altitude)) / (Math.cos(latitude) * Math.cos(altitude));
            double azimuth = MathFunc.acos(cosAz);
            azimuth = azimuth * 180.0 / Math.PI;
            if (hourangle < Math.PI) {
                azimuth = 360.0 - azimuth;
            }
            this.Azimuth[i2] = (int)azimuth;
            asx = Math.floor(azimuth);
            minx = Math.floor(60.0 * (azimuth - asx));
            sekx = (azimuth - asx - minx / 60.0) * 3600.0;
        }
    }

    private double JulianDay(double yy, double mm, double dd) {
        double tulos = 367.0 * yy - Math.floor(7.0 * (yy + Math.floor((mm + 9.0) / 12.0)) / 4.0) - Math.floor(3.0 * (Math.floor((yy + (mm - 9.0) / 7.0) / 100.0) + 1.0) / 4.0) + Math.floor(275.0 * mm / 9.0) + dd + 1721028.5;
        return tulos;
    }

    private double Greenwich(double yy, double mm, double dd, double time) {
        double GMST;
        double GW = 0.0;
        double JD = this.JulianDay(yy, mm, dd);
        double T = (JD - 2451545.0) / 36525.0;
        double GWT0 = (24110.54841 + 8640184.812866 * T + 0.093104 * T * T - 6.2E-6 * T * T * T) / 3600.0;
        if (GWT0 >= 24.0) {
            GW = GWT0 - 24.0 * Math.floor(GWT0 / 24.0);
        }
        if (GWT0 <= -24.0) {
            GW = 24.0 - (Math.abs(GWT0) - 24.0 * Math.floor(Math.abs(GWT0) / 24.0));
        }
        if ((GMST = GW + 1.00273790935 * time) >= 24.0) {
            GMST -= 24.0;
        }
        if (GMST < 0.0) {
            GMST += 24.0;
        }
        return GMST;
    }

    private double Deg(double a2, double b2, double c2) {
        return a2 + b2 / 60.0 + c2 / 3600.0;
    }

    private void GenerateStars() {
        this.Stars = new star[20];
        this.Stars[0] = new star("13h 47m 32.55s \t+49\u00b0 18\u2032 47.9\u2033 \t", new int[]{1});
        this.Stars[1] = new star("12h 54m 01.63s \t+55\u00b0 57\u2032 35.4\u2033", new int[]{2});
        this.Stars[2] = new star("12h 15m 25.45s \t+57\u00b0 01\u2032 57.4\u2033", new int[]{3, 5});
        this.Stars[3] = new star("11h 03m 43.84s \t+61\u00b0 45\u2032 04.0\u2033", new int[]{4});
        this.Stars[4] = new star("11h 01m 50.39s \t+56\u00b0 22\u2032 56.4\u2033", new int[]{5});
        this.Stars[5] = new star("11h 53m 49.74s \t+53\u00b0 41\u2032 41.0\u2033 \t", new int[0]);
        this.Stars[6] = new star("02h 31m 47.08s \t+89\u00b0 15\u2032 50.9\u2033", new int[]{7});
        this.Stars[7] = new star("17h 32m 12.90s \t+86\u00b0 35\u2032 10.8\u2033", new int[]{8});
        this.Stars[8] = new star("16h 45m 58.16s \t+82\u00b0 02\u2032 14.1\u2033", new int[]{9});
        this.Stars[9] = new star("15h 44m 03.46s \t+77\u00b0 47\u2032 40.2\u2033", new int[]{10, 12});
        this.Stars[10] = new star("14h 50m 42.40s \t+74\u00b0 09\u2032 19.7\u2033", new int[]{11});
        this.Stars[11] = new star("15h 20m 43.75s \t+71\u00b0 50\u2032 02.3\u2033", new int[]{12});
        this.Stars[12] = new star("16h 17m 30.50s \t+75\u00b0 45\u2032 16.9\u2033", new int[0]);
        this.Stars[13] = new star("05h 55m 10.29s \t+07\u00b0 24\u2032 25.3\u2033", new int[]{19});
        this.Stars[14] = new star("05h 14m 32.27s \t\u221208\u00b0 12\u2032 05.9\u2033", new int[]{17});
        this.Stars[15] = new star("05h 25m 07.87s \t+06\u00b0 20\u2032 59.0\u2033", new int[]{17});
        this.Stars[16] = new star("05h 47m 45.39s \t\u221209\u00b0 40\u2032 10.6\u2033 \t", new int[]{19});
        this.Stars[17] = new star("05h 32m 00.40s \t\u221200\u00b0 17\u2032 56.7\u2033", new int[]{18});
        this.Stars[18] = new star("05h 36m 12.81s \t\u221201\u00b0 12\u2032 06.9\u2033", new int[0]);
        this.Stars[19] = new star("05h 40m 45.52s \t\u221201\u00b0 56\u2032 33.3\u2033", new int[]{18});
    }

    class star {
        double RA;
        double DEC;
        int[] CONNECT;

        public star(int RA_H, int RA_M, double RA_S, int DEC_G, int DEC_M, double DEC_S) {
            this.Parse(RA_H, RA_M, RA_S, DEC_G, DEC_M, DEC_S);
        }

        public star(String str, int[] con) {
            this.CONNECT = con;
            int H = Integer.parseInt(str.substring(0, str.indexOf("h")));
            int M = Integer.parseInt(str.substring(str.indexOf("h") + 2, str.indexOf("m")));
            double S = Double.parseDouble(str.substring(str.indexOf("m") + 2, str.indexOf("s")));
            boolean p2 = str.indexOf("+") > -1;
            int G = 0;
            G = p2 ? Integer.parseInt(str.substring(str.indexOf("+") + 1, str.indexOf("\u00b0"))) : -1 * Integer.parseInt(str.substring(str.indexOf("\u2212") + 1, str.indexOf("\u00b0")));
            int D = Integer.parseInt(str.substring(str.indexOf("\u00b0") + 2, str.indexOf("\u2032")));
            double SE = Double.parseDouble(str.substring(str.indexOf("\u2032") + 2, str.indexOf("\u2033")));
            this.Parse(H, M, S, G, D, SE);
        }

        public void Parse(int RA_H, int RA_M, double RA_S, int DEC_G, int DEC_M, double DEC_S) {
            this.RA = (double)RA_H + (double)RA_M / 60.0 + RA_S / 3600.0;
            this.DEC = (double)DEC_G + (double)DEC_M / 60.0 + DEC_S / 3600.0;
        }
    }
}

