/*
 * Decompiled with CFR 0.152.
 */
package JorisS.SatView;

import JorisS.SatView.MathFunc;
import wt.api.WtCommon;

public class Sun {
    public int Azimuth = 0;
    public int Altitude = 0;
    private final double pi = Math.PI;
    private final double tpi = Math.PI * 2;
    private final double degs;
    private final double rads = Math.PI / 180;
    private double L;
    private double RA;
    private double daylen;
    private double delta;
    private double x;
    private double y;
    private double z;
    private final double AirRefr;

    public Sun() {
        this.degs = 57.29577951308232;
        this.AirRefr = 0.5666666666666667;
    }

    public void Calculate(WtCommon c2) throws Exception {
        int m2 = (int)Double.parseDouble(c2.getAttributeValue("{curdate.mm}"));
        int day = (int)Double.parseDouble(c2.getAttributeValue("{curdate.dd}"));
        int year = (int)Double.parseDouble(c2.getAttributeValue("{curdate.yy}"));
        double h2 = Double.parseDouble(c2.getAttributeValue("{curtime.hd}")) + Double.parseDouble(c2.getAttributeValue("{curtime.m}")) / 60.0;
        double latit = Double.parseDouble(c2.getAttributeValue("{pos.lats}"));
        double longit = Double.parseDouble(c2.getAttributeValue("{pos.lons}"));
        double tzone = 0.0;
        double UT = h2 - tzone;
        double jd = this.FNday(year, m2, day, UT);
        double lambda = this.FNsun(jd);
        double obliq = 0.4090929593627069 - 6.218608124855796E-9 * jd;
        double GMST0 = this.L * 57.29577951308232 / 15.0 + 12.0;
        double SIDTIME = GMST0 + UT + longit / 15.0;
        double ha = 15.0 * SIDTIME - this.RA;
        ha = this.FNrange(Math.PI / 180 * ha);
        this.x = Math.cos(ha) * Math.cos(this.delta);
        this.y = Math.sin(ha) * Math.cos(this.delta);
        this.z = Math.sin(this.delta);
        double xhor = this.x * Math.sin(latit * (Math.PI / 180)) - this.z * Math.cos(latit * (Math.PI / 180));
        double yhor = this.y;
        double zhor = this.x * Math.cos(latit * (Math.PI / 180)) + this.z * Math.sin(latit * (Math.PI / 180));
        double azim = MathFunc.atan2(yhor, xhor) + Math.PI;
        azim = this.FNrange(azim);
        double altit = MathFunc.asin(zhor) * 57.29577951308232;
        if (altit < 30.0) {
            altit += 0.5666666666666667;
        }
        this.Azimuth = (int)(azim * 57.29577951308232);
        this.Altitude = (int)altit;
    }

    private double FNday(int y2, int m2, int d2, double h2) {
        long luku = -7 * (y2 + (m2 + 9) / 12) / 4 + 275 * m2 / 9 + d2;
        return (double)(luku += (long)y2 * 367L) - 730530.0 + h2 / 24.0;
    }

    private double FNrange(double x2) {
        double b2 = x2 / (Math.PI * 2);
        double a2 = Math.PI * 2 * (b2 - (double)((long)b2));
        if (a2 < 0.0) {
            a2 = Math.PI * 2 + a2;
        }
        return a2;
    }

    private double FNsun(double d2) {
        double w2 = 282.9404 + 4.70935E-5 * d2;
        double M = 356.047 + 0.9856002585 * d2;
        this.L = this.FNrange(w2 * (Math.PI / 180) + M * (Math.PI / 180));
        double g2 = this.FNrange(M * (Math.PI / 180));
        double ecc = 0.016709 - 1.151E-9 * d2;
        double obliq = 0.4090929593627069 - 6.218608124855796E-9 * d2;
        double E = M + 57.29577951308232 * ecc * Math.sin(g2) * (1.0 + ecc * Math.cos(g2));
        E = 57.29577951308232 * this.FNrange(E * (Math.PI / 180));
        this.x = Math.cos(E * (Math.PI / 180)) - ecc;
        this.y = Math.sin(E * (Math.PI / 180)) * Math.sqrt(1.0 - ecc * ecc);
        double r2 = Math.sqrt(this.x * this.x + this.y * this.y);
        double v2 = MathFunc.atan2(this.y, this.x) * 57.29577951308232;
        double lonsun = v2 + w2;
        if (lonsun > 360.0) {
            lonsun -= 360.0;
        }
        this.x = r2 * Math.cos(lonsun * (Math.PI / 180));
        this.y = r2 * Math.sin(lonsun * (Math.PI / 180));
        double yequat = this.y * Math.cos(obliq);
        double zequat = this.y * Math.sin(obliq);
        this.RA = MathFunc.atan2(yequat, this.x);
        this.delta = MathFunc.atan2(zequat, Math.sqrt(this.x * this.x + yequat * yequat));
        this.RA *= 57.29577951308232;
        return this.FNrange(this.L + 0.03342305517569141 * Math.sin(g2) + 3.4906585039886593E-4 * Math.sin(2.0 * g2));
    }
}

