/*
 * Decompiled with CFR 0.152.
 */
package JorisS.waypointsmser;

import JorisS.waypointsmser.ContactList_;
import JorisS.waypointsmser.LoadCanvas.LoadCanvas;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;
import wt.api.WtCommon;

public class SmsApi
implements MessageListener,
Runnable {
    private MessageConnection serverConn;
    private String smsport;
    private SmsApiListener listener;
    LoadCanvas loader;
    Vector listeners = new Vector();

    public SmsApi(SmsApiListener list, String port, WtCommon c2) {
        this.listener = list;
        this.smsport = port;
        this.loader = new LoadCanvas(c2, 0);
        this.SetPushRegistery();
    }

    public void run() {
        this.StartListen();
    }

    private void SetPushRegistery() {
        try {
            String[] conns = PushRegistry.listConnections((boolean)false);
            boolean check = false;
            for (int i2 = 0; i2 < conns.length; ++i2) {
                if (!conns[i2].equals("sms://:" + this.smsport)) continue;
                check = true;
            }
            if (check) {
                return;
            }
            PushRegistry.registerConnection((String)("sms://:" + this.smsport), (String)"wt.WeTravelMain", (String)"*");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void StartListen() {
        try {
            if (!this.CheckPush()) {
                this.ConnectListen();
            }
        }
        catch (IOException ioExc) {
            System.out.println("Server connection could not be obtained");
            ioExc.printStackTrace();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void ConnectListen() throws IOException {
        System.out.println("connectlisten");
        this.serverConn = (MessageConnection)Connector.open((String)("sms://:" + this.smsport));
        this.serverConn.setMessageListener((MessageListener)this);
    }

    private void CloseListen() throws IOException {
        if (this.serverConn != null) {
            System.out.println("closelisten");
            this.serverConn.setMessageListener(null);
            this.serverConn.close();
        }
    }

    private boolean CheckPush() throws Exception {
        String[] connections = PushRegistry.listConnections((boolean)true);
        boolean hascon = false;
        if (connections.length != 0) {
            for (int i2 = connections.length - 1; i2 >= 0; --i2) {
                try {
                    MessageConnection mc = (MessageConnection)Connector.open((String)connections[i2]);
                    mc.setMessageListener((MessageListener)this);
                    this.listeners.addElement(mc);
                    hascon = true;
                    continue;
                }
                catch (SecurityException exp) {
                    exp.printStackTrace();
                    continue;
                }
                catch (IOException exp) {
                    exp.printStackTrace();
                }
            }
        }
        return hascon;
    }

    public void notifyIncomingMessage(MessageConnection arg0) {
        System.out.print("Receive...");
        String msgReceived = "";
        String phonenumber = "";
        try {
            Message msg = this.serverConn.receive();
            if (msg != null) {
                String senderAddress = msg.getAddress();
                System.out.println("From: " + senderAddress);
                phonenumber = ContactList_.CheckContact(senderAddress.substring(6));
                if (msg instanceof TextMessage) {
                    msgReceived = ((TextMessage)msg).getPayloadText();
                } else {
                    StringBuffer buf = new StringBuffer();
                    byte[] data = ((BinaryMessage)msg).getPayloadData();
                    for (int i2 = 0; i2 < data.length; ++i2) {
                        int intData = data[i2] & 0xFF;
                        if (intData < 16) {
                            buf.append("0");
                        }
                        buf.append(Integer.toHexString(intData));
                        buf.append(' ');
                    }
                    msgReceived = buf.toString();
                }
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        System.out.println("receive: " + msgReceived);
        this.ParseReceive(phonenumber, msgReceived);
    }

    public void SendMessage(Display d2, String destination, String port, double lat, double lon, String message) {
        class Send
        implements Runnable {
            private final /* synthetic */ Display val$d;
            private final /* synthetic */ double val$lat;
            private final /* synthetic */ double val$lon;
            private final /* synthetic */ String val$message;
            private final /* synthetic */ String val$destination;
            private final /* synthetic */ String val$port;

            Send(Display display, double d2, double d3, String string, String string2, String string3) {
                this.val$d = display;
                this.val$lat = d2;
                this.val$lon = d3;
                this.val$message = string;
                this.val$destination = string2;
                this.val$port = string3;
            }

            public void run() {
                Displayable cd = this.val$d.getCurrent();
                this.val$d.setCurrent((Displayable)SmsApi.this.loader);
                SmsApi.this.loader.Text = "Send Message...";
                SmsApi.this.loader.StartrepaintLoop();
                try {
                    SmsApi.this.CloseListen();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                String msgToSend = SmsApi.this.SetMessage(this.val$lat, this.val$lon, this.val$message);
                System.out.println("Send " + msgToSend);
                String address = "sms://" + this.val$destination + ":" + this.val$port;
                MessageConnection smsconn = null;
                try {
                    smsconn = (MessageConnection)Connector.open((String)address);
                    TextMessage txtmessage = (TextMessage)smsconn.newMessage("text");
                    txtmessage.setAddress(address);
                    txtmessage.setPayloadText(msgToSend);
                    smsconn.send((Message)txtmessage);
                    SmsApi.this.loader.Text = "Message Send!";
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Throwable t2) {
                    System.out.println("Send caught: ");
                    t2.printStackTrace();
                    SmsApi.this.loader.Text = "Error:" + t2.getMessage();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (smsconn != null) {
                    try {
                        smsconn.close();
                    }
                    catch (IOException ioe) {
                        System.out.println("Closing connection caught: ");
                        ioe.printStackTrace();
                        SmsApi.this.loader.Text = "Error:" + ioe.getMessage();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                try {
                    SmsApi.this.ConnectListen();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                SmsApi.this.loader.StoprepaintLoop();
                this.val$d.setCurrent(cd);
            }
        }
        new Thread(new Send(d2, lat, lon, message, destination, port)).start();
    }

    private String SetMessage(double lat, double lon, String msg) {
        String msgToSend = "WeTravelPOS:" + lat + "|" + lon + "*";
        msgToSend = msgToSend + msg;
        return msgToSend;
    }

    private void ParseReceive(String phonenumber, String msgReceived) {
        if (!msgReceived.startsWith("WeTravelPOS:")) {
            return;
        }
        int start = msgReceived.indexOf(":") + 1;
        int end = msgReceived.indexOf("|", start);
        double receiveLat = Double.parseDouble(msgReceived.substring(start, end));
        start = end + 1;
        end = msgReceived.indexOf("*");
        double receiveLon = Double.parseDouble(msgReceived.substring(start, end));
        String msg = msgReceived.substring(end + 1);
        this.listener.ReceiveMessage(phonenumber, msg, receiveLat, receiveLon);
    }

    public static interface SmsApiListener {
        public void ReceiveMessage(String var1, String var2, double var3, double var5);
    }
}

