#include "snakeEngine.h"

void collisionDetection(node *head, segment pickup, int* haspickup, int* game)
{
    if (head -> sgt.x == pickup.x && head -> sgt.y == pickup.y)
    {
        node* tmp = head;
        while (tmp -> next != NULL)
            tmp = tmp -> next;

        head = insert(head, tmp -> sgt.x, tmp -> sgt.y);
        *haspickup = !(*haspickup);
    }

    if (head -> sgt.x > getmaxx()) head -> sgt.x = 0;
    if (head -> sgt.y > getmaxy()) head -> sgt.y = 0;
    if (head -> sgt.x < 0) head -> sgt.x = (getmaxx()) - (getmaxx() % head -> sgt.x);
    if (head -> sgt.y < 0) head -> sgt.y = (getmaxy()) - (getmaxy() % head -> sgt.y);

    node* tmp = head -> next;
    while (tmp -> next != NULL)
    {
        if (head -> sgt.x == tmp -> sgt.x && head -> sgt.y == tmp -> sgt.y)
        {
            *game = 0;
            break;
        }
        tmp = tmp -> next;
    }
}

segment getPickup(node* head)
{
    segment pickup;
    node* tmp = head;

    pickup.x = (int)(rand() % getmaxx());
    pickup.y = (int)(rand() % getmaxy());

    pickup.x = (pickup.x % 15) < (15 / 2) ?  (pickup.x / 15) * 15 : (pickup.x / 15) * 15 + 15;
    pickup.y = (pickup.y % 15) < (15 / 2) ?  (pickup.y / 15) * 15 : (pickup.y / 15) * 15 + 15;

    while (tmp -> next != NULL)
    {
        if ((pickup.x == tmp -> sgt.x && pickup.y == tmp -> sgt.y) || (pickup.x > getmaxx() - 15 || pickup.y > getmaxy() - 15))
        {
            pickup = getPickup(head);
            break;
        }
        tmp = tmp -> next;
    }

    return pickup;
}

int turnDetection(int key, int dir)
{
    switch (key) {
        case 13:    // Enter
            return -1;
        case 97:    // A
            return (dir == 2) ? 2 : 0;
        case 119:   // W
            return (dir == 3) ? 3 : 1;
        case 100:   // D
            return (dir == 0) ? 0 : 2;
        case 115:   // S
            return (dir == 1) ? 1 : 3;
        default:
            return -2;
    }
}

void moveSnake(node* head, int dir)
{
    const int dirMatrix[4] = {-15, -15, 15, 15};

    node* tmp = head;
    segment prev = tmp -> sgt;

    tmp -> sgt.x += (dir % 2) ? 0 : dirMatrix[dir];
    tmp -> sgt.y += (dir % 2) ? dirMatrix[dir] : 0;
    tmp = tmp -> next;

    while (1) {
        if (tmp == NULL) break;
        segment tp = tmp -> sgt;
        tmp -> sgt = prev;
        prev = tp;
        tmp = tmp -> next;
    }
}

void drawSnake(node* head)
{
    node* tmp = head;

    while (1) {
        if (tmp == NULL) break;
        drawSegment(tmp -> sgt.x, tmp -> sgt.y, YELLOW);
        tmp = tmp -> next;
    }
}

void drawSegment(int x, int y, int color)
{
    const int size = 13;

    setcolor(color);
    rectangle(x, y, x + size, y + size);
    floodfill(x + 1, y + 1, color);
    setcolor(WHITE);
}

node* insert(node* head, int x, int y)
{
    node* newItem = (node *)malloc(sizeof(node));
    node* tmp = head;

    newItem -> sgt.x = x;
    newItem -> sgt.y = y;
    newItem -> next = NULL;

    if (head == NULL)
        return newItem;

    while (tmp -> next != NULL)
        tmp = tmp -> next;
    tmp -> next = newItem;

    return head;
}
