#!/bin/bash

# Egyszerű alak listával
for a in 1 2 3 4 5 6 7 8 9 10
do
  echo -n "$a "
done  

echo

# ==========================================
# seq parancs használatával 

for a in $(seq 10)
do
  echo -n "$a "
done

echo

# ==========================================
# {} kiterjesztés
# Bash, verzió 3+.

for a in {1..10}
do
  echo -n "$a "
done  

echo

# ==========================================
# C-szerű szintaxis

LIMIT=10

for ((a=1; a <= LIMIT ; a++))  
do
  echo -n "$a "
done                           

echo

# =========================================
# Vessző operátor használata.

for ((a=1, b=1; a <= LIMIT ; a++, b++))
do
  echo -n "$a-$b "
done

echo
exit 0
