#!/bin/bash

#Bükki András - Linuxvilág - Átmeneti fájlok és jelek

vissza()
# A $1-ben megadott fájl sorait olvassa visszafelé
{
  hossz=`cat $1 | wc -l`
  while [ $hossz -ge 1 ]
  do  
     cat $1 | sed -n "$hossz p"
     hossz=`expr $hossz - 1`
   done
}

# Fájlokból érkezõ bemenet
if [ $# -ne 0 ]
    then
    for nev in $*
	do
	    if [ -f $nev ]
	    then
		vissza $nev
	    else
		echo "A(z) $nev nevû fájl nem étezik!" 1>&2
	    fi
	done
else  # A szabványos bemenet olvasása
    touch /tmp/tactmp$$
    trap 'rm /tmp/tactmp$$ ; exit 1' 1 2 3
    while read sor
    do
	echo $sor >> /tmp/tactmp$$
    done
    
    vissza /tmp/tactmp$$
    rm /tmp/tactmp$$
fi
exit 0
