# 2. binomilis valami
library(e1071)
x = bincombinations(2)
d = factor(as.integer(xor(x[,1], x[,2])))
data = data.frame(x, d)

library(nnet)
net = nnet(d ~ ., data=data, size=2)

y = predict(net, data[1:2], type="class")

t = table(
	y=predict(net, type="class"),
	d=data$d
)
print(t)
cat("accuracy: ", 100 * sum(diag(t)) / sum(t), "%\n", sep="" )