f <- function(x) sin(pi * x) / (pi * x)

x <- runif(100, -5, 5)
d <- f(x)
d <- d + rnorm(length(d), sd=0.05)

plot(f, -5, 5)
points(x, d, col="blue")

library(nnet)

net <- nnet(x, d, linout=TRUE, size=10, maxit=200) # size:rtegek_szma

x2 <- seq(-5, 5, length=200)
y2 <-predict(net, matrix(x2))

plot(f, -5, 5)
title(main=expression(f(x) == frac(sin(pi * x), pi * x)))
points(x, d, col="blue", pch=1)
points(x2, y2, col="red", pch=4)
legend("topright",
	c("Original function", "Training data", "Neural network"),
	col=c("black", "blue", "red"),
	lty=c("solid", "blank", "blank"),
	pch=c(-1, 1,4)
)
