f <- function(beta=1) function(x) 1 / (1 + exp(-beta * x))

p <- function(a, x) sum(x^((length(a)-1):0) * a)

y <- function(w, x, f) {
	if (missing(f))
		f <- function(z) 1 / (1 + exp(-z))
	else
		if (! is.function(f))
			stop("invalid argument")
	f(sum(w * x))
}

d <- function(x, y) {
	if (! is.vector(x) || ! is.vector(y) || ! is.numeric(x) || ! is.numeric(y))
		stop("both arguments must be numeric vectors")
	z <- sqrt((x - y) %*% (x - y))
	drop(z)
}

(function(n, k) factorial(n) / (factorial(k) * factorial(n - k)))
