mycurve <- function(expr, ...) {
	sexpr <- substitute(expr)
	do.call(curve, list(sexpr, ylab=expression(f(x)), ...))
	usr <- par("usr")
	text(
		(usr[1] + usr[2]) / 2,
		(usr[3] + usr[4]) / 2,
		labels=substitute(f(x) == y, list(y=to.frac(sexpr))),
		cex=1.2
	)
}

mycurve(1 / (1 / 2 + x^2), -2, 2)
