library(SparseM)

x <- runif(100, -1, 1)
m <- matrix(x, ncol=10, byrow=TRUE)
m[abs(m) < 0.5] <- 0
sm <- as.matrix.csr(m)
image(sm)
t(sm)
as.matrix(sm)
identical(m, as.matrix(sm))

library(e1071)
write.matrix.csr(sm, file="sparse.dat")

sm2 <- read.matrix.csr("sparse.dat")

identical(m, as.matrix(sm2))
isTRUE(all.equal(m, as.matrix(sm2), tol=1e-5))

file.remove("sparse.dat")
