new.stack <- function(capacity) {
	store <- list()
	list(
		push = function(e) {
			if (is.null(e))
				stop("invalid argument")
			if (length(store) == capacity)
				stop("stack is full")
			store[[length(store) + 1]] <<- e
		},
		pop = function() {
			if (length(store) == 0)
				stop("stack is empty")
			tmp <- store[[length(store)]]
			store[[length(store)]] <<- NULL
			tmp
		},
		is.empty = function() {
			length(store) == 0
		}
	)
}

stack <- new.stack(10)

stack$push(Nile)
stack$push(sample(c(-1, 1), size=100, replace=TRUE))
stack$push(VADeaths)
stack$push(diag(3))

while(! stack$is.empty()) {
	e <- stack$pop()
	print(e)
}
