x <- rgamma(500, 5, 0.5)
h <- hist(x, breaks=15, freq=FALSE, col="wheat")
rug(x)
curve(
	dgamma(x, 5, 0.5),
	col="red",
	lwd=2,
	add=TRUE
)
title(
	sub=substitute(
		paste("Gamma distribution with parameters ",
			alpha == a,
			" and ",
			beta == b
		),
		list(a=5, b=0.5)
	)
)
expr <- expression(
	g[list(alpha, beta)](x) == x^{alpha - 1} * frac(beta^alpha * e^{-beta * x}, Gamma(alpha))
)
arrows(
        0.75 * max(x), 0.05,
	max(x) / 2, dgamma(max(x) / 2, 5, 0.5),
	length=0.15,
	col="red",
	lwd=2
)
text(0.75 * max(x), 0.05, expr, pos=3)
