f <- function(x) x * sin(x + 1)

plot(f, 0, 10)
title(
	main=substitute(
		f(x) == z,
		list(z=body(f))
	)
)

a <- optimize(f, c(0, 10))
b <- optimize(f, c(0, 10), maximum=TRUE)

points(a$minimum, a$objective, col="blue", pch=16)
points(b$maximum, b$objective, col="red", pch=16)

legend(
	"bottomleft",
	c("Local minima", "Local maxima"),
	col=c("blue", "red"),
	pch=16
)
