f <- function(x) 0.4 * sin(2 * pi * x) + 0.5

plot(f, 0, 1)

x <- seq(0, 1, length=11)
d <- f(x)
d <- d + rnorm(length(d), sd=0.05)
data <- data.frame(x, d)

points(data, col="red")

library(PolynomF)
p <- poly.calc(x, d)	# Lagrange polinom meghatározása

m <- lm (d ~ 1 + x + I(x^2) + I(x^3), data=data)
m <- lm (d ~ poly(x, 3, raw=TRUE), data=data)	# Harmadfokú polinom illesztése
p2 <- polynom(coef(m))

plot(p, xlim=c(0, 1), ylab="y", col="green", lty="dotted")
points(data, col="red", pch=4, cex=1.5)
curve(f, col="black", add=TRUE)
curve(p2, col="blue", lty="dashed", add=TRUE)
title(main="Overfitting")

legend(
        "topright",
        c("Original function", "Training data", "Lagrange polynomial", "3rd order polynomial fit"),
	lty=c("solid", "blank", "dotted", "dashed"),
	pch=c(-1, 4, -1, -1),
        col=c("black", "red", "green", "blue")
)
