data.url <- "http://archive.ics.uci.edu/ml/machine-learning-databases/wine/wine.data"
data <- read.csv(data.url, header=FALSE)
pairs(data[7:10],
	main="Chemical Analysis of Wines",
	labels=c("Total phenols", "Flavanoids", "Nonflavanoid phenols", "Proanthocyanins"),
	bg=c("red", "green", "blue")[data[[1]]],
	pch=21,
	cex=1.5,
	font.main=4
)
title(sub=paste("Source:" , data.url))
