f <- function(beta) function(x) 1 / (1 + exp(-beta * x))

plot.new()
plot.window(c(-5, 5), c(0, 1), xaxs="i")
axis(1)
axis(2)
box()

title(main=expression(f(x)==frac(1, 1 + exp(-beta * x))))

beta <- 2^(-2:2)

legend <- list()
pal <- rainbow(length(beta))

for (i in 1:length(beta)) {
	plot(f(beta[i]), -5, 5, col=pal[i], add=TRUE)
	legend <- append(
		legend,
		substitute(
			beta == value,
			list(value=beta[i])
		)
	)
}

legend("bottomright", legend=as.expression(legend), fill=pal)
