g <- function(x) sin(x^2) - 2 * cos(x)
plot(g, -1, 3, xaxs="i")
title(
	main=substitute(
		g(x) == z,
		list(z=body(g))
	)
)
r <- uniroot(g, c(-1, 3))
print(r)
points(r$root, r$f.root, col="red", pch=16)
abline(0, 0, col="gray", lty="dashed")

arrows(0, 1, r$root, 0, length=0.2)
text(0, 1, "Root found\n by uniroot", pos=2)
