# Két munkalap létrehozása egy Excel fájlban

library(MASS)
data(Pima.te)
data(Pima.tr)

if (file.exists("Pima.xls")) file.remove("Pima.xls")

library(RODBC)
channel <- odbcConnectExcel("Pima.xls", readOnly=FALSE)
if (channel == -1) stop("failed to open Pima.xls")
tryCatch(
	{
		sqlSave(channel, Pima.te, "Pima_te", rownames="row_number", varTypes=list(row_number="integer"))
		sqlSave(channel, Pima.tr, "Pima_tr", rownames="row_number", varTypes=list(row_number="integer"))
	},
	error=function(e) {
		print("Error")
	},
	finally=close(channel)
)
