library(RSQLite)
conn <- dbConnect(dbDriver("SQLite"), dbname="test.db")
dbBeginTransaction(conn)
res <- dbSendQuery(conn, "DELETE FROM mtcars WHERE mpg < 20")
dbHasCompleted(res)
rows <- dbGetRowsAffected(res)
cat("number of rows affected is", rows)
if (rows > 10) {
	warning("rolling back transaction")
	dbRollback(conn)
} else dbCommit(conn)
dbDisconnect(conn)
