machine <- read.csv(
	file="http://archive.ics.uci.edu/ml/machine-learning-databases/cpu-performance/machine.data",
	header=FALSE,
	col.names=c("vendor", "model", "myct", "mmin", "mmax", "cach", "chmin", "chmax", "prp", "erp"),
	row.names=2
)
library(RSQLite)
conn <- dbConnect(dbDriver("SQLite"), dbname="test.db")
dbWriteTable(conn, "machine", machine, overwrite=TRUE)
dbListTables(conn)
data <- dbReadTable(conn, "machine")
identical(data, machine)
data <- transform(data, vendor=factor(vendor))
identical(data, machine)
dbDisconnect(conn)
