write.patterns <- function(x, y, file="data.pat") {
	z <- cbind(x, y)
	write(
		c(
			'SNNS pattern definition file V1.4',
			paste('generated at', date(), '\n'),
			paste('No. of patterns     :', nrow(z)),
			paste('No. of input units  :', ifelse(is.vector(x), 1, ncol(x))),
			paste('No. of output units :', ifelse(is.vector(y), 1, ncol(y))),
			''
		),
		file=file
	)
	write(t(z), ncolumns=ncol(z), file=file, append=TRUE)
}
