inverse.scale <- function(data, center=NULL, scale=NULL, with=data) {
	if (! is.null(with)) {
		center <- attr(data, "scaled:center")
		scale <- attr(data, "scaled:scale")
	}

	if (! is.null(scale)) {
		data <- sweep(data, 2, scale, "*")
		attr(data, "scaled:scale") <- NULL
	}

	if (! is.null(center)) {
		data <- sweep(data, 2, center, "+")
		attr(data, "scaled:center") <- NULL
	}

	data
}
