plotResult <- function(t, r) {
	m <- lm(r ~ t, list(t=t, r=r))
	plot(t, r, pch=20)
	abline(m, col="green")
	abline(0, 1, lty="dotted")
	legend(
		"bottomright",
		c("Data", "d = y", "Fit"),
		pch=c(20, -1, -1),
		lty=c("blank", "dotted", "solid"),
		col=c("black", "black", "green"),
	)
}
