library(R.matlab)

data <- readMat("choles_all.mat")

p <- t(data$p)
t <- t(data$t)

select <- sample(1:nrow(p), size=0.5 * nrow(p))

p.train <- p[select,]
t.train <- t[select,]
t.train <- scale(t.train)

p.test <- p[-select,]
t.test <- t[-select,]
t.test <- scale(
	t.test,
	center=attr(t.train, "scaled:center"),
	scale=attr(t.train, "scaled:scale")
)

library(nnet)

net <- nnet(p.train, t.train, size=20, linout=TRUE, maxit=500)

r <- predict(net, p.test)

plotResult <- function(t, r) {
	m <- lm(r ~ t, list(t=t, r=r))
	plot(t, r, pch=20)
	abline(m, col="green")
	abline(0, 1, lty="dotted")
	legend(
		"bottomright",
		c("Data", "d = y", "Fit"),
		pch=c(20, -1, -1),
		lty=c("blank", "dotted", "solid"),
		col=c("black", "black", "green"),
	)
}

oldPar <- par(no.readonly=TRUE)

par(mfcol=c(1, 3), ask=TRUE)

z <- c("HDL", "LDL", "VLDL")

for (i in 1:3) {
	plotResult(t.test[, i], r[, i])
	title(main=z[i])
}

par(oldPar)
