library(R.matlab)

data <- readMat("choles_all.mat")

p <- t(data$p)
t <- t(data$t)
#	p <- scale(p)
#	t <- scale(t)

library(nnet)

net <- nnet(p, t, size=20, linout=TRUE, maxit=500)

r <- predict(net, p)

plot(t[, 1], r[, 1], pch=20)

m <- lm(r ~ t, list(t=t[, 1], r=r[, 1]))
abline(m, col="green")
abline(0, 1, lty="dotted")

plotResult <- function(t, r) {
	m <- lm(r ~ t, list(t=t, r=r))
	plot(t, r, pch=20)
	abline(m, col="green")
	abline(0, 1, lty="dotted")
	legend(
		"bottomright",
		c("Data", "d = y", "Fit"),
		pch=c(20, -1, -1),
		lty=c("blank", "dotted", "solid"),
		col=c("black", "black", "green"),
	)
}

oldPar <- par(no.readonly=TRUE)

par(mfcol=c(1, 3), ask=TRUE)

z <- c("HDL", "LDL", "VLDL")

for (i in 1:3) {
	plotResult(t[, i], r[, i])
	title(main=z[i])
}

par(oldPar)
