library(gdata)
data <- read.xls("http://archive.ics.uci.edu/ml/machine-learning-databases/concrete/compressive/Concrete_Data.xls")

names(data) <- paste("V", 1:ncol(data), sep="")

summary(data)

x <- data[1:8]
x <- scale(x)

d <- data[[9]]
#	d <- scale(d)
d <- d / 100

library(nnet)

net <- nnet(x, d, size=10, maxit=1000)

y <- predict(net)

plot(y, d, pch=20)

m <- lm(d ~ y, list(y, d))

abline(m, col="green")

abline(0, 1, lty="dotted")
