data <- read.csv("crabdata.csv", header=FALSE)
summary(data)
library(nnet)

selected <- sample(1:nrow(data), 0.75 * nrow(data))

net <- nnet(V7 ~ ., data=data, size=5, subset=selected)

result1 <- predict(net, data[selected, 1:6], type="class")
t1 <- table(data[["V7"]][selected], result1)
print(t1)
cat("accuracy on training set: ", 100 * sum(diag(t1)) / sum(t1), "%\n", sep="")

result2 <- predict(net, data[-selected, 1:6], type="class")
t2 <- table(data[["V7"]][-selected], result2)
print(t2)
cat("accuracy on test set: ", 100 * sum(diag(t2)) / sum(t2), "%\n", sep="")
